package com.google.cloud.hadoop.gcsio;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageReadOptions extends GoogleCloudStorageReadOptions {

  private final int backoffInitialIntervalMillis;

  private final double backoffRandomizationFactor;

  private final double backoffMultiplier;

  private final int backoffMaxIntervalMillis;

  private final int backoffMaxElapsedTimeMillis;

  private final boolean fastFailOnNotFound;

  private final boolean supportGzipEncoding;

  private final long inplaceSeekLimit;

  private final GoogleCloudStorageReadOptions.Fadvise fadvise;

  private final int minRangeRequestSize;

  private final boolean grpcChecksumsEnabled;

  private final long grpcReadTimeoutMillis;

  private final long grpcReadMetadataTimeoutMillis;

  private final boolean grpcReadZeroCopyEnabled;

  private final long grpcReadMessageTimeoutMillis;

  private AutoValue_GoogleCloudStorageReadOptions(
      int backoffInitialIntervalMillis,
      double backoffRandomizationFactor,
      double backoffMultiplier,
      int backoffMaxIntervalMillis,
      int backoffMaxElapsedTimeMillis,
      boolean fastFailOnNotFound,
      boolean supportGzipEncoding,
      long inplaceSeekLimit,
      GoogleCloudStorageReadOptions.Fadvise fadvise,
      int minRangeRequestSize,
      boolean grpcChecksumsEnabled,
      long grpcReadTimeoutMillis,
      long grpcReadMetadataTimeoutMillis,
      boolean grpcReadZeroCopyEnabled,
      long grpcReadMessageTimeoutMillis) {
    this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
    this.backoffRandomizationFactor = backoffRandomizationFactor;
    this.backoffMultiplier = backoffMultiplier;
    this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
    this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
    this.fastFailOnNotFound = fastFailOnNotFound;
    this.supportGzipEncoding = supportGzipEncoding;
    this.inplaceSeekLimit = inplaceSeekLimit;
    this.fadvise = fadvise;
    this.minRangeRequestSize = minRangeRequestSize;
    this.grpcChecksumsEnabled = grpcChecksumsEnabled;
    this.grpcReadTimeoutMillis = grpcReadTimeoutMillis;
    this.grpcReadMetadataTimeoutMillis = grpcReadMetadataTimeoutMillis;
    this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
    this.grpcReadMessageTimeoutMillis = grpcReadMessageTimeoutMillis;
  }

  @Override
  public int getBackoffInitialIntervalMillis() {
    return backoffInitialIntervalMillis;
  }

  @Override
  public double getBackoffRandomizationFactor() {
    return backoffRandomizationFactor;
  }

  @Override
  public double getBackoffMultiplier() {
    return backoffMultiplier;
  }

  @Override
  public int getBackoffMaxIntervalMillis() {
    return backoffMaxIntervalMillis;
  }

  @Override
  public int getBackoffMaxElapsedTimeMillis() {
    return backoffMaxElapsedTimeMillis;
  }

  @Override
  public boolean getFastFailOnNotFound() {
    return fastFailOnNotFound;
  }

  @Override
  public boolean getSupportGzipEncoding() {
    return supportGzipEncoding;
  }

  @Override
  public long getInplaceSeekLimit() {
    return inplaceSeekLimit;
  }

  @Override
  public GoogleCloudStorageReadOptions.Fadvise getFadvise() {
    return fadvise;
  }

  @Override
  public int getMinRangeRequestSize() {
    return minRangeRequestSize;
  }

  @Override
  public boolean isGrpcChecksumsEnabled() {
    return grpcChecksumsEnabled;
  }

  @Override
  public long getGrpcReadTimeoutMillis() {
    return grpcReadTimeoutMillis;
  }

  @Override
  public long getGrpcReadMetadataTimeoutMillis() {
    return grpcReadMetadataTimeoutMillis;
  }

  @Override
  public boolean isGrpcReadZeroCopyEnabled() {
    return grpcReadZeroCopyEnabled;
  }

  @Override
  public long getGrpcReadMessageTimeoutMillis() {
    return grpcReadMessageTimeoutMillis;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageReadOptions{"
        + "backoffInitialIntervalMillis=" + backoffInitialIntervalMillis + ", "
        + "backoffRandomizationFactor=" + backoffRandomizationFactor + ", "
        + "backoffMultiplier=" + backoffMultiplier + ", "
        + "backoffMaxIntervalMillis=" + backoffMaxIntervalMillis + ", "
        + "backoffMaxElapsedTimeMillis=" + backoffMaxElapsedTimeMillis + ", "
        + "fastFailOnNotFound=" + fastFailOnNotFound + ", "
        + "supportGzipEncoding=" + supportGzipEncoding + ", "
        + "inplaceSeekLimit=" + inplaceSeekLimit + ", "
        + "fadvise=" + fadvise + ", "
        + "minRangeRequestSize=" + minRangeRequestSize + ", "
        + "grpcChecksumsEnabled=" + grpcChecksumsEnabled + ", "
        + "grpcReadTimeoutMillis=" + grpcReadTimeoutMillis + ", "
        + "grpcReadMetadataTimeoutMillis=" + grpcReadMetadataTimeoutMillis + ", "
        + "grpcReadZeroCopyEnabled=" + grpcReadZeroCopyEnabled + ", "
        + "grpcReadMessageTimeoutMillis=" + grpcReadMessageTimeoutMillis
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageReadOptions) {
      GoogleCloudStorageReadOptions that = (GoogleCloudStorageReadOptions) o;
      return this.backoffInitialIntervalMillis == that.getBackoffInitialIntervalMillis()
          && Double.doubleToLongBits(this.backoffRandomizationFactor) == Double.doubleToLongBits(that.getBackoffRandomizationFactor())
          && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier())
          && this.backoffMaxIntervalMillis == that.getBackoffMaxIntervalMillis()
          && this.backoffMaxElapsedTimeMillis == that.getBackoffMaxElapsedTimeMillis()
          && this.fastFailOnNotFound == that.getFastFailOnNotFound()
          && this.supportGzipEncoding == that.getSupportGzipEncoding()
          && this.inplaceSeekLimit == that.getInplaceSeekLimit()
          && this.fadvise.equals(that.getFadvise())
          && this.minRangeRequestSize == that.getMinRangeRequestSize()
          && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled()
          && this.grpcReadTimeoutMillis == that.getGrpcReadTimeoutMillis()
          && this.grpcReadMetadataTimeoutMillis == that.getGrpcReadMetadataTimeoutMillis()
          && this.grpcReadZeroCopyEnabled == that.isGrpcReadZeroCopyEnabled()
          && this.grpcReadMessageTimeoutMillis == that.getGrpcReadMessageTimeoutMillis();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= backoffInitialIntervalMillis;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffRandomizationFactor) >>> 32) ^ Double.doubleToLongBits(backoffRandomizationFactor));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffMultiplier) >>> 32) ^ Double.doubleToLongBits(backoffMultiplier));
    h$ *= 1000003;
    h$ ^= backoffMaxIntervalMillis;
    h$ *= 1000003;
    h$ ^= backoffMaxElapsedTimeMillis;
    h$ *= 1000003;
    h$ ^= fastFailOnNotFound ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= supportGzipEncoding ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((inplaceSeekLimit >>> 32) ^ inplaceSeekLimit);
    h$ *= 1000003;
    h$ ^= fadvise.hashCode();
    h$ *= 1000003;
    h$ ^= minRangeRequestSize;
    h$ *= 1000003;
    h$ ^= grpcChecksumsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((grpcReadTimeoutMillis >>> 32) ^ grpcReadTimeoutMillis);
    h$ *= 1000003;
    h$ ^= (int) ((grpcReadMetadataTimeoutMillis >>> 32) ^ grpcReadMetadataTimeoutMillis);
    h$ *= 1000003;
    h$ ^= grpcReadZeroCopyEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((grpcReadMessageTimeoutMillis >>> 32) ^ grpcReadMessageTimeoutMillis);
    return h$;
  }

  @Override
  public GoogleCloudStorageReadOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageReadOptions.Builder {
    private Integer backoffInitialIntervalMillis;
    private Double backoffRandomizationFactor;
    private Double backoffMultiplier;
    private Integer backoffMaxIntervalMillis;
    private Integer backoffMaxElapsedTimeMillis;
    private Boolean fastFailOnNotFound;
    private Boolean supportGzipEncoding;
    private Long inplaceSeekLimit;
    private GoogleCloudStorageReadOptions.Fadvise fadvise;
    private Integer minRangeRequestSize;
    private Boolean grpcChecksumsEnabled;
    private Long grpcReadTimeoutMillis;
    private Long grpcReadMetadataTimeoutMillis;
    private Boolean grpcReadZeroCopyEnabled;
    private Long grpcReadMessageTimeoutMillis;
    Builder() {
    }
    private Builder(GoogleCloudStorageReadOptions source) {
      this.backoffInitialIntervalMillis = source.getBackoffInitialIntervalMillis();
      this.backoffRandomizationFactor = source.getBackoffRandomizationFactor();
      this.backoffMultiplier = source.getBackoffMultiplier();
      this.backoffMaxIntervalMillis = source.getBackoffMaxIntervalMillis();
      this.backoffMaxElapsedTimeMillis = source.getBackoffMaxElapsedTimeMillis();
      this.fastFailOnNotFound = source.getFastFailOnNotFound();
      this.supportGzipEncoding = source.getSupportGzipEncoding();
      this.inplaceSeekLimit = source.getInplaceSeekLimit();
      this.fadvise = source.getFadvise();
      this.minRangeRequestSize = source.getMinRangeRequestSize();
      this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
      this.grpcReadTimeoutMillis = source.getGrpcReadTimeoutMillis();
      this.grpcReadMetadataTimeoutMillis = source.getGrpcReadMetadataTimeoutMillis();
      this.grpcReadZeroCopyEnabled = source.isGrpcReadZeroCopyEnabled();
      this.grpcReadMessageTimeoutMillis = source.getGrpcReadMessageTimeoutMillis();
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffInitialIntervalMillis(int backoffInitialIntervalMillis) {
      this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
      this.backoffRandomizationFactor = backoffRandomizationFactor;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMultiplier(double backoffMultiplier) {
      this.backoffMultiplier = backoffMultiplier;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxIntervalMillis(int backoffMaxIntervalMillis) {
      this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxElapsedTimeMillis(int backoffMaxElapsedTimeMillis) {
      this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFastFailOnNotFound(boolean fastFailOnNotFound) {
      this.fastFailOnNotFound = fastFailOnNotFound;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setSupportGzipEncoding(boolean supportGzipEncoding) {
      this.supportGzipEncoding = supportGzipEncoding;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setInplaceSeekLimit(long inplaceSeekLimit) {
      this.inplaceSeekLimit = inplaceSeekLimit;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFadvise(GoogleCloudStorageReadOptions.Fadvise fadvise) {
      if (fadvise == null) {
        throw new NullPointerException("Null fadvise");
      }
      this.fadvise = fadvise;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setMinRangeRequestSize(int minRangeRequestSize) {
      this.minRangeRequestSize = minRangeRequestSize;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
      this.grpcChecksumsEnabled = grpcChecksumsEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadTimeoutMillis(long grpcReadTimeoutMillis) {
      this.grpcReadTimeoutMillis = grpcReadTimeoutMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadMetadataTimeoutMillis(long grpcReadMetadataTimeoutMillis) {
      this.grpcReadMetadataTimeoutMillis = grpcReadMetadataTimeoutMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadZeroCopyEnabled(boolean grpcReadZeroCopyEnabled) {
      this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadMessageTimeoutMillis(long grpcReadMessageTimeoutMillis) {
      this.grpcReadMessageTimeoutMillis = grpcReadMessageTimeoutMillis;
      return this;
    }
    @Override
    GoogleCloudStorageReadOptions autoBuild() {
      if (this.backoffInitialIntervalMillis == null
          || this.backoffRandomizationFactor == null
          || this.backoffMultiplier == null
          || this.backoffMaxIntervalMillis == null
          || this.backoffMaxElapsedTimeMillis == null
          || this.fastFailOnNotFound == null
          || this.supportGzipEncoding == null
          || this.inplaceSeekLimit == null
          || this.fadvise == null
          || this.minRangeRequestSize == null
          || this.grpcChecksumsEnabled == null
          || this.grpcReadTimeoutMillis == null
          || this.grpcReadMetadataTimeoutMillis == null
          || this.grpcReadZeroCopyEnabled == null
          || this.grpcReadMessageTimeoutMillis == null) {
        StringBuilder missing = new StringBuilder();
        if (this.backoffInitialIntervalMillis == null) {
          missing.append(" backoffInitialIntervalMillis");
        }
        if (this.backoffRandomizationFactor == null) {
          missing.append(" backoffRandomizationFactor");
        }
        if (this.backoffMultiplier == null) {
          missing.append(" backoffMultiplier");
        }
        if (this.backoffMaxIntervalMillis == null) {
          missing.append(" backoffMaxIntervalMillis");
        }
        if (this.backoffMaxElapsedTimeMillis == null) {
          missing.append(" backoffMaxElapsedTimeMillis");
        }
        if (this.fastFailOnNotFound == null) {
          missing.append(" fastFailOnNotFound");
        }
        if (this.supportGzipEncoding == null) {
          missing.append(" supportGzipEncoding");
        }
        if (this.inplaceSeekLimit == null) {
          missing.append(" inplaceSeekLimit");
        }
        if (this.fadvise == null) {
          missing.append(" fadvise");
        }
        if (this.minRangeRequestSize == null) {
          missing.append(" minRangeRequestSize");
        }
        if (this.grpcChecksumsEnabled == null) {
          missing.append(" grpcChecksumsEnabled");
        }
        if (this.grpcReadTimeoutMillis == null) {
          missing.append(" grpcReadTimeoutMillis");
        }
        if (this.grpcReadMetadataTimeoutMillis == null) {
          missing.append(" grpcReadMetadataTimeoutMillis");
        }
        if (this.grpcReadZeroCopyEnabled == null) {
          missing.append(" grpcReadZeroCopyEnabled");
        }
        if (this.grpcReadMessageTimeoutMillis == null) {
          missing.append(" grpcReadMessageTimeoutMillis");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageReadOptions(
          this.backoffInitialIntervalMillis,
          this.backoffRandomizationFactor,
          this.backoffMultiplier,
          this.backoffMaxIntervalMillis,
          this.backoffMaxElapsedTimeMillis,
          this.fastFailOnNotFound,
          this.supportGzipEncoding,
          this.inplaceSeekLimit,
          this.fadvise,
          this.minRangeRequestSize,
          this.grpcChecksumsEnabled,
          this.grpcReadTimeoutMillis,
          this.grpcReadMetadataTimeoutMillis,
          this.grpcReadZeroCopyEnabled,
          this.grpcReadMessageTimeoutMillis);
    }
  }

}
