/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStrings;
import com.google.cloud.hadoop.gcsio.ListFolderOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.testing.InMemoryBucketEntry;
import com.google.cloud.hadoop.gcsio.testing.InMemoryObjectEntry;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class InMemoryGoogleCloudStorage
implements GoogleCloudStorage {
    private static final CreateObjectOptions EMPTY_OBJECT_CREATE_OPTIONS = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setEnsureEmptyObjectsMetadataMatch(false).build();
    private final Map<String, InMemoryBucketEntry> bucketLookup = new TreeMap<String, InMemoryBucketEntry>();
    private final GoogleCloudStorageOptions storageOptions;
    private final Clock clock;

    public InMemoryGoogleCloudStorage() {
        this(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions());
    }

    public InMemoryGoogleCloudStorage(GoogleCloudStorageOptions storageOptions) {
        this(storageOptions, Clock.SYSTEM);
    }

    public InMemoryGoogleCloudStorage(GoogleCloudStorageOptions storageOptions, Clock clock) {
        this.storageOptions = storageOptions;
        this.clock = clock;
    }

    public static GoogleCloudStorageOptions getInMemoryGoogleCloudStorageOptions() {
        return GoogleCloudStorageOptions.builder().setAppName("GHFS/in-memory").build();
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.storageOptions;
    }

    private boolean validateBucketName(String bucketName) {
        if (Strings.isNullOrEmpty((String)bucketName)) {
            return false;
        }
        if (bucketName.length() < 3) {
            return false;
        }
        if (!bucketName.matches("^[a-z0-9][a-z0-9_.-]*[a-z0-9]$")) {
            return false;
        }
        return bucketName.length() <= 63;
    }

    private boolean validateObjectName(String objectName) {
        return objectName.length() <= 1024 && objectName.indexOf(10) <= -1 && objectName.indexOf(13) <= -1;
    }

    @Override
    public synchronized WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        GoogleCloudStorageItemInfo itemInfo;
        if (!this.bucketLookup.containsKey(resourceId.getBucketName())) {
            throw new IOException(String.format("Tried to insert object '%s' into nonexistent bucket '%s'", resourceId.getObjectName(), resourceId.getBucketName()));
        }
        if (!this.validateObjectName(resourceId.getObjectName())) {
            throw new IOException("Error creating object. Invalid name: " + resourceId.getObjectName());
        }
        if (resourceId.hasGenerationId() && resourceId.getGenerationId() != 0L && (itemInfo = this.getItemInfo(resourceId)).getContentGeneration() != resourceId.getGenerationId()) {
            throw new IOException(String.format("Required generationId '%d' doesn't match existing '%d' for '%s'", resourceId.getGenerationId(), itemInfo.getContentGeneration(), resourceId));
        }
        if ((!options.isOverwriteExisting() || resourceId.getGenerationId() == 0L) && this.getItemInfo(resourceId).exists()) {
            throw new FileAlreadyExistsException(String.format("%s exists.", resourceId));
        }
        InMemoryObjectEntry entry = new InMemoryObjectEntry(resourceId.getBucketName(), resourceId.getObjectName(), this.clock.currentTimeMillis(), this.clock.currentTimeMillis(), options.getContentType(), options.getContentEncoding(), (Map<String, byte[]>)options.getMetadata());
        this.bucketLookup.get(resourceId.getBucketName()).add(entry);
        return entry.getWriteChannel();
    }

    @Override
    public synchronized void createBucket(String bucketName, CreateBucketOptions options) throws IOException {
        if (!this.validateBucketName(bucketName)) {
            throw new IOException("Error creating bucket. Invalid name: " + bucketName);
        }
        if (this.bucketLookup.containsKey(bucketName)) {
            throw new FileAlreadyExistsException("Bucket '" + bucketName + "' already exists");
        }
        this.bucketLookup.put(bucketName, new InMemoryBucketEntry(bucketName, this.clock.currentTimeMillis(), this.clock.currentTimeMillis(), options));
    }

    @Override
    public synchronized void createEmptyObject(StorageResourceId resourceId) throws IOException {
        this.createEmptyObject(resourceId, EMPTY_OBJECT_CREATE_OPTIONS);
    }

    @Override
    public synchronized void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        this.create(resourceId, options).close();
    }

    @Override
    public synchronized void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, EMPTY_OBJECT_CREATE_OPTIONS);
    }

    @Override
    public synchronized void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        for (StorageResourceId resourceId : resourceIds) {
            this.createEmptyObject(resourceId, options);
        }
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        if (!this.getItemInfo(resourceId).exists()) {
            final FileNotFoundException notFoundException = GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), null);
            if (readOptions.getFastFailOnNotFound()) {
                throw notFoundException;
            }
            return new SeekableByteChannel(){
                private long position = 0L;
                private boolean isOpen = true;

                @Override
                public long position() {
                    return this.position;
                }

                @Override
                public SeekableByteChannel position(long newPosition) {
                    this.position = newPosition;
                    return this;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    throw notFoundException;
                }

                @Override
                public long size() throws IOException {
                    throw notFoundException;
                }

                @Override
                public SeekableByteChannel truncate(long size) {
                    throw new UnsupportedOperationException("Cannot mutate read-only channel");
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    throw new UnsupportedOperationException("Cannot mutate read-only channel");
                }

                @Override
                public void close() {
                    this.isOpen = false;
                }

                @Override
                public boolean isOpen() {
                    return this.isOpen;
                }
            };
        }
        return this.bucketLookup.get(resourceId.getBucketName()).get(resourceId.getObjectName()).getReadChannel(resourceId.getBucketName(), resourceId.getObjectName(), readOptions);
    }

    @Override
    public synchronized void deleteBuckets(List<String> bucketNames) throws IOException {
        boolean hasError = false;
        for (String bucketName : bucketNames) {
            if (this.bucketLookup.containsKey(bucketName)) {
                this.bucketLookup.remove(bucketName);
            } else {
                hasError = true;
            }
            hasError = hasError || !this.validateBucketName(bucketName);
        }
        if (hasError) {
            throw new IOException("Error deleting");
        }
    }

    @Override
    public synchronized void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        for (StorageResourceId resourceId : fullObjectNames) {
            if (this.validateObjectName(resourceId.getObjectName())) continue;
            throw new IOException("Error deleting object. Invalid name: " + resourceId.getObjectName());
        }
        for (StorageResourceId fullObjectName : fullObjectNames) {
            GoogleCloudStorageItemInfo existingInfo;
            String bucketName = fullObjectName.getBucketName();
            String objectName = fullObjectName.getObjectName();
            if (fullObjectName.hasGenerationId() && (existingInfo = this.getItemInfo(fullObjectName)).getContentGeneration() != fullObjectName.getGenerationId()) {
                throw new IOException(String.format("Required generationId '%d' doesn't match existing '%d' for '%s'", fullObjectName.getGenerationId(), existingInfo.getContentGeneration(), fullObjectName));
            }
            this.bucketLookup.get(bucketName).remove(objectName);
        }
    }

    @Override
    public void deleteFolders(List<FolderInfo> folders) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public synchronized void move(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        if (sourceToDestinationObjectsMap == null) {
            throw new IllegalArgumentException("sourceToDestinationObjectsMap must not be null");
        }
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
            StorageResourceId srcObject = entry.getKey();
            StorageResourceId dstObject = entry.getValue();
            if (!this.validateObjectName(srcObject.getObjectName()) || !this.validateObjectName(dstObject.getObjectName())) {
                innerExceptions.add(new IOException(String.format("Invalid object name for move source '%s' or destination '%s'", srcObject, dstObject)));
                continue;
            }
            try {
                GoogleCloudStorageItemInfo srcInfo = this.getItemInfo(srcObject);
                if (!srcInfo.exists()) {
                    innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcObject.getBucketName(), srcObject.getObjectName(), null));
                    continue;
                }
                InMemoryBucketEntry srcBucketEntry = this.bucketLookup.get(srcObject.getBucketName());
                InMemoryObjectEntry srcEntry = srcBucketEntry.get(srcObject.getObjectName());
                this.bucketLookup.get(dstObject.getBucketName()).add(srcEntry.getShallowCopy(dstObject.getBucketName(), dstObject.getObjectName()));
                srcBucketEntry.remove(srcObject.getObjectName());
            }
            catch (IOException e) {
                innerExceptions.add(e);
            }
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public synchronized void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames, this);
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            if (!this.getItemInfo(new StorageResourceId(srcBucketName, srcObjectNames.get(i))).exists()) {
                innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectNames.get(i), null));
                continue;
            }
            InMemoryObjectEntry srcObject = this.bucketLookup.get(srcBucketName).get(srcObjectNames.get(i));
            this.bucketLookup.get(dstBucketName).add(srcObject.getShallowCopy(dstBucketName, dstObjectNames.get(i)));
        }
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public synchronized List<String> listBucketNames() throws IOException {
        return new ArrayList<String>(this.bucketLookup.keySet());
    }

    @Override
    public synchronized List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (InMemoryBucketEntry entry : this.bucketLookup.values()) {
            bucketInfos.add(entry.getInfo());
        }
        return bucketInfos;
    }

    private synchronized List<String> listObjectNames(String bucketName, String objectNamePrefix, ListObjectOptions listOptions) {
        InMemoryBucketEntry bucketEntry = this.bucketLookup.get(bucketName);
        if (bucketEntry == null) {
            return new ArrayList<String>();
        }
        TreeSet<String> uniqueNames = new TreeSet<String>();
        for (String objectName : bucketEntry.getObjectNames()) {
            String processedName = GoogleCloudStorageStrings.matchListPrefix(objectNamePrefix, objectName, listOptions);
            if (processedName != null) {
                uniqueNames.add(processedName);
            }
            if (listOptions.getMaxResults() <= 0L || (long)uniqueNames.size() < listOptions.getMaxResults()) continue;
            break;
        }
        if (listOptions.isIncludePrefix() && !uniqueNames.isEmpty() && objectNamePrefix != null) {
            uniqueNames.add(objectNamePrefix);
        }
        return new ArrayList<String>(uniqueNames);
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, ListObjectOptions listOptions, String pageToken) throws IOException {
        return new GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo>(this.listObjectInfo(bucketName, objectNamePrefix, listOptions), null);
    }

    @Override
    public GoogleCloudStorage.ListPage<FolderInfo> listFolderInfoForPrefixPage(String bucketName, String objectNamePrefix, ListFolderOptions listFolderOptions, String pageToken) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public synchronized List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, ListObjectOptions listOptions) throws IOException {
        List<String> listedNames = this.listObjectNames(bucketName, objectNamePrefix, listOptions.toBuilder().setMaxResults(-1L).build());
        ArrayList<GoogleCloudStorageItemInfo> listedInfo = new ArrayList<GoogleCloudStorageItemInfo>();
        for (String objectName : listedNames) {
            GoogleCloudStorageItemInfo itemInfo = this.getItemInfo(new StorageResourceId(bucketName, objectName));
            if (itemInfo.exists()) {
                listedInfo.add(itemInfo);
            } else if (itemInfo.getResourceId().isStorageObject()) {
                listedInfo.add(GoogleCloudStorageItemInfo.createInferredDirectory(itemInfo.getResourceId()));
            }
            if (listOptions.getMaxResults() <= 0L || (long)listedInfo.size() < listOptions.getMaxResults()) continue;
            break;
        }
        return listedInfo;
    }

    @Override
    public void renameHnFolder(URI src, URI dst) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public boolean isHnBucket(URI src) throws IOException {
        return false;
    }

    @Override
    public synchronized GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        if (resourceId.isBucket()) {
            if (this.bucketLookup.containsKey(resourceId.getBucketName())) {
                return this.bucketLookup.get(resourceId.getBucketName()).getInfo();
            }
        } else {
            if (!this.validateObjectName(resourceId.getObjectName())) {
                throw new IOException(String.format("Invalid object name: '%s'", resourceId.getObjectName()));
            }
            if (this.bucketLookup.containsKey(resourceId.getBucketName()) && this.bucketLookup.get(resourceId.getBucketName()).get(resourceId.getObjectName()) != null) {
                return this.bucketLookup.get(resourceId.getBucketName()).get(resourceId.getObjectName()).getInfo();
            }
        }
        return GoogleCloudStorageItemInfo.createNotFound(resourceId);
    }

    @Override
    public synchronized List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> itemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            try {
                itemInfos.add(this.getItemInfo(resourceId));
            }
            catch (IOException ioe) {
                throw new IOException("Error getting StorageObject", ioe);
            }
        }
        return itemInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> itemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo updatableItemInfo : itemInfoList) {
            StorageResourceId resourceId = updatableItemInfo.getStorageResourceId();
            Preconditions.checkArgument((!resourceId.isRoot() && !resourceId.isBucket() ? 1 : 0) != 0, (Object)"Can't update item on GCS Root or bucket resources");
            if (!this.validateObjectName(resourceId.getObjectName())) {
                throw new IOException("Error accessing");
            }
            if (this.bucketLookup.containsKey(resourceId.getBucketName()) && this.bucketLookup.get(resourceId.getBucketName()).get(resourceId.getObjectName()) != null) {
                InMemoryObjectEntry objectEntry = this.bucketLookup.get(resourceId.getBucketName()).get(resourceId.getObjectName());
                objectEntry.patchMetadata(updatableItemInfo.getMetadata());
                itemInfos.add(this.getItemInfo(resourceId));
                continue;
            }
            throw new IOException(String.format("Error getting StorageObject %s", resourceId.toString()));
        }
        return itemInfos;
    }

    @Override
    public void close() {
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        List sourceResourcesIds = Lists.transform(sources, s -> new StorageResourceId(bucketName, (String)s));
        StorageResourceId destinationId = new StorageResourceId(bucketName, destination);
        CreateObjectOptions options = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType(contentType).build();
        this.composeObjects(sourceResourcesIds, destinationId, options);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        Preconditions.checkArgument((sources.size() <= 32 ? 1 : 0) != 0, (String)"Can not compose more than %s sources", (int)32);
        ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
        for (StorageResourceId sourceId : sources) {
            SeekableByteChannel sourceChannel = this.open(sourceId);
            Throwable throwable = null;
            try {
                int bytesRead;
                byte[] bufferArray = new byte[0x400000];
                do {
                    ByteBuffer buffer = ByteBuffer.wrap(bufferArray);
                    bytesRead = sourceChannel.read(buffer);
                    tempOutput.write(bufferArray, 0, buffer.position());
                } while (bytesRead >= 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sourceChannel == null) continue;
                if (throwable != null) {
                    try {
                        sourceChannel.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sourceChannel.close();
            }
        }
        WritableByteChannel destChannel = this.create(destination, options);
        destChannel.write(ByteBuffer.wrap(tempOutput.toByteArray()));
        destChannel.close();
        return this.getItemInfo(destination);
    }
}

