/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListFileOptions;
import com.google.cloud.hadoop.gcsio.ListFolderOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationDelete;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationRename;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.CheckedFunction;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.util.ITraceOperation;
import com.google.cloud.hadoop.util.LazyExecutorService;
import com.google.cloud.hadoop.util.ThreadTrace;
import com.google.cloud.hadoop.util.TraceOperation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GoogleCloudStorageFileSystem {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String SCHEME = "gs";
    public static final URI GCS_ROOT = URI.create("gs:/");
    private static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("gcsfs-thread-%d").setDaemon(true).build();
    private static final ListObjectOptions GET_FILE_INFO_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).setMaxResults(1L).build();
    private static final ListObjectOptions LIST_FILE_INFO_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    public static final ListFileOptions DELETE_RENAME_LIST_OPTIONS = ListFileOptions.DEFAULT.toBuilder().setFields("bucket,name,generation").build();
    private GoogleCloudStorage gcs;
    private final GoogleCloudStorageFileSystemOptions options;
    private ExecutorService cachedExecutor = GoogleCloudStorageFileSystem.createCachedExecutor();
    private ExecutorService lazyExecutor = new LazyExecutorService();
    @VisibleForTesting
    static final Comparator<URI> PATH_COMPARATOR = Comparator.comparing(URI::toString, (as, bs) -> as.length() == bs.length() ? as.compareTo((String)bs) : Integer.compare(as.length(), bs.length()));
    @VisibleForTesting
    static final Comparator<FileInfo> FILE_INFO_PATH_COMPARATOR = Comparator.comparing(FileInfo::getPath, PATH_COMPARATOR);

    private static GoogleCloudStorage createCloudStorage(GoogleCloudStorageFileSystemOptions options, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        switch (options.getClientType()) {
            case STORAGE_CLIENT: {
                return GoogleCloudStorageClientImpl.builder().setOptions(options.getCloudStorageOptions()).setCredentials((Credentials)(credential == null ? null : new CredentialAdapter(credential))).setCredential(credential).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build();
            }
        }
        return new GoogleCloudStorageImpl(options.getCloudStorageOptions(), credential, downscopedAccessTokenFn);
    }

    public GoogleCloudStorageFileSystem(Credential credential, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this(GoogleCloudStorageFileSystem.createCloudStorage(options, credential, null), options);
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleCloudStorageFileSystem(options: %s)", (Object)options);
    }

    public GoogleCloudStorageFileSystem(Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this(GoogleCloudStorageFileSystem.createCloudStorage(options, credential, downscopedAccessTokenFn), options);
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleCloudStorageFileSystem(options: %s)", (Object)options);
    }

    @VisibleForTesting
    public GoogleCloudStorageFileSystem(CheckedFunction<GoogleCloudStorageOptions, GoogleCloudStorage, IOException> gcsFn, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this((GoogleCloudStorage)gcsFn.apply((Object)options.getCloudStorageOptions()), options);
    }

    private GoogleCloudStorageFileSystem(GoogleCloudStorage gcs, GoogleCloudStorageFileSystemOptions options) {
        Preconditions.checkArgument((gcs.getOptions() == options.getCloudStorageOptions() ? 1 : 0) != 0, (Object)"gcs and gcsfs should use the same options");
        options.throwIfNotValid();
        this.gcs = options.isPerformanceCacheEnabled() ? new PerformanceCachingGoogleCloudStorage(gcs, options.getPerformanceCacheOptions()) : gcs;
        this.options = options;
    }

    private static ExecutorService createCachedExecutor() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcsfs-misc-%d").setDaemon(true).build());
        service.allowCoreThreadTimeOut(true);
        return service;
    }

    public GoogleCloudStorageFileSystemOptions getOptions() {
        return this.options;
    }

    public static CreateObjectOptions objectOptionsFromFileOptions(CreateFileOptions options) {
        return CreateObjectOptions.builder().setContentType(options.getContentType()).setMetadata((Map<String, byte[]>)options.getAttributes()).setOverwriteExisting(options.isOverwriteExisting()).build();
    }

    public WritableByteChannel create(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(path: %s)", (Object)path);
        return this.create(path, CreateFileOptions.DEFAULT_OVERWRITE);
    }

    public WritableByteChannel create(URI path, CreateFileOptions createOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(path: %s, createOptions: %s)", (Object)path, (Object)createOptions);
        Preconditions.checkNotNull((Object)path, (Object)"path could not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isDirectory()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Cannot create a file whose name looks like a directory: '%s'", resourceId));
        }
        if (this.options.isEnsureNoConflictingItems()) {
            StorageResourceId dirId = resourceId.toDirectoryId();
            ListenableFuture conflictingDirExist = createOptions.isEnsureNoDirectoryConflict() ? this.cachedExecutor.submit(() -> this.getFileInfoInternal(dirId, true).exists()) : Futures.immediateFuture((Object)false);
            this.checkNoFilesConflictingWithDirs(resourceId);
            if (((Boolean)GoogleCloudStorageFileSystem.getFromFuture(conflictingDirExist)).booleanValue()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new FileAlreadyExistsException("A directory with that name exists: " + path);
            }
        }
        if (createOptions.getOverwriteGenerationId() != -1L) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), createOptions.getOverwriteGenerationId());
        }
        return this.gcs.create(resourceId, GoogleCloudStorageFileSystem.objectOptionsFromFileOptions(createOptions));
    }

    public SeekableByteChannel open(URI path) throws IOException {
        return this.open(path, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public SeekableByteChannel open(URI path, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(path: %s, readOptions: %s)", (Object)path, (Object)readOptions);
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, false);
        Preconditions.checkArgument((!resourceId.isDirectory() ? 1 : 0) != 0, (String)"Cannot open a directory for reading: %s", (Object)path);
        return this.gcs.open(resourceId, readOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI path, boolean recursive) throws IOException {
        List<Object> itemsToDelete;
        Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        Preconditions.checkArgument((!path.equals(GCS_ROOT) ? 1 : 0) != 0, (String)"Cannot delete root path (%s)", (Object)path);
        ((GoogleLogger.Api)logger.atFiner()).log("delete(path: %s, recursive: %b)", (Object)path, recursive);
        FileInfo fileInfo = this.getFileInfo(path);
        if (!fileInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + path);
        }
        Future<GoogleCloudStorageItemInfo> parentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId parentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(path), true);
            parentInfoFuture = this.cachedExecutor.submit(() -> this.getFileInfoInternal(parentId, false));
        }
        Optional<CoopLockOperationDelete> coopLockOp = this.options.isCooperativeLockingEnabled() && fileInfo.isDirectory() ? Optional.of(CoopLockOperationDelete.create(this.gcs, fileInfo.getPath())) : Optional.empty();
        coopLockOp.ifPresent(CoopLockOperationDelete::lock);
        boolean isHnBucket = this.options.getCloudStorageOptions().isHnBucketRenameEnabled() && this.gcs.isHnBucket(path);
        List<FolderInfo> listOfFolders = new LinkedList<FolderInfo>();
        if (fileInfo.isDirectory()) {
            List<FileInfo> list = itemsToDelete = recursive ? this.listFileInfoForPrefix(fileInfo.getPath(), DELETE_RENAME_LIST_OPTIONS) : this.listFileInfoForPrefixPage(fileInfo.getPath(), DELETE_RENAME_LIST_OPTIONS, null).getItems();
            if (isHnBucket) {
                String bucketName = this.getBucketName(path);
                String folderName = this.getFolderName(path);
                listOfFolders = recursive ? this.listFoldersInfoForPrefixPage(fileInfo.getPath(), ListFolderOptions.DEFAULT, null).getItems() : (folderName.equals("") ? new LinkedList() : Arrays.asList(new FolderInfo(FolderInfo.createFolderInfoObject(bucketName, folderName))));
                ((GoogleLogger.Api)logger.atFiner()).log("Encountered HN enabled bucket with %s number of folder in path : %s", listOfFolders.size(), (Object)path);
            }
            if (!itemsToDelete.isEmpty() && !recursive) {
                GoogleCloudStorageEventBus.postOnException();
                throw new DirectoryNotEmptyException("Cannot delete a non-empty directory.");
            }
        } else {
            itemsToDelete = new ArrayList();
        }
        ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>();
        (fileInfo.getItemInfo().isBucket() ? bucketsToDelete : itemsToDelete).add(fileInfo);
        coopLockOp.ifPresent(o -> o.persistAndScheduleRenewal(itemsToDelete, bucketsToDelete));
        try {
            this.deleteInternalWithFolders(itemsToDelete, listOfFolders, bucketsToDelete);
            coopLockOp.ifPresent(CoopLockOperationDelete::unlock);
        }
        finally {
            coopLockOp.ifPresent(CoopLockOperationDelete::cancelRenewal);
        }
        this.repairImplicitDirectory(parentInfoFuture);
    }

    private String getBucketName(@Nonnull URI path) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)path.getAuthority()) ? 1 : 0) != 0, (String)"Bucket name cannot be null : %s", (Object)path);
        return path.getAuthority();
    }

    private String getFolderName(@Nonnull URI path) {
        Preconditions.checkState((boolean)path.getPath().startsWith("/"), (String)"Invalid folder name: %s", (Object)path.getPath());
        return path.getPath().substring(1);
    }

    public GoogleCloudStorage.ListPage<FolderInfo> listFoldersInfoForPrefixPage(URI prefix, ListFolderOptions listFolderOptions, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listFoldersInfoForPrefixPage(prefix: %s, pageToken:%s)", (Object)prefix, (Object)pageToken);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        return this.gcs.listFolderInfoForPrefixPage(prefixId.getBucketName(), prefixId.getObjectName(), listFolderOptions, pageToken);
    }

    private void deleteFolders(@Nonnull List<FolderInfo> listOfFolders) throws IOException {
        if (listOfFolders.isEmpty()) {
            return;
        }
        ((GoogleLogger.Api)logger.atFiner()).log("deleteFolder(listOfFolders: %s, size:%s)", listOfFolders, listOfFolders.size());
        this.gcs.deleteFolders(listOfFolders);
    }

    private void deleteInternal(List<FileInfo> itemsToDelete, List<FileInfo> bucketsToDelete) throws IOException {
        this.deleteObjects(itemsToDelete);
        this.deleteBucket(bucketsToDelete);
    }

    private void deleteInternalWithFolders(List<FileInfo> itemsToDelete, List<FolderInfo> listOfFolders, List<FileInfo> bucketsToDelete) throws IOException {
        this.deleteObjects(itemsToDelete);
        this.deleteFolders(listOfFolders);
        this.deleteBucket(bucketsToDelete);
    }

    private void deleteObjects(List<FileInfo> itemsToDelete) throws IOException {
        itemsToDelete.sort(FILE_INFO_PATH_COMPARATOR.reversed());
        if (!itemsToDelete.isEmpty()) {
            ArrayList<StorageResourceId> objectsToDelete = new ArrayList<StorageResourceId>(itemsToDelete.size());
            for (FileInfo fileInfo : itemsToDelete) {
                if (fileInfo.isInferredDirectory()) continue;
                objectsToDelete.add(new StorageResourceId(fileInfo.getItemInfo().getBucketName(), fileInfo.getItemInfo().getObjectName(), fileInfo.getItemInfo().getContentGeneration()));
            }
            this.gcs.deleteObjects(objectsToDelete);
        }
    }

    private void deleteBucket(List<FileInfo> bucketsToDelete) throws IOException {
        if (!bucketsToDelete.isEmpty()) {
            ArrayList<String> bucketNames = new ArrayList<String>(bucketsToDelete.size());
            for (FileInfo bucketInfo : bucketsToDelete) {
                bucketNames.add(bucketInfo.getItemInfo().getResourceId().getBucketName());
            }
            if (this.options.isBucketDeleteEnabled()) {
                this.gcs.deleteBuckets(bucketNames);
            } else {
                ((GoogleLogger.Api)logger.atInfo()).log("Skipping deletion of buckets because enableBucketDelete is false: %s", bucketNames);
            }
        }
    }

    public boolean exists(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("exists(path: %s)", (Object)path);
        return this.getFileInfo(path).exists();
    }

    public void mkdirs(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("mkdirs(path: %s)", (Object)path);
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        this.mkdirsInternal(StorageResourceId.fromUriPath(path, true));
    }

    private void mkdirsInternal(StorageResourceId resourceId) throws IOException {
        if (resourceId.isRoot()) {
            return;
        }
        if (resourceId.isBucket()) {
            try {
                this.gcs.createBucket(resourceId.getBucketName());
            }
            catch (FileAlreadyExistsException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause((Throwable)e)).log("mkdirs: %s already exists, ignoring creation failure", (Object)resourceId);
            }
            return;
        }
        resourceId = resourceId.toDirectoryId();
        if (this.options.isEnsureNoConflictingItems()) {
            this.checkNoFilesConflictingWithDirs(resourceId);
        }
        try {
            this.gcs.createEmptyObject(resourceId);
        }
        catch (FileAlreadyExistsException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause((Throwable)e)).log("mkdirs: %s already exists, ignoring creation failure", (Object)resourceId);
        }
    }

    public void rename(URI src, URI dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s)", (Object)src, (Object)dst);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkArgument((!src.equals(GCS_ROOT) ? 1 : 0) != 0, (Object)"Root path cannot be renamed.");
        URI dstParent = UriPaths.getParentPath(dst);
        ArrayList<URI> paths = new ArrayList<URI>();
        paths.add(src);
        paths.add(dst);
        if (dstParent != null) {
            paths.add(dstParent);
        }
        List<FileInfo> fileInfos = this.getFileInfos(paths);
        FileInfo srcInfo = fileInfos.get(0);
        FileInfo dstInfo = fileInfos.get(1);
        src = srcInfo.getPath();
        dst = dstInfo.getPath();
        if (!srcInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + src);
        }
        Optional<CoopLockOperationRename> coopLockOp = this.options.isCooperativeLockingEnabled() && src.getAuthority().equals(dst.getAuthority()) && srcInfo.isDirectory() ? Optional.of(CoopLockOperationRename.create(this.gcs, src, dst)) : Optional.empty();
        coopLockOp.ifPresent(CoopLockOperationRename::lock);
        if (coopLockOp.isPresent()) {
            fileInfos = this.getFileInfos(paths);
            srcInfo = fileInfos.get(0);
            dstInfo = fileInfos.get(1);
            if (!srcInfo.exists()) {
                coopLockOp.ifPresent(CoopLockOperationRename::unlock);
                GoogleCloudStorageEventBus.postOnException();
                throw new FileNotFoundException("Item not found: " + src);
            }
            if (!srcInfo.isDirectory()) {
                coopLockOp.ifPresent(CoopLockOperationRename::unlock);
                coopLockOp = Optional.empty();
            }
        }
        FileInfo dstParentInfo = dstParent == null ? null : fileInfos.get(2);
        try {
            dst = this.getDstUri(srcInfo, dstInfo, dstParentInfo);
        }
        catch (IOException e) {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            throw e;
        }
        if (src.equals(dst)) {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            return;
        }
        Future<GoogleCloudStorageItemInfo> srcParentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId srcParentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(src), true);
            srcParentInfoFuture = this.runFuture(this.cachedExecutor, () -> this.getFileInfoInternal(srcParentId, false), "getParentFileInfo");
        }
        if (srcInfo.isDirectory()) {
            this.renameDirectoryInternal(srcInfo, dst, coopLockOp);
        } else {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            StorageResourceId srcResourceId = StorageResourceId.fromUriPath(src, true);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(dst, true, 0L);
            if (this.options.getCloudStorageOptions().isMoveOperationEnabled() && srcResourceId.getBucketName().equals(dstResourceId.getBucketName())) {
                this.gcs.move((Map<StorageResourceId, StorageResourceId>)ImmutableMap.of((Object)new StorageResourceId(srcInfo.getItemInfo().getBucketName(), srcInfo.getItemInfo().getObjectName(), srcInfo.getItemInfo().getContentGeneration()), (Object)dstResourceId));
            } else {
                this.gcs.copy((Map<StorageResourceId, StorageResourceId>)ImmutableMap.of((Object)srcResourceId, (Object)dstResourceId));
                this.gcs.deleteObjects((List<StorageResourceId>)ImmutableList.of((Object)new StorageResourceId(srcInfo.getItemInfo().getBucketName(), srcInfo.getItemInfo().getObjectName(), srcInfo.getItemInfo().getContentGeneration())));
            }
        }
        this.repairImplicitDirectory(srcParentInfoFuture);
    }

    private <T> Future<T> runFuture(ExecutorService service, Callable<T> task, String name) {
        ThreadTrace trace = TraceOperation.current();
        return service.submit(() -> {
            try (ITraceOperation traceOperation = TraceOperation.getChildTrace((ThreadTrace)trace, (String)name);){
                Object v = task.call();
                return v;
            }
        });
    }

    private URI getDstUri(FileInfo srcInfo, FileInfo dstInfo, @Nullable FileInfo dstParentInfo) throws IOException {
        URI src = srcInfo.getPath();
        URI dst = dstInfo.getPath();
        if (!srcInfo.isDirectory() && dst.equals(GCS_ROOT)) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("A file cannot be created in root.");
        }
        if (dstInfo.exists() && !dstInfo.isDirectory() && (srcInfo.isDirectory() || !dst.equals(src))) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Cannot overwrite an existing file: " + dst);
        }
        if (dstParentInfo != null && !dstParentInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Cannot rename because path does not exist: " + dstParentInfo.getPath());
        }
        String srcItemName = this.getItemName(src);
        if (srcInfo.isDirectory()) {
            if (!dstInfo.isDirectory()) {
                dst = UriPaths.toDirectory(dst);
            }
            if (src.equals(dst)) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Rename dir to self is forbidden");
            }
            URI dstRelativeToSrc = src.relativize(dst);
            if (!dstRelativeToSrc.equals(dst)) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Rename to subdir is forbidden");
            }
            if (dstInfo.exists()) {
                dst = dst.equals(GCS_ROOT) ? UriPaths.fromStringPathComponents(srcItemName, null, true) : UriPaths.toDirectory(dst.resolve(srcItemName));
            }
        } else if (dstInfo.isDirectory()) {
            if (!dstInfo.exists()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Cannot rename because path does not exist: " + dstInfo.getPath());
            }
            dst = dst.resolve(srcItemName);
        }
        return dst;
    }

    public void compose(List<URI> sources, URI destination, String contentType) throws IOException {
        StorageResourceId destResource = StorageResourceId.fromStringPath(destination.toString());
        List sourceObjects = Lists.transform(sources, uri -> StorageResourceId.fromStringPath(uri.toString()).getObjectName());
        this.gcs.compose(destResource.getBucketName(), sourceObjects, destResource.getObjectName(), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameDirectoryInternal(FileInfo srcInfo, URI dst, Optional<CoopLockOperationRename> coopLockOp) throws IOException {
        Preconditions.checkArgument((boolean)srcInfo.isDirectory(), (String)"'%s' should be a directory", (Object)srcInfo);
        Preconditions.checkArgument((boolean)dst.toString().endsWith("/"), (String)"'%s' should be a directory", (Object)dst);
        URI src = srcInfo.getPath();
        if (this.options.getCloudStorageOptions().isHnBucketRenameEnabled() && this.gcs.isHnBucket(src)) {
            this.gcs.renameHnFolder(src, dst);
            return;
        }
        TreeMap<FileInfo, URI> srcToDstItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        TreeMap<FileInfo, URI> srcToDstMarkerItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        List<FileInfo> srcItemInfos = this.listFileInfoForPrefix(src, DELETE_RENAME_LIST_OPTIONS);
        Pattern markerFilePattern = this.options.getMarkerFilePattern();
        String prefix = src.toString();
        for (FileInfo srcItemInfo : srcItemInfos) {
            String relativeItemName = srcItemInfo.getPath().toString().substring(prefix.length());
            URI dstItemName = dst.resolve(relativeItemName);
            if (markerFilePattern != null && markerFilePattern.matcher(relativeItemName).matches()) {
                srcToDstMarkerItemNames.put(srcItemInfo, dstItemName);
                continue;
            }
            srcToDstItemNames.put(srcItemInfo, dstItemName);
        }
        coopLockOp.ifPresent(o -> o.persistAndScheduleRenewal(srcToDstItemNames, srcToDstMarkerItemNames));
        try {
            if (coopLockOp.isPresent()) {
                this.mkdir(dst);
            }
            StorageResourceId srcResourceId = StorageResourceId.fromUriPath(src, true);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(dst, true, 0L);
            if (this.options.getCloudStorageOptions().isMoveOperationEnabled() && srcResourceId.getBucketName().equals(dstResourceId.getBucketName())) {
                this.moveInternal(srcToDstItemNames);
                this.moveInternal(srcToDstMarkerItemNames);
                coopLockOp.ifPresent(CoopLockOperationRename::checkpoint);
                if (srcInfo.getItemInfo().isBucket()) {
                    this.deleteBucket(Collections.singletonList(srcInfo));
                } else {
                    this.deleteObjects(Collections.singletonList(srcInfo));
                }
            } else {
                this.copyInternal(srcToDstItemNames);
                this.copyInternal(srcToDstMarkerItemNames);
                coopLockOp.ifPresent(CoopLockOperationRename::checkpoint);
                ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>(1);
                ArrayList<FileInfo> srcItemsToDelete = new ArrayList<FileInfo>(srcToDstItemNames.size() + 1);
                srcItemsToDelete.addAll(srcToDstItemNames.keySet());
                if (srcInfo.getItemInfo().isBucket()) {
                    bucketsToDelete.add(srcInfo);
                } else {
                    srcItemsToDelete.add(srcInfo);
                }
                this.deleteInternal(new ArrayList<FileInfo>(srcToDstMarkerItemNames.keySet()), new ArrayList<FileInfo>());
                this.deleteInternal(srcItemsToDelete, bucketsToDelete);
            }
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
        }
        finally {
            coopLockOp.ifPresent(CoopLockOperationRename::cancelRenewal);
        }
    }

    private void copyInternal(Map<FileInfo, URI> srcToDstItemNames) throws IOException {
        if (srcToDstItemNames.isEmpty()) {
            return;
        }
        String srcBucketName = null;
        String dstBucketName = null;
        ArrayList<String> srcObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        ArrayList<String> dstObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        for (Map.Entry<FileInfo, URI> srcToDstItemName : srcToDstItemNames.entrySet()) {
            StorageResourceId srcResourceId = srcToDstItemName.getKey().getItemInfo().getResourceId();
            srcBucketName = srcResourceId.getBucketName();
            String srcObjectName = srcResourceId.getObjectName();
            srcObjectNames.add(srcObjectName);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(srcToDstItemName.getValue(), true);
            dstBucketName = dstResourceId.getBucketName();
            String dstObjectName = dstResourceId.getObjectName();
            dstObjectNames.add(dstObjectName);
        }
        this.gcs.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    private void moveInternal(Map<FileInfo, URI> srcToDstItemNames) throws IOException {
        if (srcToDstItemNames.isEmpty()) {
            return;
        }
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>();
        for (Map.Entry<FileInfo, URI> srcToDstItemName : srcToDstItemNames.entrySet()) {
            StorageResourceId srcResourceId = srcToDstItemName.getKey().getItemInfo().getResourceId();
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(srcToDstItemName.getValue(), true);
            sourceToDestinationObjectsMap.put(srcResourceId, dstResourceId);
        }
        this.gcs.move(sourceToDestinationObjectsMap);
    }

    private void repairImplicitDirectory(Future<GoogleCloudStorageItemInfo> infoFuture) throws IOException {
        if (infoFuture == null) {
            return;
        }
        Preconditions.checkState((boolean)this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled(), (Object)"implicit directories auto repair should be enabled");
        GoogleCloudStorageItemInfo info = GoogleCloudStorageFileSystem.getFromFuture(infoFuture);
        StorageResourceId resourceId = info.getResourceId();
        ((GoogleLogger.Api)logger.atFiner()).log("repairImplicitDirectory(resourceId: %s)", (Object)resourceId);
        if (info.exists() || resourceId.isRoot() || resourceId.isBucket() || "/".equals(resourceId.getObjectName())) {
            return;
        }
        Preconditions.checkState((boolean)resourceId.isDirectory(), (String)"'%s' should be a directory", (Object)resourceId);
        try {
            this.gcs.createEmptyObject(resourceId);
            ((GoogleLogger.Api)logger.atInfo()).log("Successfully repaired '%s' directory.", (Object)resourceId);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Failed to repair '%s' directory", (Object)resourceId);
        }
    }

    static <T> T getFromFuture(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Failed to get result: %s with message : %s", e instanceof ExecutionException ? e.getCause() : e, e.getMessage()), e);
        }
    }

    public List<FileInfo> listFileInfoForPrefix(URI prefix) throws IOException {
        return this.listFileInfoForPrefix(prefix, ListFileOptions.DEFAULT);
    }

    public List<FileInfo> listFileInfoForPrefix(URI prefix, ListFileOptions listOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listAllFileInfoForPrefix(prefix: %s)", (Object)prefix);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        List<GoogleCloudStorageItemInfo> itemInfos = this.gcs.listObjectInfo(prefixId.getBucketName(), prefixId.getObjectName(), GoogleCloudStorageFileSystem.updateListObjectOptions(ListObjectOptions.DEFAULT_FLAT_LIST, listOptions));
        List<FileInfo> fileInfos = FileInfo.fromItemInfos(itemInfos);
        fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
        return fileInfos;
    }

    public GoogleCloudStorage.ListPage<FileInfo> listFileInfoForPrefixPage(URI prefix, String pageToken) throws IOException {
        return this.listFileInfoForPrefixPage(prefix, ListFileOptions.DEFAULT, pageToken);
    }

    public GoogleCloudStorage.ListPage<FileInfo> listFileInfoForPrefixPage(URI prefix, ListFileOptions listOptions, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listAllFileInfoForPrefixPage(prefix: %s, pageToken:%s)", (Object)prefix, (Object)pageToken);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> itemInfosPage = this.gcs.listObjectInfoPage(prefixId.getBucketName(), prefixId.getObjectName(), GoogleCloudStorageFileSystem.updateListObjectOptions(ListObjectOptions.DEFAULT_FLAT_LIST, listOptions), pageToken);
        List<FileInfo> fileInfosPage = FileInfo.fromItemInfos(itemInfosPage.getItems());
        fileInfosPage.sort(FILE_INFO_PATH_COMPARATOR);
        return new GoogleCloudStorage.ListPage<FileInfo>(fileInfosPage, itemInfosPage.getNextPageToken());
    }

    private StorageResourceId getPrefixId(URI prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix could not be null");
        StorageResourceId prefixId = StorageResourceId.fromUriPath(prefix, true);
        Preconditions.checkArgument((!prefixId.isRoot() ? 1 : 0) != 0, (String)"prefix must not be global root, got '%s'", (Object)prefix);
        return prefixId;
    }

    public List<FileInfo> listFileInfo(URI path) throws IOException {
        return this.listFileInfo(path, ListFileOptions.DEFAULT);
    }

    public List<FileInfo> listFileInfo(URI path, ListFileOptions listOptions) throws IOException {
        Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("listFileInfo(path: %s)", (Object)path);
        StorageResourceId pathId = StorageResourceId.fromUriPath(path, true);
        StorageResourceId dirId = pathId.toDirectoryId();
        Future<List> dirItemInfosFuture = (this.options.isStatusParallelEnabled() ? this.cachedExecutor : this.lazyExecutor).submit(() -> dirId.isRoot() ? this.gcs.listBucketInfo() : this.gcs.listObjectInfo(dirId.getBucketName(), dirId.getObjectName(), GoogleCloudStorageFileSystem.updateListObjectOptions(LIST_FILE_INFO_LIST_OPTIONS, listOptions)));
        if (!pathId.isDirectory()) {
            try {
                GoogleCloudStorageItemInfo pathInfo = this.gcs.getItemInfo(pathId);
                if (pathInfo.exists()) {
                    ArrayList<FileInfo> listedInfo = new ArrayList<FileInfo>();
                    listedInfo.add(FileInfo.fromItemInfo(pathInfo));
                    dirItemInfosFuture.cancel(true);
                    return listedInfo;
                }
            }
            catch (Exception e) {
                GoogleCloudStorageEventBus.postOnException();
                dirItemInfosFuture.cancel(true);
                throw e;
            }
        }
        List dirItemInfos = GoogleCloudStorageFileSystem.getFromFuture(dirItemInfosFuture);
        if (pathId.isStorageObject() && dirItemInfos.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + path);
        }
        if (!dirItemInfos.isEmpty() && Objects.equals(((GoogleCloudStorageItemInfo)dirItemInfos.get(0)).getResourceId(), dirId)) {
            dirItemInfos.remove(0);
        }
        List<FileInfo> fileInfos = FileInfo.fromItemInfos(dirItemInfos);
        fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
        return fileInfos;
    }

    public FileInfo getFileInfo(URI path) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        FileInfo fileInfo = FileInfo.fromItemInfo(this.getFileInfoInternal(resourceId, true));
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfo(path: %s): %s", (Object)path, (Object)fileInfo);
        return fileInfo;
    }

    private GoogleCloudStorageItemInfo getFileInfoInternal(StorageResourceId resourceId, boolean inferImplicitDirectories) throws IOException {
        List listDirInfo;
        if (resourceId.isRoot() || resourceId.isBucket()) {
            return this.gcs.getItemInfo(resourceId);
        }
        StorageResourceId dirId = resourceId.toDirectoryId();
        Future<List> listDirFuture = (this.options.isStatusParallelEnabled() ? this.cachedExecutor : this.lazyExecutor).submit(() -> inferImplicitDirectories ? this.gcs.listObjectInfo(dirId.getBucketName(), dirId.getObjectName(), GET_FILE_INFO_LIST_OPTIONS) : ImmutableList.of((Object)this.gcs.getItemInfo(dirId)));
        if (!resourceId.isDirectory()) {
            try {
                GoogleCloudStorageItemInfo itemInfo = this.gcs.getItemInfo(resourceId);
                if (itemInfo.exists()) {
                    listDirFuture.cancel(true);
                    return itemInfo;
                }
            }
            catch (Exception e) {
                GoogleCloudStorageEventBus.postOnException();
                listDirFuture.cancel(true);
                throw e;
            }
        }
        if ((listDirInfo = GoogleCloudStorageFileSystem.getFromFuture(listDirFuture)).isEmpty()) {
            return GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        Preconditions.checkState((listDirInfo.size() <= 2 ? 1 : 0) != 0, (String)"listed more than 2 objects: '%s'", (Object)listDirInfo);
        GoogleCloudStorageItemInfo dirInfo = (GoogleCloudStorageItemInfo)Iterables.get((Iterable)listDirInfo, (int)0);
        Preconditions.checkState((dirInfo.getResourceId().equals(dirId) || !inferImplicitDirectories ? 1 : 0) != 0, (String)"listed wrong object '%s', but should be '%s'", (Object)dirInfo.getResourceId(), (Object)resourceId);
        return dirInfo.getResourceId().equals(dirId) && dirInfo.exists() ? dirInfo : GoogleCloudStorageItemInfo.createNotFound(resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> getFileInfos(List<URI> paths) throws IOException {
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0, (Object)"paths must not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfos(paths: %s)", paths);
        if (paths.size() == 1) {
            return new ArrayList<FileInfo>(Collections.singleton(this.getFileInfo(paths.get(0))));
        }
        int maxThreads = this.gcs.getOptions().getBatchThreads();
        ListeningExecutorService fileInfoExecutor = maxThreads == 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(Math.min(maxThreads, paths.size()), DAEMON_THREAD_FACTORY);
        try {
            ArrayList<Future<FileInfo>> infoFutures = new ArrayList<Future<FileInfo>>(paths.size());
            for (URI path : paths) {
                infoFutures.add(this.runFuture((ExecutorService)fileInfoExecutor, () -> this.getFileInfo(path), "getFileInfo"));
            }
            fileInfoExecutor.shutdown();
            ArrayList infos = new ArrayList(paths.size());
            for (Future future : infoFutures) {
                infos.add(GoogleCloudStorageFileSystem.getFromFuture(future));
            }
            ArrayList arrayList = infos;
            return arrayList;
        }
        finally {
            fileInfoExecutor.shutdownNow();
        }
    }

    public void close() {
        if (this.gcs == null) {
            return;
        }
        ((GoogleLogger.Api)logger.atFiner()).log("close()");
        try {
            this.cachedExecutor.shutdown();
            this.lazyExecutor.shutdown();
            this.gcs.close();
        }
        finally {
            this.cachedExecutor = null;
            this.lazyExecutor = null;
            this.gcs = null;
        }
    }

    @VisibleForTesting
    public void mkdir(URI path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        ((GoogleLogger.Api)logger.atFiner()).log("mkdir(path: %s)", (Object)path);
        Preconditions.checkArgument((!path.equals(GCS_ROOT) ? 1 : 0) != 0, (Object)"Cannot create root directory.");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            this.gcs.createBucket(resourceId.getBucketName());
            return;
        }
        resourceId = resourceId.toDirectoryId();
        this.gcs.createEmptyObject(resourceId);
    }

    private void checkNoFilesConflictingWithDirs(StorageResourceId resourceId) throws IOException {
        List fileIds = (List)GoogleCloudStorageFileSystem.getDirs(resourceId.getObjectName()).stream().filter(subdir -> !Strings.isNullOrEmpty((String)subdir)).map(subdir -> new StorageResourceId(resourceId.getBucketName(), StringPaths.toFilePath(subdir))).collect(ImmutableList.toImmutableList());
        for (GoogleCloudStorageItemInfo fileInfo : this.gcs.getItemInfos(fileIds)) {
            if (!fileInfo.exists()) continue;
            GoogleCloudStorageEventBus.postOnException();
            throw new FileAlreadyExistsException("Cannot create directories because of existing file: " + fileInfo.getResourceId());
        }
    }

    static List<String> getDirs(String objectName) {
        if (Strings.isNullOrEmpty((String)objectName)) {
            return ImmutableList.of();
        }
        ArrayList<String> dirs = new ArrayList<String>();
        int index = 0;
        while ((index = objectName.indexOf("/", index)) >= 0) {
            dirs.add(objectName.substring(0, index += "/".length()));
        }
        return dirs;
    }

    String getItemName(URI path) {
        Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        if (path.equals(GCS_ROOT)) {
            return null;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            return resourceId.getBucketName();
        }
        String objectName = resourceId.getObjectName();
        int index = StringPaths.isDirectoryPath(objectName) ? objectName.lastIndexOf("/", objectName.length() - 2) : objectName.lastIndexOf("/");
        return index < 0 ? objectName : objectName.substring(index + 1);
    }

    private static ListObjectOptions updateListObjectOptions(ListObjectOptions listObjectOptions, ListFileOptions listFileOptions) {
        return listObjectOptions.toBuilder().setFields(listFileOptions.getFields()).build();
    }

    public GoogleCloudStorage getGcs() {
        return this.gcs;
    }
}

