package com.google.cloud.hadoop.gcsio;

import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageFileSystemOptions extends GoogleCloudStorageFileSystemOptions {

  private final boolean performanceCacheEnabled;

  private final GoogleCloudStorageFileSystemOptions.ClientType clientType;

  private final PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;

  private final GoogleCloudStorageOptions cloudStorageOptions;

  private final boolean bucketDeleteEnabled;

  @Nullable
  private final Pattern markerFilePattern;

  private final boolean statusParallelEnabled;

  private final boolean cooperativeLockingEnabled;

  private final boolean ensureNoConflictingItems;

  private AutoValue_GoogleCloudStorageFileSystemOptions(
      boolean performanceCacheEnabled,
      GoogleCloudStorageFileSystemOptions.ClientType clientType,
      PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions,
      GoogleCloudStorageOptions cloudStorageOptions,
      boolean bucketDeleteEnabled,
      @Nullable Pattern markerFilePattern,
      boolean statusParallelEnabled,
      boolean cooperativeLockingEnabled,
      boolean ensureNoConflictingItems) {
    this.performanceCacheEnabled = performanceCacheEnabled;
    this.clientType = clientType;
    this.performanceCacheOptions = performanceCacheOptions;
    this.cloudStorageOptions = cloudStorageOptions;
    this.bucketDeleteEnabled = bucketDeleteEnabled;
    this.markerFilePattern = markerFilePattern;
    this.statusParallelEnabled = statusParallelEnabled;
    this.cooperativeLockingEnabled = cooperativeLockingEnabled;
    this.ensureNoConflictingItems = ensureNoConflictingItems;
  }

  @Override
  public boolean isPerformanceCacheEnabled() {
    return performanceCacheEnabled;
  }

  @Override
  public GoogleCloudStorageFileSystemOptions.ClientType getClientType() {
    return clientType;
  }

  @Override
  public PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions() {
    return performanceCacheOptions;
  }

  @Override
  public GoogleCloudStorageOptions getCloudStorageOptions() {
    return cloudStorageOptions;
  }

  @Override
  public boolean isBucketDeleteEnabled() {
    return bucketDeleteEnabled;
  }

  @Nullable
  @Override
  public Pattern getMarkerFilePattern() {
    return markerFilePattern;
  }

  @Override
  public boolean isStatusParallelEnabled() {
    return statusParallelEnabled;
  }

  @Override
  public boolean isCooperativeLockingEnabled() {
    return cooperativeLockingEnabled;
  }

  @Override
  public boolean isEnsureNoConflictingItems() {
    return ensureNoConflictingItems;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageFileSystemOptions{"
        + "performanceCacheEnabled=" + performanceCacheEnabled + ", "
        + "clientType=" + clientType + ", "
        + "performanceCacheOptions=" + performanceCacheOptions + ", "
        + "cloudStorageOptions=" + cloudStorageOptions + ", "
        + "bucketDeleteEnabled=" + bucketDeleteEnabled + ", "
        + "markerFilePattern=" + markerFilePattern + ", "
        + "statusParallelEnabled=" + statusParallelEnabled + ", "
        + "cooperativeLockingEnabled=" + cooperativeLockingEnabled + ", "
        + "ensureNoConflictingItems=" + ensureNoConflictingItems
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageFileSystemOptions) {
      GoogleCloudStorageFileSystemOptions that = (GoogleCloudStorageFileSystemOptions) o;
      return this.performanceCacheEnabled == that.isPerformanceCacheEnabled()
          && this.clientType.equals(that.getClientType())
          && this.performanceCacheOptions.equals(that.getPerformanceCacheOptions())
          && this.cloudStorageOptions.equals(that.getCloudStorageOptions())
          && this.bucketDeleteEnabled == that.isBucketDeleteEnabled()
          && (this.markerFilePattern == null ? that.getMarkerFilePattern() == null : this.markerFilePattern.equals(that.getMarkerFilePattern()))
          && this.statusParallelEnabled == that.isStatusParallelEnabled()
          && this.cooperativeLockingEnabled == that.isCooperativeLockingEnabled()
          && this.ensureNoConflictingItems == that.isEnsureNoConflictingItems();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= performanceCacheEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= clientType.hashCode();
    h$ *= 1000003;
    h$ ^= performanceCacheOptions.hashCode();
    h$ *= 1000003;
    h$ ^= cloudStorageOptions.hashCode();
    h$ *= 1000003;
    h$ ^= bucketDeleteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (markerFilePattern == null) ? 0 : markerFilePattern.hashCode();
    h$ *= 1000003;
    h$ ^= statusParallelEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= cooperativeLockingEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= ensureNoConflictingItems ? 1231 : 1237;
    return h$;
  }

  @Override
  public GoogleCloudStorageFileSystemOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageFileSystemOptions.Builder {
    private boolean performanceCacheEnabled;
    private GoogleCloudStorageFileSystemOptions.ClientType clientType;
    private PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;
    private GoogleCloudStorageOptions cloudStorageOptions;
    private boolean bucketDeleteEnabled;
    private Pattern markerFilePattern;
    private boolean statusParallelEnabled;
    private boolean cooperativeLockingEnabled;
    private boolean ensureNoConflictingItems;
    private byte set$0;
    Builder() {
    }
    private Builder(GoogleCloudStorageFileSystemOptions source) {
      this.performanceCacheEnabled = source.isPerformanceCacheEnabled();
      this.clientType = source.getClientType();
      this.performanceCacheOptions = source.getPerformanceCacheOptions();
      this.cloudStorageOptions = source.getCloudStorageOptions();
      this.bucketDeleteEnabled = source.isBucketDeleteEnabled();
      this.markerFilePattern = source.getMarkerFilePattern();
      this.statusParallelEnabled = source.isStatusParallelEnabled();
      this.cooperativeLockingEnabled = source.isCooperativeLockingEnabled();
      this.ensureNoConflictingItems = source.isEnsureNoConflictingItems();
      set$0 = (byte) 0x1f;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheEnabled(boolean performanceCacheEnabled) {
      this.performanceCacheEnabled = performanceCacheEnabled;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setClientType(GoogleCloudStorageFileSystemOptions.ClientType clientType) {
      if (clientType == null) {
        throw new NullPointerException("Null clientType");
      }
      this.clientType = clientType;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheOptions(PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions) {
      if (performanceCacheOptions == null) {
        throw new NullPointerException("Null performanceCacheOptions");
      }
      this.performanceCacheOptions = performanceCacheOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCloudStorageOptions(GoogleCloudStorageOptions cloudStorageOptions) {
      if (cloudStorageOptions == null) {
        throw new NullPointerException("Null cloudStorageOptions");
      }
      this.cloudStorageOptions = cloudStorageOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setBucketDeleteEnabled(boolean bucketDeleteEnabled) {
      this.bucketDeleteEnabled = bucketDeleteEnabled;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    GoogleCloudStorageFileSystemOptions.Builder setMarkerFilePattern(Pattern markerFilePattern) {
      this.markerFilePattern = markerFilePattern;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setStatusParallelEnabled(boolean statusParallelEnabled) {
      this.statusParallelEnabled = statusParallelEnabled;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCooperativeLockingEnabled(boolean cooperativeLockingEnabled) {
      this.cooperativeLockingEnabled = cooperativeLockingEnabled;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setEnsureNoConflictingItems(boolean ensureNoConflictingItems) {
      this.ensureNoConflictingItems = ensureNoConflictingItems;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions build() {
      if (set$0 != 0x1f
          || this.clientType == null
          || this.performanceCacheOptions == null
          || this.cloudStorageOptions == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" performanceCacheEnabled");
        }
        if (this.clientType == null) {
          missing.append(" clientType");
        }
        if (this.performanceCacheOptions == null) {
          missing.append(" performanceCacheOptions");
        }
        if (this.cloudStorageOptions == null) {
          missing.append(" cloudStorageOptions");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" bucketDeleteEnabled");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" statusParallelEnabled");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" cooperativeLockingEnabled");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" ensureNoConflictingItems");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageFileSystemOptions(
          this.performanceCacheEnabled,
          this.clientType,
          this.performanceCacheOptions,
          this.cloudStorageOptions,
          this.bucketDeleteEnabled,
          this.markerFilePattern,
          this.statusParallelEnabled,
          this.cooperativeLockingEnabled,
          this.ensureNoConflictingItems);
    }
  }

}
