/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StatisticTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;

public enum GoogleCloudStorageStatistics {
    GCS_REQUEST_COUNT("gcs_total_request_count", "Counts the total number of gcs requests made", StatisticTypeEnum.TYPE_COUNTER),
    EXCEPTION_COUNT("exception_count", "Counts the number of exceptions encountered", StatisticTypeEnum.TYPE_COUNTER),
    GCS_CLIENT_SIDE_ERROR_COUNT("gcs_client_side_error_count", "Counts the occurrence of client side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_SERVER_SIDE_ERROR_COUNT("gcs_server_side_error_count", "Counts the occurrence of server side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_CLIENT_RATE_LIMIT_COUNT("gcs_client_rate_limit_error_count", "Counts the occurence of 429 status code", StatisticTypeEnum.TYPE_COUNTER);

    public static final ImmutableSet<GoogleCloudStorageStatistics> VALUES;
    private static final ImmutableMap<String, GoogleCloudStorageStatistics> SYMBOL_MAP;
    private final String symbol;
    private final String description;
    private final StatisticTypeEnum type;

    private GoogleCloudStorageStatistics(String symbol, String description, StatisticTypeEnum type) {
        this.symbol = symbol;
        this.description = description;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static GoogleCloudStorageStatistics fromSymbol(String symbol) {
        return (GoogleCloudStorageStatistics)((Object)SYMBOL_MAP.get((Object)symbol));
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    public StatisticTypeEnum getType() {
        return this.type;
    }

    static {
        VALUES = ImmutableSet.copyOf(EnumSet.allOf(GoogleCloudStorageStatistics.class));
        SYMBOL_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])GoogleCloudStorageStatistics.values()), GoogleCloudStorageStatistics::getSymbol);
    }
}

