/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.storage.v2.StorageGrpc;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelCredentials;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class StorageStubProvider {
    static final Metadata.Key<String> GOOG_REQUEST_PARAMS = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final ImmutableSet<Status.Code> STUB_BROKEN_ERROR_CODES = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.UNAVAILABLE);
    private final GoogleCloudStorageOptions options;
    private final String userAgent;
    private final ExecutorService backgroundTasksThreadPool;
    private final GrpcDecorator grpcDecorator;
    private ManagedChannel channel;

    @VisibleForTesting
    GrpcDecorator getGrpcDecorator() {
        return this.grpcDecorator;
    }

    StorageStubProvider(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, GrpcDecorator grpcDecorator) {
        this.options = options;
        this.userAgent = options.getAppName();
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.grpcDecorator = (GrpcDecorator)Preconditions.checkNotNull((Object)grpcDecorator, (Object)"grpcDecorator cannot be null");
    }

    private ManagedChannel buildManagedChannel() {
        String target = this.options.getGrpcServerAddress();
        ManagedChannel channel = this.grpcDecorator.createChannelBuilder(target).enableRetry().userAgent(this.userAgent).build();
        return channel;
    }

    public static boolean isStubBroken(Status.Code statusCode) {
        return STUB_BROKEN_ERROR_CODES.contains((Object)statusCode);
    }

    public final StorageGrpc.StorageBlockingStub newBlockingStub(String bucketName) {
        return (StorageGrpc.StorageBlockingStub)this.newBlockingStubInternal().withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)StorageStubProvider.getRequestHeaderMetadata(bucketName))});
    }

    public final StorageGrpc.StorageStub newAsyncStub(String bucketName) {
        return (StorageGrpc.StorageStub)this.newAsyncStubInternal().withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)StorageStubProvider.getRequestHeaderMetadata(bucketName))});
    }

    protected StorageGrpc.StorageBlockingStub newBlockingStubInternal() {
        StorageGrpc.StorageBlockingStub stub = StorageGrpc.newBlockingStub((Channel)this.getManagedChannel());
        return (StorageGrpc.StorageBlockingStub)this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
    }

    protected StorageGrpc.StorageStub newAsyncStubInternal() {
        StorageGrpc.StorageStub stub = (StorageGrpc.StorageStub)StorageGrpc.newStub((Channel)this.getManagedChannel()).withExecutor((Executor)this.backgroundTasksThreadPool);
        return (StorageGrpc.StorageStub)this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
    }

    private static Metadata getRequestHeaderMetadata(String bucketName) {
        Metadata metadata = new Metadata();
        metadata.put(GOOG_REQUEST_PARAMS, (Object)String.format("bucket=%s", bucketName));
        return metadata;
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.channel == null) {
            this.channel = this.buildManagedChannel();
        }
        return this.channel;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credential credential) {
        CredentialAdapter credentials = new CredentialAdapter(credential);
        GrpcDecorator decorator = options.isTrafficDirectorEnabled() ? new TrafficDirectorGrpcDecorator((Credentials)credentials) : (options.isDirectPathPreferred() ? new DirectPathGrpcDecorator((Credentials)credentials) : new CloudPathGrpcDecorator((Credentials)credentials));
        return new StorageStubProvider(options, backgroundTasksThreadPool, decorator);
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credentials credentials) {
        GrpcDecorator decorator = options.isTrafficDirectorEnabled() ? new TrafficDirectorGrpcDecorator(credentials) : (options.isDirectPathPreferred() ? new DirectPathGrpcDecorator(credentials) : new CloudPathGrpcDecorator(credentials));
        return new StorageStubProvider(options, backgroundTasksThreadPool, decorator);
    }

    static class TrafficDirectorGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        TrafficDirectorGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            GoogleDefaultChannelCredentials.Builder credentialsBuilder = GoogleDefaultChannelCredentials.newBuilder();
            if (credentialsBuilder != null) {
                credentialsBuilder.callCredentials(MoreCallCredentials.from((Credentials)this.credentials));
            }
            return Grpc.newChannelBuilder((String)("google-c2p-experimental:///" + target), (ChannelCredentials)credentialsBuilder.build());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }
    }

    static class DirectPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        DirectPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            GoogleDefaultChannelCredentials.Builder credentialsBuilder = GoogleDefaultChannelCredentials.newBuilder();
            if (this.credentials != null) {
                credentialsBuilder.callCredentials(MoreCallCredentials.from((Credentials)this.credentials));
            }
            return Grpc.newChannelBuilder((String)target, (ChannelCredentials)credentialsBuilder.build()).defaultServiceConfig(this.getGrpcServiceConfig());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }

        private Map<String, Object> getGrpcServiceConfig() {
            ImmutableMap childLbStrategy = ImmutableMap.of((Object)"round_robin", (Object)ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)childLbStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
            return ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
        }
    }

    static class CloudPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        CloudPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return ManagedChannelBuilder.forTarget((String)target);
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub.withCallCredentials(MoreCallCredentials.from((Credentials)this.credentials));
        }
    }

    static interface GrpcDecorator {
        public ManagedChannelBuilder<?> createChannelBuilder(String var1);

        public AbstractStub<?> applyCallOption(AbstractStub<?> var1);
    }
}

