/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.testing.AutoValue_GcsItemInfoTestBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class GcsItemInfoTestBuilder {
    public static Builder create() {
        return new AutoValue_GcsItemInfoTestBuilder.Builder().setStorageResourceId(new StorageResourceId("foo-test-bucket", "bar/test/object")).setCreationTime(System.currentTimeMillis()).setModificationTime(System.currentTimeMillis()).setSize(12456L).setLocation("us-central-1").setStorageClass("standard").setContentType("application/octet-stream").setContentEncoding(null).setMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo-test-meta", (Object)new byte[]{8, 33})).setContentGeneration(821741945L).setMetaGeneration(3L).setVerificationAttributes(new VerificationAttributes(null, null));
    }

    public abstract StorageResourceId getStorageResourceId();

    public abstract long getCreationTime();

    public abstract long getModificationTime();

    public abstract long getSize();

    @Nullable
    public abstract String getLocation();

    @Nullable
    public abstract String getStorageClass();

    @Nullable
    public abstract String getContentType();

    @Nullable
    public abstract String getContentEncoding();

    public abstract ImmutableMap<String, byte[]> getMetadata();

    public abstract long getContentGeneration();

    public abstract long getMetaGeneration();

    public abstract VerificationAttributes getVerificationAttributes();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setStorageResourceId(StorageResourceId var1);

        public abstract Builder setCreationTime(long var1);

        public abstract Builder setModificationTime(long var1);

        public abstract Builder setSize(long var1);

        public abstract Builder setLocation(String var1);

        public abstract Builder setStorageClass(String var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setContentEncoding(String var1);

        public abstract Builder setMetadata(Map<String, byte[]> var1);

        public abstract Builder setContentGeneration(long var1);

        public abstract Builder setMetaGeneration(long var1);

        public abstract Builder setVerificationAttributes(VerificationAttributes var1);

        abstract GcsItemInfoTestBuilder autoBuild();

        public GoogleCloudStorageItemInfo build() {
            GcsItemInfoTestBuilder instance = this.autoBuild();
            return new GoogleCloudStorageItemInfo(instance.getStorageResourceId(), instance.getCreationTime(), instance.getModificationTime(), instance.getSize(), instance.getLocation(), instance.getStorageClass(), instance.getContentType(), instance.getContentEncoding(), (Map<String, byte[]>)instance.getMetadata(), instance.getContentGeneration(), instance.getMetaGeneration(), instance.getVerificationAttributes());
        }
    }
}

