/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PrefixMappedItemCache;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PerformanceCachingGoogleCloudStorage
extends ForwardingGoogleCloudStorage {
    private final PrefixMappedItemCache cache;

    public PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PerformanceCachingGoogleCloudStorageOptions options) {
        this(delegate, PerformanceCachingGoogleCloudStorage.createCache(options));
    }

    @VisibleForTesting
    PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PrefixMappedItemCache cache) {
        super(delegate);
        this.cache = cache;
    }

    private static PrefixMappedItemCache createCache(PerformanceCachingGoogleCloudStorageOptions options) {
        return new PrefixMappedItemCache(Duration.ofMillis(options.getMaxEntryAgeMillis()));
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        if (this.cache.getItem(resourceId) != null) {
            this.cache.removeItem(resourceId);
        }
        return super.create(resourceId);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        super.deleteBuckets(bucketNames);
        for (String bucket : bucketNames) {
            this.cache.invalidateBucket(bucket);
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> resourceIds) throws IOException {
        super.deleteObjects(resourceIds);
        for (StorageResourceId resourceId : resourceIds) {
            this.cache.removeItem(resourceId);
        }
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.listBucketInfo();
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, String delimiter, String pageToken) throws IOException {
        GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> result = super.listObjectInfoPage(bucketName, objectNamePrefix, delimiter, pageToken);
        for (GoogleCloudStorageItemInfo item : result.getItems()) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
        if (item == null && resourceId.isStorageObject()) {
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            int lastSlashIndex = objectName.lastIndexOf("/");
            String directoryName = lastSlashIndex >= 0 ? objectName.substring(0, lastSlashIndex + 1) : null;
            this.listObjectInfoPage(bucketName, directoryName, "/", null);
            item = this.cache.getItem(resourceId);
        }
        if (item == null) {
            item = super.getItemInfo(resourceId);
            this.cache.putItem(item);
        }
        return item;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> result = new ArrayList<GoogleCloudStorageItemInfo>(resourceIds.size());
        ArrayList<StorageResourceId> request = new ArrayList<StorageResourceId>(resourceIds.size());
        for (StorageResourceId resourceId : resourceIds) {
            GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
            if (item == null) {
                request.add(resourceId);
            }
            result.add(item);
        }
        if (!request.isEmpty()) {
            List<GoogleCloudStorageItemInfo> response = super.getItemInfos(request);
            Iterator<GoogleCloudStorageItemInfo> responseIterator = response.iterator();
            for (int i = 0; i < result.size() && responseIterator.hasNext(); ++i) {
                if (result.get(i) != null) continue;
                GoogleCloudStorageItemInfo item = responseIterator.next();
                this.cache.putItem(item);
                result.set(i, item);
            }
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.updateItems(itemInfoList);
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.cache.invalidateAll();
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        GoogleCloudStorageItemInfo item = super.composeObjects(sources, destination, options);
        this.cache.putItem(item);
        return item;
    }

    @VisibleForTesting
    public void invalidateCache() {
        this.cache.invalidateAll();
    }
}

