/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableCollection;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$Maps;
import autovalue.shaded.com.google$.common.collect.$Sets;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.processor.AutoValueOrOneOfProcessor;
import com.google.auto.value.processor.AutoValueTemplateVars;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeMirrorSet;
import com.google.auto.value.processor.TypeSimplifier;
import com.google.auto.value.processor.TypeVariables;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

class BuilderSpec {
    private final TypeElement autoValueClass;
    private final ProcessingEnvironment processingEnv;
    private final ErrorReporter errorReporter;
    private static final $ImmutableSet<ElementKind> CLASS_OR_INTERFACE = $Sets.immutableEnumSet((Enum)ElementKind.CLASS, (Enum[])new ElementKind[]{ElementKind.INTERFACE});

    BuilderSpec(TypeElement autoValueClass, ProcessingEnvironment processingEnv, ErrorReporter errorReporter) {
        this.autoValueClass = autoValueClass;
        this.processingEnv = processingEnv;
        this.errorReporter = errorReporter;
    }

    Optional<Builder> getBuilder() {
        Optional<Object> builderTypeElement = Optional.empty();
        for (TypeElement containedClass : ElementFilter.typesIn(this.autoValueClass.getEnclosedElements())) {
            if (!AutoValueOrOneOfProcessor.hasAnnotationMirror(containedClass, "com.google.auto.value.AutoValue.Builder")) continue;
            if (!CLASS_OR_INTERFACE.contains((Object)containedClass.getKind())) {
                this.errorReporter.reportError("@AutoValue.Builder can only apply to a class or an interface", containedClass);
                continue;
            }
            if (!containedClass.getModifiers().contains((Object)Modifier.STATIC)) {
                this.errorReporter.reportError("@AutoValue.Builder cannot be applied to a non-static class", containedClass);
                continue;
            }
            if (builderTypeElement.isPresent()) {
                this.errorReporter.reportError(this.autoValueClass + " already has a Builder: " + builderTypeElement.get(), containedClass);
                continue;
            }
            builderTypeElement = Optional.of(containedClass);
        }
        if (builderTypeElement.isPresent()) {
            return this.builderFrom((TypeElement)builderTypeElement.get());
        }
        return Optional.empty();
    }

    private Optional<Builder> builderFrom(TypeElement builderTypeElement) {
        if (!BuilderSpec.sameTypeParameters(this.autoValueClass, builderTypeElement)) {
            this.errorReporter.reportError("Type parameters of " + builderTypeElement + " must have same names and bounds as type parameters of " + this.autoValueClass, builderTypeElement);
            return Optional.empty();
        }
        return Optional.of(new Builder(builderTypeElement));
    }

    private static boolean sameTypeParameters(TypeElement a, TypeElement b) {
        int nTypeParameters = a.getTypeParameters().size();
        if (nTypeParameters != b.getTypeParameters().size()) {
            return false;
        }
        for (int i = 0; i < nTypeParameters; ++i) {
            TypeMirrorSet builderBounds;
            TypeParameterElement aParam = a.getTypeParameters().get(i);
            TypeParameterElement bParam = b.getTypeParameters().get(i);
            if (!aParam.getSimpleName().equals(bParam.getSimpleName())) {
                return false;
            }
            TypeMirrorSet autoValueBounds = new TypeMirrorSet(aParam.getBounds());
            if (autoValueBounds.equals(builderBounds = new TypeMirrorSet(bParam.getBounds()))) continue;
            return false;
        }
        return true;
    }

    private Set<ExecutableElement> abstractMethods(TypeElement typeElement) {
        $ImmutableSet<ExecutableElement> methods = $MoreElements.getLocalAndInheritedMethods(typeElement, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        $ImmutableSet.Builder abstractMethods = $ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            abstractMethods.add(method);
        }
        return abstractMethods.build();
    }

    private String typeParamsString() {
        return TypeSimplifier.actualTypeParametersString(this.autoValueClass);
    }

    public static class PropertySetter {
        private final ExecutableElement setter;
        private final String access;
        private final String name;
        private final String parameterTypeString;
        private final boolean primitiveParameter;
        private final String nullableAnnotation;
        private final Function<String, String> copyFunction;

        PropertySetter(ExecutableElement setter, TypeMirror parameterType, Function<String, String> copyFunction) {
            this.setter = setter;
            this.copyFunction = copyFunction;
            this.access = SimpleMethod.access(setter);
            this.name = setter.getSimpleName().toString();
            this.primitiveParameter = parameterType.getKind().isPrimitive();
            this.parameterTypeString = PropertySetter.parameterTypeString(setter, parameterType);
            VariableElement parameterElement = $Iterables.getOnlyElement(setter.getParameters());
            Optional<String> maybeNullable = AutoValueOrOneOfProcessor.nullableAnnotationFor(parameterElement, parameterType);
            this.nullableAnnotation = maybeNullable.orElse("");
        }

        ExecutableElement getSetter() {
            return this.setter;
        }

        private static String parameterTypeString(ExecutableElement setter, TypeMirror parameterType) {
            if (setter.isVarArgs()) {
                TypeMirror componentType = $MoreTypes.asArray(parameterType).getComponentType();
                return TypeEncoder.encodeWithAnnotations(componentType) + "...";
            }
            return TypeEncoder.encodeWithAnnotations(parameterType);
        }

        public String getAccess() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public String getParameterType() {
            return this.parameterTypeString;
        }

        public boolean getPrimitiveParameter() {
            return this.primitiveParameter;
        }

        public String getNullableAnnotation() {
            return this.nullableAnnotation;
        }

        public String copy(AutoValueOrOneOfProcessor.Property property) {
            String copy = this.copyFunction.apply(property.toString());
            if (property.isNullable() && !copy.equals(property.toString())) {
                copy = String.format("(%s == null ? null : %s)", property, copy);
            }
            return copy;
        }
    }

    public static class PropertyGetter {
        private final String access;
        private final String type;
        private final Optionalish optional;

        PropertyGetter(ExecutableElement method, String type, Optionalish optional) {
            this.access = SimpleMethod.access(method);
            this.type = type;
            this.optional = optional;
        }

        public String getAccess() {
            return this.access;
        }

        public String getType() {
            return this.type;
        }

        public Optionalish getOptional() {
            return this.optional;
        }
    }

    class Builder
    implements AutoValueExtension.BuilderContext {
        private final TypeElement builderTypeElement;
        private $ImmutableSet<ExecutableElement> toBuilderMethods;
        private ExecutableElement buildMethod;
        private BuilderMethodClassifier classifier;

        Builder(TypeElement builderTypeElement) {
            this.builderTypeElement = builderTypeElement;
        }

        @Override
        public TypeElement builderType() {
            return this.builderTypeElement;
        }

        @Override
        public Set<ExecutableElement> builderMethods() {
            return ElementFilter.methodsIn(BuilderSpec.this.autoValueClass.getEnclosedElements()).stream().filter(m -> m.getParameters().isEmpty() && m.getModifiers().contains((Object)Modifier.STATIC) && !m.getModifiers().contains((Object)Modifier.PRIVATE) && this.erasedTypeIs(m.getReturnType(), this.builderTypeElement)).collect(Collectors.toSet());
        }

        @Override
        public Optional<ExecutableElement> buildMethod() {
            return ElementFilter.methodsIn(this.builderTypeElement.getEnclosedElements()).stream().filter(m -> m.getSimpleName().contentEquals("build") && !m.getModifiers().contains((Object)Modifier.PRIVATE) && !m.getModifiers().contains((Object)Modifier.STATIC) && m.getParameters().isEmpty() && this.erasedTypeIs(m.getReturnType(), BuilderSpec.this.autoValueClass)).findFirst();
        }

        @Override
        public ExecutableElement autoBuildMethod() {
            return this.buildMethod;
        }

        @Override
        public Map<String, Set<ExecutableElement>> setters() {
            return $Maps.transformValues(this.classifier.propertyNameToSetters().asMap(), propertySetters -> propertySetters.stream().map(PropertySetter::getSetter).collect(Collectors.toSet()));
        }

        @Override
        public Map<String, ExecutableElement> propertyBuilders() {
            return $Maps.transformValues(this.classifier.propertyNameToPropertyBuilder(), PropertyBuilderClassifier.PropertyBuilder::getPropertyBuilderMethod);
        }

        private boolean erasedTypeIs(TypeMirror type, TypeElement baseType) {
            return type.getKind().equals((Object)TypeKind.DECLARED) && $MoreTypes.asDeclared(type).asElement().equals(baseType);
        }

        @Override
        public Set<ExecutableElement> toBuilderMethods() {
            return this.toBuilderMethods;
        }

        $ImmutableSet<ExecutableElement> toBuilderMethods(Types typeUtils, Set<ExecutableElement> abstractMethods) {
            List builderTypeParamNames = this.builderTypeElement.getTypeParameters().stream().map(e -> e.getSimpleName().toString()).collect(Collectors.toList());
            $ImmutableSet.Builder methods = $ImmutableSet.builder();
            for (ExecutableElement method : abstractMethods) {
                if (!this.builderTypeElement.equals(typeUtils.asElement(method.getReturnType()))) continue;
                methods.add(method);
                DeclaredType returnType = $MoreTypes.asDeclared(method.getReturnType());
                List typeArguments = returnType.getTypeArguments().stream().filter(t -> t.getKind().equals((Object)TypeKind.TYPEVAR)).map(t -> typeUtils.asElement((TypeMirror)t).getSimpleName().toString()).collect(Collectors.toList());
                if (builderTypeParamNames.equals(typeArguments)) continue;
                BuilderSpec.this.errorReporter.reportError("Builder converter method should return " + this.builderTypeElement + TypeSimplifier.actualTypeParametersString(this.builderTypeElement), method);
            }
            $ImmutableCollection builderMethods = methods.build();
            if (builderMethods.size() > 1) {
                BuilderSpec.this.errorReporter.reportError("There can be at most one builder converter method", (Element)(($ImmutableSet)builderMethods).iterator().next());
            }
            this.toBuilderMethods = builderMethods;
            return builderMethods;
        }

        void defineVars(AutoValueTemplateVars vars, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName) {
            Set builderMethods = BuilderSpec.this.abstractMethods(this.builderTypeElement);
            boolean autoValueHasToBuilder = !this.toBuilderMethods.isEmpty();
            $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType = TypeVariables.rewriteReturnTypes(BuilderSpec.this.processingEnv.getElementUtils(), BuilderSpec.this.processingEnv.getTypeUtils(), getterToPropertyName.keySet(), BuilderSpec.this.autoValueClass, this.builderTypeElement);
            Optional<BuilderMethodClassifier> optionalClassifier = BuilderMethodClassifier.classify(builderMethods, BuilderSpec.this.errorReporter, BuilderSpec.this.processingEnv, BuilderSpec.this.autoValueClass, this.builderTypeElement, getterToPropertyName, getterToPropertyType, autoValueHasToBuilder);
            if (!optionalClassifier.isPresent()) {
                return;
            }
            for (ExecutableElement method : ElementFilter.methodsIn(this.builderTypeElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals("builder") || !method.getModifiers().contains((Object)Modifier.STATIC) || !method.getAnnotationMirrors().isEmpty()) continue;
                BuilderSpec.this.errorReporter.reportWarning("Static builder() method should be in the containing class", method);
            }
            this.classifier = optionalClassifier.get();
            Set<ExecutableElement> buildMethods = this.classifier.buildMethods();
            if (buildMethods.size() != 1) {
                Set<ExecutableElement> errorElements = buildMethods.isEmpty() ? $ImmutableSet.of(this.builderTypeElement) : buildMethods;
                for (Element element : errorElements) {
                    BuilderSpec.this.errorReporter.reportError("Builder must have a single no-argument method returning " + BuilderSpec.this.autoValueClass + BuilderSpec.this.typeParamsString(), element);
                }
                return;
            }
            this.buildMethod = $Iterables.getOnlyElement(buildMethods);
            vars.builderIsInterface = this.builderTypeElement.getKind() == ElementKind.INTERFACE;
            vars.builderTypeName = TypeSimplifier.classNameOf(this.builderTypeElement);
            vars.builderFormalTypes = TypeEncoder.formalTypeParametersString(this.builderTypeElement);
            vars.builderActualTypes = TypeSimplifier.actualTypeParametersString(this.builderTypeElement);
            vars.buildMethod = Optional.of(new SimpleMethod(this.buildMethod));
            vars.builderGetters = this.classifier.builderGetters();
            vars.builderSetters = this.classifier.propertyNameToSetters();
            vars.builderPropertyBuilders = $ImmutableMap.copyOf(this.classifier.propertyNameToPropertyBuilder());
            LinkedHashSet<AutoValueOrOneOfProcessor.Property> required = new LinkedHashSet<AutoValueOrOneOfProcessor.Property>(vars.props);
            for (AutoValueOrOneOfProcessor.Property property : vars.props) {
                if (!property.isNullable() && property.getOptional() == null && !vars.builderPropertyBuilders.containsKey(property.getName())) continue;
                required.remove(property);
            }
            vars.builderRequiredProperties = $ImmutableSet.copyOf(required);
        }
    }
}

