/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;

class ViewAttachmentManager {
    private final View ownerView;
    private final WindowManager windowManager;
    private final WindowManager.LayoutParams windowLayoutParams;
    private final FrameLayout frameLayout;
    private final ViewGroup.LayoutParams viewLayoutParams;
    private static final String VIEW_RENDERABLE_WINDOW = "ViewRenderableWindow";

    ViewAttachmentManager(Context context, View ownerView) {
        this.ownerView = ownerView;
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.windowLayoutParams = ViewAttachmentManager.createWindowLayoutParams();
        this.frameLayout = new FrameLayout(context);
        this.viewLayoutParams = ViewAttachmentManager.createViewLayoutParams();
    }

    FrameLayout getFrameLayout() {
        return this.frameLayout;
    }

    void onResume() {
        this.ownerView.post(() -> {
            if (this.frameLayout.getParent() == null && this.ownerView.isAttachedToWindow()) {
                this.windowManager.addView((View)this.frameLayout, (ViewGroup.LayoutParams)this.windowLayoutParams);
            }
        });
    }

    void onPause() {
        if (this.frameLayout.getParent() != null) {
            this.windowManager.removeView((View)this.frameLayout);
        }
    }

    void addView(View view) {
        if (view.getParent() == this.frameLayout) {
            return;
        }
        this.frameLayout.addView(view, this.viewLayoutParams);
    }

    void removeView(View view) {
        if (view.getParent() != this.frameLayout) {
            return;
        }
        this.frameLayout.removeView(view);
    }

    private static WindowManager.LayoutParams createWindowLayoutParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-2, -2, 1000, 16777752, -3);
        params.setTitle((CharSequence)VIEW_RENDERABLE_WINDOW);
        return params;
    }

    private static ViewGroup.LayoutParams createViewLayoutParams() {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        return params;
    }
}

