/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;

public class ThreadPools {
    private static Executor mainExecutor;
    private static Executor threadPoolExecutor;

    private ThreadPools() {
    }

    public static Executor getMainExecutor() {
        if (mainExecutor == null) {
            mainExecutor = new Executor(){
                private final Handler handler = new Handler(Looper.getMainLooper());

                @Override
                public void execute(Runnable runnable) {
                    this.handler.post(runnable);
                }
            };
        }
        return mainExecutor;
    }

    public static void setMainExecutor(Executor executor) {
        mainExecutor = executor;
    }

    public static Executor getThreadPoolExecutor() {
        if (threadPoolExecutor == null) {
            return AsyncTask.THREAD_POOL_EXECUTOR;
        }
        return threadPoolExecutor;
    }

    public static void setThreadPoolExecutor(Executor executor) {
        threadPoolExecutor = executor;
    }
}

