/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;
import com.google.android.filament.android.TextureHelper;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.FutureHelper;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.TextureInternalData;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.resources.ResourceRegistry;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.LoadHelper;
import com.google.ar.sceneform.utilities.Preconditions;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@RequiresApi(api=24)
@UsedByNative(value="material_java_wrappers.h")
public class Texture {
    private static final String TAG = Texture.class.getSimpleName();
    private static final int MIP_LEVELS_TO_GENERATE = 255;
    @Nullable
    private final TextureInternalData textureData;

    public static Builder builder() {
        AndroidPreconditions.checkMinAndroidApiLevel();
        return new Builder();
    }

    @UsedByNative(value="material_java_wrappers.h")
    private Texture(TextureInternalData textureData) {
        this.textureData = textureData;
        textureData.retain();
        ResourceManager.getInstance().getTextureCleanupRegistry().register(this, new CleanupCallback(textureData));
    }

    Sampler getSampler() {
        return ((TextureInternalData)((Object)Preconditions.checkNotNull((Object)((Object)this.textureData)))).getSampler();
    }

    com.google.android.filament.Texture getFilamentTexture() {
        return ((TextureInternalData)((Object)Preconditions.checkNotNull((Object)((Object)this.textureData)))).getFilamentTexture();
    }

    private static Texture.InternalFormat getInternalFormatForUsage(Usage usage) {
        Texture.InternalFormat format;
        switch (usage) {
            case COLOR: {
                format = Texture.InternalFormat.SRGB8_A8;
                break;
            }
            default: {
                format = Texture.InternalFormat.RGBA8;
            }
        }
        return format;
    }

    private static final class CleanupCallback
    implements Runnable {
        private final TextureInternalData textureData;

        CleanupCallback(TextureInternalData textureData) {
            this.textureData = textureData;
        }

        @Override
        public void run() {
            AndroidPreconditions.checkUiThread();
            if (this.textureData != null) {
                this.textureData.release();
            }
        }
    }

    @UsedByNative(value="material_java_wrappers.h")
    public static class Sampler {
        private final MinFilter minFilter;
        private final MagFilter magFilter;
        private final WrapMode wrapModeS;
        private final WrapMode wrapModeT;
        private final WrapMode wrapModeR;

        private Sampler(Builder builder) {
            this.minFilter = builder.minFilter;
            this.magFilter = builder.magFilter;
            this.wrapModeS = builder.wrapModeS;
            this.wrapModeT = builder.wrapModeT;
            this.wrapModeR = builder.wrapModeR;
        }

        public MinFilter getMinFilter() {
            return this.minFilter;
        }

        public MagFilter getMagFilter() {
            return this.magFilter;
        }

        public WrapMode getWrapModeS() {
            return this.wrapModeS;
        }

        public WrapMode getWrapModeT() {
            return this.wrapModeT;
        }

        public WrapMode getWrapModeR() {
            return this.wrapModeR;
        }

        public static Builder builder() {
            return new Builder().setMinFilter(MinFilter.LINEAR_MIPMAP_LINEAR).setMagFilter(MagFilter.LINEAR).setWrapMode(WrapMode.CLAMP_TO_EDGE);
        }

        public static class Builder {
            private MinFilter minFilter;
            private MagFilter magFilter;
            private WrapMode wrapModeS;
            private WrapMode wrapModeT;
            private WrapMode wrapModeR;

            Builder setMinMagFilter(MagFilter minMagFilter) {
                return this.setMinFilter(MinFilter.values()[minMagFilter.ordinal()]).setMagFilter(minMagFilter);
            }

            public Builder setMinFilter(MinFilter minFilter) {
                this.minFilter = minFilter;
                return this;
            }

            public Builder setMagFilter(MagFilter magFilter) {
                this.magFilter = magFilter;
                return this;
            }

            public Builder setWrapMode(WrapMode wrapMode) {
                return this.setWrapModeS(wrapMode).setWrapModeT(wrapMode).setWrapModeR(wrapMode);
            }

            public Builder setWrapModeS(WrapMode wrapMode) {
                this.wrapModeS = wrapMode;
                return this;
            }

            public Builder setWrapModeT(WrapMode wrapMode) {
                this.wrapModeT = wrapMode;
                return this;
            }

            public Builder setWrapModeR(WrapMode wrapMode) {
                this.wrapModeR = wrapMode;
                return this;
            }

            public Sampler build() {
                return new Sampler(this);
            }
        }

        @UsedByNative(value="material_java_wrappers.h")
        public static enum WrapMode {
            CLAMP_TO_EDGE,
            REPEAT,
            MIRRORED_REPEAT;

        }

        @UsedByNative(value="material_java_wrappers.h")
        public static enum MagFilter {
            NEAREST,
            LINEAR;

        }

        @UsedByNative(value="material_java_wrappers.h")
        public static enum MinFilter {
            NEAREST,
            LINEAR,
            NEAREST_MIPMAP_NEAREST,
            LINEAR_MIPMAP_NEAREST,
            NEAREST_MIPMAP_LINEAR,
            LINEAR_MIPMAP_LINEAR;

        }
    }

    public static final class Builder {
        @Nullable
        private Callable<InputStream> inputStreamCreator = null;
        @Nullable
        private Bitmap bitmap = null;
        @Nullable
        private TextureInternalData textureInternalData = null;
        private Usage usage = Usage.COLOR;
        @Nullable
        private Object registryId = null;
        private boolean inPremultiplied = true;
        private Sampler sampler = Sampler.builder().build();
        private static final int MAX_BITMAP_SIZE = 4096;

        private Builder() {
        }

        public Builder setSource(Context context, Uri sourceUri) {
            Preconditions.checkNotNull((Object)sourceUri, (Object)"Parameter \"sourceUri\" was null.");
            this.registryId = sourceUri;
            this.setSource(LoadHelper.fromUri((Context)context, (Uri)sourceUri));
            return this;
        }

        public Builder setSource(Callable<InputStream> inputStreamCreator) {
            Preconditions.checkNotNull(inputStreamCreator, (Object)"Parameter \"inputStreamCreator\" was null.");
            this.inputStreamCreator = inputStreamCreator;
            this.bitmap = null;
            return this;
        }

        public Builder setSource(Context context, int resource) {
            this.setSource(LoadHelper.fromResource((Context)context, (int)resource));
            this.registryId = context.getResources().getResourceName(resource);
            return this;
        }

        public Builder setSource(Bitmap bitmap) {
            Preconditions.checkNotNull((Object)bitmap, (Object)"Parameter \"bitmap\" was null.");
            if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                String string = String.valueOf(bitmap.getConfig());
                throw new IllegalArgumentException(new StringBuilder(69 + String.valueOf(string).length()).append("Invalid Bitmap: Bitmap's configuration must be ARGB_8888, but it was ").append(string).toString());
            }
            if (bitmap.hasAlpha() && !bitmap.isPremultiplied()) {
                throw new IllegalArgumentException("Invalid Bitmap: Bitmap must be premultiplied.");
            }
            if (bitmap.getWidth() > 4096 || bitmap.getHeight() > 4096) {
                int n = bitmap.getWidth();
                int n2 = bitmap.getHeight();
                throw new IllegalArgumentException(new StringBuilder(119).append("Invalid Bitmap: Bitmap width and height must be smaller than 4096. Bitmap was ").append(n).append(" width and ").append(n2).append(" height.").toString());
            }
            this.bitmap = bitmap;
            this.registryId = null;
            this.inputStreamCreator = null;
            return this;
        }

        public Builder setData(TextureInternalData textureInternalData) {
            this.textureInternalData = textureInternalData;
            return this;
        }

        Builder setPremultiplied(boolean inPremultiplied) {
            this.inPremultiplied = inPremultiplied;
            return this;
        }

        public Builder setRegistryId(Object registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder setUsage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder setSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CompletableFuture<Texture> build() {
            CompletionStage<Texture> result;
            ResourceRegistry<Texture> registry;
            CompletableFuture textureFuture;
            AndroidPreconditions.checkUiThread();
            Object registryId = this.registryId;
            if (registryId != null && (textureFuture = (registry = ResourceManager.getInstance().getTextureRegistry()).get(registryId)) != null) {
                return textureFuture;
            }
            if (this.textureInternalData != null && registryId != null) {
                throw new IllegalStateException("Builder must not set both a bitmap and filament texture");
            }
            if (this.textureInternalData != null) {
                result = CompletableFuture.completedFuture(new Texture(this.textureInternalData));
            } else {
                CompletableFuture<Bitmap> bitmapFuture;
                if (this.inputStreamCreator != null) {
                    bitmapFuture = Builder.makeBitmap(this.inputStreamCreator, this.inPremultiplied);
                } else if (this.bitmap != null) {
                    bitmapFuture = CompletableFuture.completedFuture(this.bitmap);
                } else {
                    throw new IllegalStateException("Texture must have a source.");
                }
                result = bitmapFuture.thenApplyAsync(loadedBitmap -> {
                    TextureInternalData textureData = Builder.makeTextureData(loadedBitmap, this.sampler, this.usage, 255);
                    return new Texture(textureData);
                }, ThreadPools.getMainExecutor());
            }
            if (registryId != null) {
                ResourceRegistry<Texture> registry2 = ResourceManager.getInstance().getTextureRegistry();
                registry2.register(registryId, result);
            }
            String string = String.valueOf(registryId);
            FutureHelper.logOnException(TAG, result, new StringBuilder(36 + String.valueOf(string).length()).append("Unable to load Texture registryId='").append(string).append("'").toString());
            return result;
        }

        private static CompletableFuture<Bitmap> makeBitmap(Callable<InputStream> inputStreamCreator, boolean inPremultiplied) {
            return CompletableFuture.supplyAsync(() -> {
                Bitmap bitmap;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inScaled = false;
                options.inPremultiplied = inPremultiplied;
                try (InputStream inputStream = (InputStream)inputStreamCreator.call();){
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                if (bitmap == null) {
                    throw new IllegalStateException("Failed to decode the texture bitmap. The InputStream was not a valid bitmap.");
                }
                if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                    throw new IllegalStateException("Texture must use ARGB8 format.");
                }
                return bitmap;
            }, ThreadPools.getThreadPoolExecutor());
        }

        private static TextureInternalData makeTextureData(Bitmap bitmap, Sampler sampler, Usage usage, int mipLevels) {
            IEngine engine = EngineInstance.getEngine();
            Texture.InternalFormat textureInternalFormat = Texture.getInternalFormatForUsage(usage);
            Texture.Sampler textureSampler = Texture.Sampler.SAMPLER_2D;
            com.google.android.filament.Texture filamentTexture = new Texture.Builder().width(bitmap.getWidth()).height(bitmap.getHeight()).depth(1).levels(mipLevels).sampler(textureSampler).format(textureInternalFormat).build(engine.getFilamentEngine());
            TextureHelper.setBitmap((Engine)engine.getFilamentEngine(), (com.google.android.filament.Texture)filamentTexture, (int)0, (Bitmap)bitmap);
            if (mipLevels > 1) {
                filamentTexture.generateMipmaps(engine.getFilamentEngine());
            }
            return new TextureInternalData(filamentTexture, sampler);
        }
    }

    public static enum Usage {
        COLOR,
        NORMAL,
        DATA;

    }
}

