/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.ar.sceneform.rendering.CameraStream;
import com.google.ar.sceneform.rendering.CleanupRegistry;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.rendering.Texture;
import com.google.ar.sceneform.rendering.ViewRenderable;
import com.google.ar.sceneform.resources.ResourceHolder;
import com.google.ar.sceneform.resources.ResourceRegistry;
import java.util.ArrayList;

public class ResourceManager {
    @Nullable
    private static ResourceManager instance = null;
    private final ArrayList<ResourceHolder> resourceHolders = new ArrayList();
    private final ResourceRegistry<Texture> textureRegistry = new ResourceRegistry();
    private final ResourceRegistry<Material> materialRegistry = new ResourceRegistry();
    private final ResourceRegistry<ModelRenderable> modelRenderableRegistry = new ResourceRegistry();
    private final ResourceRegistry<ViewRenderable> viewRenderableRegistry = new ResourceRegistry();
    private final CleanupRegistry<CameraStream> cameraStreamCleanupRegistry = new CleanupRegistry();
    private final CleanupRegistry<ExternalTexture> externalTextureCleanupRegistry = new CleanupRegistry();
    private final CleanupRegistry<Material> materialCleanupRegistry = new CleanupRegistry();
    private final CleanupRegistry<RenderableInstance> renderableInstanceCleanupRegistry = new CleanupRegistry();
    private final CleanupRegistry<Texture> textureCleanupRegistry = new CleanupRegistry();

    ResourceRegistry<Texture> getTextureRegistry() {
        return this.textureRegistry;
    }

    ResourceRegistry<Material> getMaterialRegistry() {
        return this.materialRegistry;
    }

    ResourceRegistry<ModelRenderable> getModelRenderableRegistry() {
        return this.modelRenderableRegistry;
    }

    ResourceRegistry<ViewRenderable> getViewRenderableRegistry() {
        return this.viewRenderableRegistry;
    }

    CleanupRegistry<CameraStream> getCameraStreamCleanupRegistry() {
        return this.cameraStreamCleanupRegistry;
    }

    CleanupRegistry<ExternalTexture> getExternalTextureCleanupRegistry() {
        return this.externalTextureCleanupRegistry;
    }

    CleanupRegistry<Material> getMaterialCleanupRegistry() {
        return this.materialCleanupRegistry;
    }

    CleanupRegistry<RenderableInstance> getRenderableInstanceCleanupRegistry() {
        return this.renderableInstanceCleanupRegistry;
    }

    CleanupRegistry<Texture> getTextureCleanupRegistry() {
        return this.textureCleanupRegistry;
    }

    public long reclaimReleasedResources() {
        long resourcesInUse = 0L;
        for (ResourceHolder registry : this.resourceHolders) {
            resourcesInUse += registry.reclaimReleasedResources();
        }
        return resourcesInUse;
    }

    public void destroyAllResources() {
        for (ResourceHolder resourceHolder : this.resourceHolders) {
            resourceHolder.destroyAllResources();
        }
    }

    public void addResourceHolder(ResourceHolder resource) {
        this.resourceHolders.add(resource);
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    private ResourceManager() {
        this.addResourceHolder((ResourceHolder)this.textureRegistry);
        this.addResourceHolder((ResourceHolder)this.materialRegistry);
        this.addResourceHolder((ResourceHolder)this.modelRenderableRegistry);
        this.addViewRenderableRegistry();
        this.addResourceHolder(this.cameraStreamCleanupRegistry);
        this.addResourceHolder(this.externalTextureCleanupRegistry);
        this.addResourceHolder(this.materialCleanupRegistry);
        this.addResourceHolder(this.renderableInstanceCleanupRegistry);
        this.addResourceHolder(this.textureCleanupRegistry);
    }

    private void addViewRenderableRegistry() {
        this.addResourceHolder((ResourceHolder)this.viewRenderableRegistry);
    }
}

