/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.view.Surface;
import android.view.SurfaceView;
import com.google.android.filament.Camera;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.Scene;
import com.google.android.filament.SwapChain;
import com.google.android.filament.TransformManager;
import com.google.android.filament.View;
import com.google.android.filament.Viewport;
import com.google.android.filament.android.UiHelper;
import com.google.ar.sceneform.rendering.CameraProvider;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.LightInstance;
import com.google.ar.sceneform.rendering.LightProbe;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.ViewAttachmentManager;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.EnvironmentalHdrParameters;
import com.google.ar.sceneform.utilities.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Renderer
implements UiHelper.RendererCallback {
    private static final float DEFAULT_CAMERA_APERATURE = 4.0f;
    private static final float DEFAULT_CAMERA_SHUTTER_SPEED = 0.033333335f;
    private static final float DEFAULT_CAMERA_ISO = 320.0f;
    private static final float ARCORE_HDR_LIGHTING_CAMERA_APERATURE = 1.0f;
    private static final float ARCORE_HDR_LIGHTING_CAMERA_SHUTTER_SPEED = 1.2f;
    private static final float ARCORE_HDR_LIGHTING_CAMERA_ISO = 100.0f;
    private static final Color DEFAULT_CLEAR_COLOR = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private static final int MAXIMUM_RESOLUTION = 1080;
    @Nullable
    private CameraProvider cameraProvider;
    private final SurfaceView surfaceView;
    private final ViewAttachmentManager viewAttachmentManager;
    private final ArrayList<RenderableInstance> renderableInstances = new ArrayList();
    private final ArrayList<LightInstance> lightInstances = new ArrayList();
    private Surface surface;
    @Nullable
    private SwapChain swapChain;
    private View view;
    private View emptyView;
    private com.google.android.filament.Renderer renderer;
    private Camera camera;
    private Scene scene;
    private IndirectLight indirectLight;
    private boolean recreateSwapChain;
    private float cameraAperature;
    private float cameraShutterSpeed;
    private float cameraIso;
    private UiHelper filamentHelper;
    private final double[] cameraProjectionMatrix = new double[16];
    private EnvironmentalHdrParameters environmentalHdrParameters = EnvironmentalHdrParameters.makeDefault();
    private final List<Mirror> mirrors = new ArrayList<Mirror>();
    @Nullable
    private Runnable onFrameRenderDebugCallback = null;
    @Nullable
    private PreRenderCallback preRenderCallback;

    @RequiresApi(api=24)
    public Renderer(SurfaceView view) {
        Preconditions.checkNotNull((Object)view, (Object)"Parameter \"view\" was null.");
        AndroidPreconditions.checkMinAndroidApiLevel();
        this.surfaceView = view;
        this.viewAttachmentManager = new ViewAttachmentManager(this.getContext(), (android.view.View)view);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMirroring(Surface surface, int left, int bottom, int width, int height) {
        Mirror mirror = new Mirror();
        mirror.surface = surface;
        mirror.viewport = new Viewport(left, bottom, width, height);
        mirror.swapChain = null;
        List<Mirror> list = this.mirrors;
        synchronized (list) {
            this.mirrors.add(mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMirroring(Surface surface) {
        List<Mirror> list = this.mirrors;
        synchronized (list) {
            for (Mirror mirror : this.mirrors) {
                if (mirror.surface != surface) continue;
                mirror.surface = null;
            }
        }
    }

    public com.google.android.filament.Renderer getFilamentRenderer() {
        return this.renderer;
    }

    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    public void setClearColor(Color color) {
        this.view.setClearColor(color.r, color.g, color.b, color.a);
    }

    public void setDefaultClearColor() {
        this.setClearColor(DEFAULT_CLEAR_COLOR);
    }

    public void setFrontFaceWindingInverted(Boolean inverted) {
        this.view.setFrontFaceWindingInverted(inverted.booleanValue());
    }

    public boolean isFrontFaceWindingInverted() {
        return this.view.isFrontFaceWindingInverted();
    }

    public void setCameraProvider(@Nullable CameraProvider cameraProvider) {
        this.cameraProvider = cameraProvider;
    }

    public void onPause() {
        this.viewAttachmentManager.onPause();
    }

    public void onResume() {
        this.viewAttachmentManager.onResume();
    }

    public void setFrameRenderDebugCallback(Runnable onFrameRenderDebugCallback) {
        this.onFrameRenderDebugCallback = onFrameRenderDebugCallback;
    }

    private Viewport getLetterboxViewport(Viewport srcViewport, Viewport destViewport) {
        boolean letterBoxSides = (float)destViewport.width / (float)destViewport.height > (float)srcViewport.width / (float)srcViewport.height;
        float scale = letterBoxSides ? (float)destViewport.height / (float)srcViewport.height : (float)destViewport.width / (float)srcViewport.width;
        int width = (int)((float)srcViewport.width * scale);
        int height = (int)((float)srcViewport.height * scale);
        int left = (destViewport.width - width) / 2;
        int bottom = (destViewport.height - height) / 2;
        return new Viewport(left, bottom, width, height);
    }

    public void setPreRenderCallback(@Nullable PreRenderCallback preRenderCallback) {
        this.preRenderCallback = preRenderCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(boolean debugEnabled) {
        Object object = this;
        synchronized (object) {
            if (this.recreateSwapChain) {
                IEngine engine = EngineInstance.getEngine();
                if (this.swapChain != null) {
                    engine.destroySwapChain(this.swapChain);
                }
                this.swapChain = engine.createSwapChain(this.surface, 2L);
                this.recreateSwapChain = false;
            }
        }
        object = this.mirrors;
        synchronized (object) {
            Iterator<Mirror> mirrorIterator = this.mirrors.iterator();
            while (mirrorIterator.hasNext()) {
                IEngine engine;
                Mirror mirror = mirrorIterator.next();
                if (mirror.surface == null) {
                    if (mirror.swapChain != null) {
                        engine = EngineInstance.getEngine();
                        engine.destroySwapChain((SwapChain)Preconditions.checkNotNull((Object)mirror.swapChain));
                    }
                    mirrorIterator.remove();
                    continue;
                }
                if (mirror.swapChain != null) continue;
                engine = EngineInstance.getEngine();
                mirror.swapChain = engine.createSwapChain(Preconditions.checkNotNull((Object)mirror.surface));
            }
        }
        if (this.filamentHelper.isReadyToRender() || EngineInstance.isHeadlessMode()) {
            this.updateInstances();
            this.updateLights();
            CameraProvider cameraProvider = this.cameraProvider;
            if (cameraProvider != null) {
                float[] projectionMatrixData = cameraProvider.getProjectionMatrix().data;
                for (int i = 0; i < 16; ++i) {
                    this.cameraProjectionMatrix[i] = projectionMatrixData[i];
                }
                this.camera.setModelMatrix(cameraProvider.getWorldModelMatrix().data);
                this.camera.setCustomProjection(this.cameraProjectionMatrix, (double)cameraProvider.getNearClipPlane(), (double)cameraProvider.getFarClipPlane());
                SwapChain swapChainLocal = this.swapChain;
                if (swapChainLocal == null) {
                    throw new AssertionError((Object)"Internal Error: Failed to get swap chain");
                }
                if (this.renderer.beginFrame(swapChainLocal)) {
                    if (this.preRenderCallback != null) {
                        this.preRenderCallback.preRender(this.renderer, swapChainLocal, this.camera);
                    }
                    View currentView = cameraProvider.isActive() ? this.view : this.emptyView;
                    this.renderer.render(currentView);
                    List<Mirror> list = this.mirrors;
                    synchronized (list) {
                        for (Mirror mirror : this.mirrors) {
                            if (mirror.swapChain == null) continue;
                            this.renderer.mirrorFrame(mirror.swapChain, this.getLetterboxViewport(currentView.getViewport(), mirror.viewport), currentView.getViewport(), 7);
                        }
                    }
                    if (this.onFrameRenderDebugCallback != null) {
                        this.onFrameRenderDebugCallback.run();
                    }
                    this.renderer.endFrame();
                }
                Renderer.reclaimReleasedResources();
            }
        }
    }

    public void dispose() {
        this.filamentHelper.detach();
        IEngine engine = EngineInstance.getEngine();
        if (this.indirectLight != null) {
            engine.destroyIndirectLight(this.indirectLight);
        }
        engine.destroyRenderer(this.renderer);
        engine.destroyView(this.view);
        Renderer.reclaimReleasedResources();
    }

    public Context getContext() {
        return this.getSurfaceView().getContext();
    }

    public void setLightProbe(LightProbe lightProbe) {
        if (lightProbe == null) {
            throw new AssertionError((Object)"Passed in an invalid light probe.");
        }
        IndirectLight latestIndirectLight = lightProbe.buildIndirectLight();
        if (latestIndirectLight != null) {
            this.scene.setIndirectLight(latestIndirectLight);
            if (this.indirectLight != null && this.indirectLight != latestIndirectLight) {
                IEngine engine = EngineInstance.getEngine();
                engine.destroyIndirectLight(this.indirectLight);
            }
            this.indirectLight = latestIndirectLight;
        }
    }

    public void setDesiredSize(int width, int height) {
        int minor = Math.min(width, height);
        int major = Math.max(width, height);
        if (minor > 1080) {
            major = major * 1080 / minor;
            minor = 1080;
        }
        if (width < height) {
            int t = minor;
            minor = major;
            major = t;
        }
        this.filamentHelper.setDesiredSize(major, minor);
    }

    public int getDesiredWidth() {
        return this.filamentHelper.getDesiredWidth();
    }

    public int getDesiredHeight() {
        return this.filamentHelper.getDesiredHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNativeWindowChanged(Surface surface) {
        Renderer renderer = this;
        synchronized (renderer) {
            this.surface = surface;
            this.recreateSwapChain = true;
        }
    }

    public void onDetachedFromSurface() {
        SwapChain swapChainLocal = this.swapChain;
        if (swapChainLocal != null) {
            IEngine engine = EngineInstance.getEngine();
            engine.destroySwapChain(swapChainLocal);
            engine.flushAndWait();
            this.swapChain = null;
        }
    }

    public void setDynamicResolutionEnabled(boolean isEnabled) {
        View.DynamicResolutionOptions options = new View.DynamicResolutionOptions();
        options.enabled = isEnabled;
        options.targetFrameTimeMilli = 33.333332f;
        this.view.setDynamicResolutionOptions(options);
    }

    @VisibleForTesting
    public void setAntiAliasing(View.AntiAliasing antiAliasing) {
        this.view.setAntiAliasing(antiAliasing);
    }

    @VisibleForTesting
    public void setDithering(View.Dithering dithering) {
        this.view.setDithering(dithering);
    }

    public void setPostProcessingEnabled(boolean enablePostProcessing) {
    }

    public void setRenderQuality(View.RenderQuality renderQuality) {
    }

    public void enablePerformanceMode() {
    }

    public EnvironmentalHdrParameters getEnvironmentalHdrParameters() {
        return this.environmentalHdrParameters;
    }

    public void setEnvironmentalHdrParameters(EnvironmentalHdrParameters environmentalHdrParameters) {
        this.environmentalHdrParameters = environmentalHdrParameters;
    }

    public void onResized(int width, int height) {
        this.view.setViewport(new Viewport(0, 0, width, height));
        this.emptyView.setViewport(new Viewport(0, 0, width, height));
    }

    void addLight(LightInstance instance) {
        int entity = instance.getEntity();
        this.scene.addEntity(entity);
        this.lightInstances.add(instance);
    }

    void removeLight(LightInstance instance) {
        int entity = instance.getEntity();
        this.scene.remove(entity);
        this.lightInstances.remove(instance);
    }

    private void addModelInstanceInternal(RenderableInstance instance) {
    }

    private void removeModelInstanceInternal(RenderableInstance instance) {
    }

    void addInstance(RenderableInstance instance) {
        this.scene.addEntity(instance.getRenderedEntity());
        this.addModelInstanceInternal(instance);
        this.renderableInstances.add(instance);
    }

    void removeInstance(RenderableInstance instance) {
        this.removeModelInstanceInternal(instance);
        this.scene.remove(instance.getRenderedEntity());
        this.renderableInstances.remove(instance);
    }

    Scene getFilamentScene() {
        return this.scene;
    }

    ViewAttachmentManager getViewAttachmentManager() {
        return this.viewAttachmentManager;
    }

    private void initialize() {
        SurfaceView surfaceView = this.getSurfaceView();
        this.filamentHelper = new UiHelper(UiHelper.ContextErrorPolicy.DONT_CHECK);
        this.filamentHelper.setRenderCallback((UiHelper.RendererCallback)this);
        this.filamentHelper.attachTo(surfaceView);
        IEngine engine = EngineInstance.getEngine();
        this.renderer = engine.createRenderer();
        this.scene = engine.createScene();
        this.view = engine.createView();
        this.emptyView = engine.createView();
        this.camera = engine.createCamera();
        this.setUseHdrLightEstimate(false);
        this.setDefaultClearColor();
        this.view.setCamera(this.camera);
        this.view.setScene(this.scene);
        this.setDynamicResolutionEnabled(true);
        this.emptyView.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.emptyView.setCamera(engine.createCamera());
        this.emptyView.setScene(engine.createScene());
    }

    public void setUseHdrLightEstimate(boolean useHdrLightEstimate) {
        if (useHdrLightEstimate) {
            this.cameraAperature = 1.0f;
            this.cameraShutterSpeed = 1.2f;
            this.cameraIso = 100.0f;
        } else {
            this.cameraAperature = 4.0f;
            this.cameraShutterSpeed = 0.033333335f;
            this.cameraIso = 320.0f;
        }
        this.camera.setExposure(this.cameraAperature, this.cameraShutterSpeed, this.cameraIso);
    }

    public float getExposure() {
        float e = this.cameraAperature * this.cameraAperature / this.cameraShutterSpeed * 100.0f / this.cameraIso;
        return 1.0f / (1.2f * e);
    }

    private void updateInstances() {
        IEngine engine = EngineInstance.getEngine();
        TransformManager transformManager = engine.getTransformManager();
        transformManager.openLocalTransformTransaction();
        for (RenderableInstance renderableInstance : this.renderableInstances) {
            renderableInstance.prepareForDraw();
            float[] transform = renderableInstance.getWorldModelMatrix().data;
            renderableInstance.setModelMatrix(transformManager, transform);
        }
        transformManager.commitLocalTransformTransaction();
    }

    private void updateLights() {
        for (LightInstance lightInstance : this.lightInstances) {
            lightInstance.updateTransform();
        }
    }

    public static long reclaimReleasedResources() {
        return ResourceManager.getInstance().reclaimReleasedResources();
    }

    public static void destroyAllResources() {
        ResourceManager.getInstance().destroyAllResources();
        EngineInstance.destroyEngine();
    }

    public static interface PreRenderCallback {
        public void preRender(com.google.android.filament.Renderer var1, SwapChain var2, Camera var3);
    }

    private static class Mirror {
        @Nullable
        SwapChain swapChain;
        @Nullable
        Surface surface;
        Viewport viewport;

        private Mirror() {
        }
    }
}

