/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.filament.Box;
import com.google.android.filament.Entity;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.VertexBuffer;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.SkeletonRig;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;

class RenderableInternalData
implements IRenderableInternalData {
    private static final String TAG = RenderableInternalData.class.getSimpleName();
    private final Vector3 centerAabb = Vector3.zero();
    private final Vector3 extentsAabb = Vector3.zero();
    private float transformScale = 1.0f;
    private final Vector3 transformOffset = Vector3.zero();
    @Nullable
    private IntBuffer rawIndexBuffer;
    @Nullable
    private FloatBuffer rawPositionBuffer;
    @Nullable
    private FloatBuffer rawTangentsBuffer;
    @Nullable
    private FloatBuffer rawUvBuffer;
    @Nullable
    private FloatBuffer rawColorBuffer;
    @Nullable
    private IndexBuffer indexBuffer;
    @Nullable
    private VertexBuffer vertexBuffer;
    private final ArrayList<MeshData> meshes = new ArrayList();

    RenderableInternalData() {
    }

    @Override
    public void setCenterAabb(Vector3 minAabb) {
        this.centerAabb.set(minAabb);
    }

    @Override
    public Vector3 getCenterAabb() {
        return new Vector3(this.centerAabb);
    }

    @Override
    public void setExtentsAabb(Vector3 maxAabb) {
        this.extentsAabb.set(maxAabb);
    }

    @Override
    public Vector3 getExtentsAabb() {
        return new Vector3(this.extentsAabb);
    }

    @Override
    public Vector3 getSizeAabb() {
        return this.extentsAabb.scaled(2.0f);
    }

    @Override
    public void setTransformScale(float scale) {
        this.transformScale = scale;
    }

    @Override
    public float getTransformScale() {
        return this.transformScale;
    }

    @Override
    public void setTransformOffset(Vector3 offset) {
        this.transformOffset.set(offset);
    }

    @Override
    public Vector3 getTransformOffset() {
        return new Vector3(this.transformOffset);
    }

    @Override
    public ArrayList<MeshData> getMeshes() {
        return this.meshes;
    }

    @Override
    public void setIndexBuffer(@Nullable IndexBuffer indexBuffer) {
        this.indexBuffer = indexBuffer;
    }

    @Override
    @Nullable
    public IndexBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    @Override
    public void setVertexBuffer(@Nullable VertexBuffer vertexBuffer) {
        this.vertexBuffer = vertexBuffer;
    }

    @Override
    @Nullable
    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    @Override
    public void setRawIndexBuffer(@Nullable IntBuffer rawIndexBuffer) {
        this.rawIndexBuffer = rawIndexBuffer;
    }

    @Override
    @Nullable
    public IntBuffer getRawIndexBuffer() {
        return this.rawIndexBuffer;
    }

    @Override
    public void setRawPositionBuffer(@Nullable FloatBuffer rawPositionBuffer) {
        this.rawPositionBuffer = rawPositionBuffer;
    }

    @Override
    @Nullable
    public FloatBuffer getRawPositionBuffer() {
        return this.rawPositionBuffer;
    }

    @Override
    public void setRawTangentsBuffer(@Nullable FloatBuffer rawTangentsBuffer) {
        this.rawTangentsBuffer = rawTangentsBuffer;
    }

    @Override
    @Nullable
    public FloatBuffer getRawTangentsBuffer() {
        return this.rawTangentsBuffer;
    }

    @Override
    public void setRawUvBuffer(@Nullable FloatBuffer rawUvBuffer) {
        this.rawUvBuffer = rawUvBuffer;
    }

    @Override
    @Nullable
    public FloatBuffer getRawUvBuffer() {
        return this.rawUvBuffer;
    }

    @Override
    public void setRawColorBuffer(@Nullable FloatBuffer rawColorBuffer) {
        this.rawColorBuffer = rawColorBuffer;
    }

    @Override
    @Nullable
    public FloatBuffer getRawColorBuffer() {
        return this.rawColorBuffer;
    }

    @Override
    public void buildInstanceData(Renderable renderable, @Nullable SkeletonRig skeleton, @Entity int renderedEntity) {
        IRenderableInternalData renderableData = renderable.getRenderableData();
        ArrayList<Material> materialBindings = renderable.getMaterialBindings();
        RenderableManager renderableManager = EngineInstance.getEngine().getRenderableManager();
        int renderableInstance = renderableManager.getInstance(renderedEntity);
        int meshCount = renderableData.getMeshes().size();
        if (renderableInstance == 0 || renderableManager.getPrimitiveCount(renderableInstance) != meshCount) {
            if (renderableInstance != 0) {
                renderableManager.destroy(renderedEntity);
            }
            RenderableManager.Builder builder = new RenderableManager.Builder(meshCount).priority(renderable.getRenderPriority()).castShadows(renderable.isShadowCaster()).receiveShadows(renderable.isShadowReceiver());
            if (skeleton != null) {
                builder.skinning(skeleton.getMaterialBoneCount());
            }
            builder.build(EngineInstance.getEngine().getFilamentEngine(), renderedEntity);
            renderableInstance = renderableManager.getInstance(renderedEntity);
            if (renderableInstance == 0) {
                throw new AssertionError((Object)"Unable to create RenderableInstance.");
            }
        } else {
            renderableManager.setPriority(renderableInstance, renderable.getRenderPriority());
            renderableManager.setCastShadows(renderableInstance, renderable.isShadowCaster());
            renderableManager.setReceiveShadows(renderableInstance, renderable.isShadowReceiver());
        }
        Vector3 extents = renderableData.getExtentsAabb();
        Vector3 center = renderableData.getCenterAabb();
        Box filamentBox = new Box(center.x, center.y, center.z, extents.x, extents.y, extents.z);
        renderableManager.setAxisAlignedBoundingBox(renderableInstance, filamentBox);
        if (materialBindings.size() != meshCount) {
            throw new AssertionError((Object)"Material Bindings are out of sync with meshes.");
        }
        RenderableManager.PrimitiveType primitiveType = RenderableManager.PrimitiveType.TRIANGLES;
        for (int mesh = 0; mesh < meshCount; ++mesh) {
            MeshData meshData = renderableData.getMeshes().get(mesh);
            VertexBuffer vertexBuffer = renderableData.getVertexBuffer();
            IndexBuffer indexBuffer = renderableData.getIndexBuffer();
            if (vertexBuffer == null || indexBuffer == null) {
                throw new AssertionError((Object)"Internal Error: Failed to get vertex or index buffer");
            }
            renderableManager.setGeometryAt(renderableInstance, mesh, primitiveType, vertexBuffer, indexBuffer, meshData.indexStart, meshData.indexEnd - meshData.indexStart);
            Material material = materialBindings.get(mesh);
            renderableManager.setMaterialInstanceAt(renderableInstance, mesh, material.getFilamentMaterialInstance());
        }
    }

    protected void finalize() throws Throwable {
        try {
            ThreadPools.getMainExecutor().execute(() -> this.dispose());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while Finalizing Renderable Internal Data.", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void dispose() {
        AndroidPreconditions.checkUiThread();
        IEngine engine = EngineInstance.getEngine();
        if (engine == null || !engine.isValid()) {
            return;
        }
        if (this.vertexBuffer != null) {
            engine.destroyVertexBuffer(this.vertexBuffer);
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            engine.destroyIndexBuffer(this.indexBuffer);
            this.indexBuffer = null;
        }
    }

    static class MeshData {
        int indexStart;
        int indexEnd;

        MeshData() {
        }
    }
}

