/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.VertexBuffer;
import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.RenderableInternalData;
import com.google.ar.sceneform.rendering.Vertex;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.Preconditions;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class RenderableDefinition {
    private static final Matrix scratchMatrix = new Matrix();
    private List<Vertex> vertices;
    private List<Submesh> submeshes;
    private static final int BYTES_PER_FLOAT = 4;
    private static final int POSITION_SIZE = 3;
    private static final int UV_SIZE = 2;
    private static final int TANGENTS_SIZE = 4;
    private static final int COLOR_SIZE = 4;

    public void setVertices(List<Vertex> vertices) {
        this.vertices = vertices;
    }

    List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setSubmeshes(List<Submesh> submeshes) {
        this.submeshes = submeshes;
    }

    List<Submesh> getSubmeshes() {
        return this.submeshes;
    }

    void applyDefinitionToData(IRenderableInternalData data, ArrayList<Material> materialBindings, ArrayList<String> materialNames) {
        AndroidPreconditions.checkUiThread();
        this.applyDefinitionToDataIndexBuffer(data);
        this.applyDefinitionToDataVertexBuffer(data);
        int indexStart = 0;
        materialBindings.clear();
        materialNames.clear();
        for (int i = 0; i < this.submeshes.size(); ++i) {
            RenderableInternalData.MeshData meshData;
            Submesh submesh = this.submeshes.get(i);
            if (i < data.getMeshes().size()) {
                meshData = data.getMeshes().get(i);
            } else {
                meshData = new RenderableInternalData.MeshData();
                data.getMeshes().add(meshData);
            }
            meshData.indexStart = indexStart;
            indexStart = meshData.indexEnd = indexStart + submesh.getTriangleIndices().size();
            materialBindings.add(submesh.getMaterial());
            String name = submesh.getName();
            materialNames.add(name != null ? name : "");
        }
        while (data.getMeshes().size() > this.submeshes.size()) {
            data.getMeshes().remove(data.getMeshes().size() - 1);
        }
    }

    private void applyDefinitionToDataIndexBuffer(IRenderableInternalData data) {
        int numIndices = 0;
        for (int i = 0; i < this.submeshes.size(); ++i) {
            Submesh submesh = this.submeshes.get(i);
            numIndices += submesh.getTriangleIndices().size();
        }
        IntBuffer rawIndexBuffer = data.getRawIndexBuffer();
        if (rawIndexBuffer == null || rawIndexBuffer.capacity() < numIndices) {
            rawIndexBuffer = IntBuffer.allocate(numIndices);
            data.setRawIndexBuffer(rawIndexBuffer);
        } else {
            rawIndexBuffer.rewind();
        }
        for (int i = 0; i < this.submeshes.size(); ++i) {
            Submesh submesh = this.submeshes.get(i);
            List<Integer> triangleIndices = submesh.getTriangleIndices();
            for (int j = 0; j < triangleIndices.size(); ++j) {
                rawIndexBuffer.put(triangleIndices.get(j));
            }
        }
        rawIndexBuffer.rewind();
        IndexBuffer indexBuffer = data.getIndexBuffer();
        IEngine engine = EngineInstance.getEngine();
        if (indexBuffer == null || indexBuffer.getIndexCount() < numIndices) {
            if (indexBuffer != null) {
                engine.destroyIndexBuffer(indexBuffer);
            }
            indexBuffer = new IndexBuffer.Builder().indexCount(numIndices).bufferType(IndexBuffer.Builder.IndexType.UINT).build(engine.getFilamentEngine());
            data.setIndexBuffer(indexBuffer);
        }
        indexBuffer.setBuffer(engine.getFilamentEngine(), (Buffer)rawIndexBuffer, 0, numIndices);
    }

    private void applyDefinitionToDataVertexBuffer(IRenderableInternalData data) {
        FloatBuffer positionBuffer;
        if (this.vertices.isEmpty()) {
            throw new IllegalArgumentException("RenderableDescription must have at least one vertex.");
        }
        int numVertices = this.vertices.size();
        Vertex firstVertex = this.vertices.get(0);
        EnumSet<VertexBuffer.VertexAttribute> descriptionAttributes = EnumSet.of(VertexBuffer.VertexAttribute.POSITION);
        if (firstVertex.getNormal() != null) {
            descriptionAttributes.add(VertexBuffer.VertexAttribute.TANGENTS);
        }
        if (firstVertex.getUvCoordinate() != null) {
            descriptionAttributes.add(VertexBuffer.VertexAttribute.UV0);
        }
        if (firstVertex.getColor() != null) {
            descriptionAttributes.add(VertexBuffer.VertexAttribute.COLOR);
        }
        VertexBuffer vertexBuffer = data.getVertexBuffer();
        boolean createVertexBuffer = true;
        if (vertexBuffer != null) {
            EnumSet<VertexBuffer.VertexAttribute> oldAttributes = EnumSet.of(VertexBuffer.VertexAttribute.POSITION);
            if (data.getRawTangentsBuffer() != null) {
                oldAttributes.add(VertexBuffer.VertexAttribute.TANGENTS);
            }
            if (data.getRawUvBuffer() != null) {
                oldAttributes.add(VertexBuffer.VertexAttribute.UV0);
            }
            if (data.getRawColorBuffer() != null) {
                oldAttributes.add(VertexBuffer.VertexAttribute.COLOR);
            }
            boolean bl = createVertexBuffer = !oldAttributes.equals(descriptionAttributes) || vertexBuffer.getVertexCount() < numVertices;
            if (createVertexBuffer) {
                EngineInstance.getEngine().destroyVertexBuffer(vertexBuffer);
            }
        }
        if (createVertexBuffer) {
            vertexBuffer = RenderableDefinition.createVertexBuffer(numVertices, descriptionAttributes);
            data.setVertexBuffer(vertexBuffer);
        }
        if ((positionBuffer = data.getRawPositionBuffer()) == null || positionBuffer.capacity() < numVertices * 3) {
            positionBuffer = FloatBuffer.allocate(numVertices * 3);
            data.setRawPositionBuffer(positionBuffer);
        } else {
            positionBuffer.rewind();
        }
        FloatBuffer tangentsBuffer = data.getRawTangentsBuffer();
        if (descriptionAttributes.contains(VertexBuffer.VertexAttribute.TANGENTS) && (tangentsBuffer == null || tangentsBuffer.capacity() < numVertices * 4)) {
            tangentsBuffer = FloatBuffer.allocate(numVertices * 4);
            data.setRawTangentsBuffer(tangentsBuffer);
        } else if (tangentsBuffer != null) {
            tangentsBuffer.rewind();
        }
        FloatBuffer uvBuffer = data.getRawUvBuffer();
        if (descriptionAttributes.contains(VertexBuffer.VertexAttribute.UV0) && (uvBuffer == null || uvBuffer.capacity() < numVertices * 2)) {
            uvBuffer = FloatBuffer.allocate(numVertices * 2);
            data.setRawUvBuffer(uvBuffer);
        } else if (uvBuffer != null) {
            uvBuffer.rewind();
        }
        FloatBuffer colorBuffer = data.getRawColorBuffer();
        if (descriptionAttributes.contains(VertexBuffer.VertexAttribute.COLOR) && (colorBuffer == null || colorBuffer.capacity() < numVertices * 4)) {
            colorBuffer = FloatBuffer.allocate(numVertices * 4);
            data.setRawColorBuffer(colorBuffer);
        } else if (colorBuffer != null) {
            colorBuffer.rewind();
        }
        Vector3 minAabb = new Vector3();
        Vector3 maxAabb = new Vector3();
        Vector3 firstPosition = firstVertex.getPosition();
        minAabb.set(firstPosition);
        maxAabb.set(firstPosition);
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex vertex = this.vertices.get(i);
            Vector3 position = vertex.getPosition();
            minAabb.set(Vector3.min((Vector3)minAabb, (Vector3)position));
            maxAabb.set(Vector3.max((Vector3)maxAabb, (Vector3)position));
            RenderableDefinition.addVector3ToBuffer(position, positionBuffer);
            if (tangentsBuffer != null) {
                Vector3 normal = vertex.getNormal();
                if (normal == null) {
                    throw new IllegalArgumentException("Missing normal: If any Vertex in a RenderableDescription has a normal, all vertices must have one.");
                }
                Quaternion tangent = RenderableDefinition.normalToTangent(normal);
                RenderableDefinition.addQuaternionToBuffer(tangent, tangentsBuffer);
            }
            if (uvBuffer != null) {
                Vertex.UvCoordinate uvCoordinate = vertex.getUvCoordinate();
                if (uvCoordinate == null) {
                    throw new IllegalArgumentException("Missing UV Coordinate: If any Vertex in a RenderableDescription has a UV Coordinate, all vertices must have one.");
                }
                RenderableDefinition.addUvToBuffer(uvCoordinate, uvBuffer);
            }
            if (colorBuffer == null) continue;
            Color color = vertex.getColor();
            if (color == null) {
                throw new IllegalArgumentException("Missing Color: If any Vertex in a RenderableDescription has a Color, all vertices must have one.");
            }
            RenderableDefinition.addColorToBuffer(color, colorBuffer);
        }
        Vector3 extentsAabb = Vector3.subtract((Vector3)maxAabb, (Vector3)minAabb).scaled(0.5f);
        Vector3 centerAabb = Vector3.add((Vector3)minAabb, (Vector3)extentsAabb);
        data.setExtentsAabb(extentsAabb);
        data.setCenterAabb(centerAabb);
        if (vertexBuffer == null) {
            throw new AssertionError((Object)"VertexBuffer is null.");
        }
        IEngine engine = EngineInstance.getEngine();
        positionBuffer.rewind();
        int bufferIndex = 0;
        vertexBuffer.setBufferAt(engine.getFilamentEngine(), bufferIndex, (Buffer)positionBuffer, 0, numVertices * 3);
        if (tangentsBuffer != null) {
            tangentsBuffer.rewind();
            vertexBuffer.setBufferAt(engine.getFilamentEngine(), ++bufferIndex, (Buffer)tangentsBuffer, 0, numVertices * 4);
        }
        if (uvBuffer != null) {
            uvBuffer.rewind();
            vertexBuffer.setBufferAt(engine.getFilamentEngine(), ++bufferIndex, (Buffer)uvBuffer, 0, numVertices * 2);
        }
        if (colorBuffer != null) {
            colorBuffer.rewind();
            vertexBuffer.setBufferAt(engine.getFilamentEngine(), ++bufferIndex, (Buffer)colorBuffer, 0, numVertices * 4);
        }
    }

    private RenderableDefinition(Builder builder) {
        this.vertices = (List)Preconditions.checkNotNull((Object)builder.vertices);
        this.submeshes = (List)Preconditions.checkNotNull((Object)builder.submeshes);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static VertexBuffer createVertexBuffer(int vertexCount, EnumSet<VertexBuffer.VertexAttribute> attributes) {
        VertexBuffer.Builder builder = new VertexBuffer.Builder();
        builder.vertexCount(vertexCount).bufferCount(attributes.size());
        int bufferIndex = 0;
        builder.attribute(VertexBuffer.VertexAttribute.POSITION, bufferIndex, VertexBuffer.AttributeType.FLOAT3, 0, 12);
        if (attributes.contains(VertexBuffer.VertexAttribute.TANGENTS)) {
            builder.attribute(VertexBuffer.VertexAttribute.TANGENTS, ++bufferIndex, VertexBuffer.AttributeType.FLOAT4, 0, 16);
        }
        if (attributes.contains(VertexBuffer.VertexAttribute.UV0)) {
            builder.attribute(VertexBuffer.VertexAttribute.UV0, ++bufferIndex, VertexBuffer.AttributeType.FLOAT2, 0, 8);
        }
        if (attributes.contains(VertexBuffer.VertexAttribute.COLOR)) {
            builder.attribute(VertexBuffer.VertexAttribute.COLOR, ++bufferIndex, VertexBuffer.AttributeType.FLOAT4, 0, 16);
        }
        return builder.build(EngineInstance.getEngine().getFilamentEngine());
    }

    private static void addVector3ToBuffer(Vector3 vector3, FloatBuffer buffer) {
        buffer.put(vector3.x);
        buffer.put(vector3.y);
        buffer.put(vector3.z);
    }

    private static void addUvToBuffer(Vertex.UvCoordinate uvCoordinate, FloatBuffer buffer) {
        buffer.put(uvCoordinate.x);
        buffer.put(uvCoordinate.y);
    }

    private static void addQuaternionToBuffer(Quaternion quaternion, FloatBuffer buffer) {
        buffer.put(quaternion.x);
        buffer.put(quaternion.y);
        buffer.put(quaternion.z);
        buffer.put(quaternion.w);
    }

    private static void addColorToBuffer(Color color, FloatBuffer buffer) {
        buffer.put(color.r);
        buffer.put(color.g);
        buffer.put(color.b);
        buffer.put(color.a);
    }

    private static Quaternion normalToTangent(Vector3 normal) {
        Vector3 bitangent;
        Vector3 tangent = Vector3.cross((Vector3)Vector3.up(), (Vector3)normal);
        if (MathHelper.almostEqualRelativeAndAbs((float)Vector3.dot((Vector3)tangent, (Vector3)tangent), (float)0.0f)) {
            bitangent = Vector3.cross((Vector3)normal, (Vector3)Vector3.right()).normalized();
            tangent = Vector3.cross((Vector3)bitangent, (Vector3)normal).normalized();
        } else {
            tangent.set(tangent.normalized());
            bitangent = Vector3.cross((Vector3)normal, (Vector3)tangent).normalized();
        }
        boolean rowOne = false;
        RenderableDefinition.scratchMatrix.data[0] = tangent.x;
        RenderableDefinition.scratchMatrix.data[1] = tangent.y;
        RenderableDefinition.scratchMatrix.data[2] = tangent.z;
        int rowTwo = 4;
        RenderableDefinition.scratchMatrix.data[4] = bitangent.x;
        RenderableDefinition.scratchMatrix.data[5] = bitangent.y;
        RenderableDefinition.scratchMatrix.data[6] = bitangent.z;
        int rowThree = 8;
        RenderableDefinition.scratchMatrix.data[8] = normal.x;
        RenderableDefinition.scratchMatrix.data[9] = normal.y;
        RenderableDefinition.scratchMatrix.data[10] = normal.z;
        Quaternion orientationQuaternion = new Quaternion();
        scratchMatrix.extractQuaternion(orientationQuaternion);
        return orientationQuaternion;
    }

    public static final class Builder {
        @Nullable
        private List<Vertex> vertices;
        @Nullable
        private List<Submesh> submeshes = new ArrayList<Submesh>();

        public Builder setVertices(List<Vertex> vertices) {
            this.vertices = vertices;
            return this;
        }

        public Builder setSubmeshes(List<Submesh> submeshes) {
            this.submeshes = submeshes;
            return this;
        }

        public RenderableDefinition build() {
            return new RenderableDefinition(this);
        }
    }

    public static class Submesh {
        private List<Integer> triangleIndices;
        private Material material;
        @Nullable
        private String name;

        public void setTriangleIndices(List<Integer> triangleIndices) {
            this.triangleIndices = triangleIndices;
        }

        public List<Integer> getTriangleIndices() {
            return this.triangleIndices;
        }

        public void setMaterial(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        private Submesh(Builder builder) {
            this.triangleIndices = (List)Preconditions.checkNotNull((Object)builder.triangleIndices);
            this.material = (Material)Preconditions.checkNotNull((Object)builder.material);
            this.name = builder.name;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private List<Integer> triangleIndices;
            @Nullable
            private Material material;
            @Nullable
            private String name;

            public Builder setTriangleIndices(List<Integer> triangleIndices) {
                this.triangleIndices = triangleIndices;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setMaterial(Material material) {
                this.material = material;
                return this;
            }

            public Submesh build() {
                return new Submesh(this);
            }
        }
    }
}

