/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.View;
import android.widget.LinearLayout;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.ViewAttachmentManager;
import com.google.ar.sceneform.utilities.Preconditions;
import java.util.ArrayList;

class RenderViewToExternalTexture
extends LinearLayout {
    private final View view;
    private final ExternalTexture externalTexture;
    private final Picture picture = new Picture();
    private boolean hasDrawnToSurfaceTexture = false;
    @Nullable
    private ViewAttachmentManager viewAttachmentManager;
    private final ArrayList<OnViewSizeChangedListener> onViewSizeChangedListeners = new ArrayList();

    RenderViewToExternalTexture(Context context, View view) {
        super(context);
        Preconditions.checkNotNull((Object)view, (Object)"Parameter \"view\" was null.");
        this.externalTexture = new ExternalTexture();
        this.view = view;
        this.addView(view);
    }

    void addOnViewSizeChangedListener(OnViewSizeChangedListener onViewSizeChangedListener) {
        if (!this.onViewSizeChangedListeners.contains(onViewSizeChangedListener)) {
            this.onViewSizeChangedListeners.add(onViewSizeChangedListener);
        }
    }

    void removeOnViewSizeChangedListener(OnViewSizeChangedListener onViewSizeChangedListener) {
        this.onViewSizeChangedListeners.remove(onViewSizeChangedListener);
    }

    ExternalTexture getExternalTexture() {
        return this.externalTexture;
    }

    boolean hasDrawnToSurfaceTexture() {
        return this.hasDrawnToSurfaceTexture;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.externalTexture.getSurfaceTexture().setDefaultBufferSize(this.view.getWidth(), this.view.getHeight());
    }

    public void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        for (OnViewSizeChangedListener onViewSizeChangedListener : this.onViewSizeChangedListeners) {
            onViewSizeChangedListener.onViewSizeChanged(width, height);
        }
    }

    public void dispatchDraw(Canvas canvas) {
        Surface targetSurface = this.externalTexture.getSurface();
        if (!targetSurface.isValid()) {
            return;
        }
        if (this.view.isDirty()) {
            Canvas pictureCanvas = this.picture.beginRecording(this.view.getWidth(), this.view.getHeight());
            pictureCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            super.dispatchDraw(pictureCanvas);
            this.picture.endRecording();
            Canvas surfaceCanvas = targetSurface.lockCanvas(null);
            this.picture.draw(surfaceCanvas);
            targetSurface.unlockCanvasAndPost(surfaceCanvas);
            this.hasDrawnToSurfaceTexture = true;
        }
        this.invalidate();
    }

    void attachView(ViewAttachmentManager viewAttachmentManager) {
        if (this.viewAttachmentManager != null) {
            if (this.viewAttachmentManager != viewAttachmentManager) {
                throw new IllegalStateException("Cannot use the same ViewRenderable with multiple SceneViews.");
            }
            return;
        }
        this.viewAttachmentManager = viewAttachmentManager;
        viewAttachmentManager.addView((View)this);
    }

    void detachView() {
        if (this.viewAttachmentManager != null) {
            this.viewAttachmentManager.removeView((View)this);
            this.viewAttachmentManager = null;
        }
    }

    void releaseResources() {
        this.detachView();
    }

    public static interface OnViewSizeChangedListener {
        public void onViewSizeChanged(int var1, int var2);
    }
}

