/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.ar.core.Plane;
import com.google.ar.core.TrackingState;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.RenderableDefinition;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.Vertex;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

class PlaneVisualizer
implements TransformProvider {
    private static final String TAG = PlaneVisualizer.class.getSimpleName();
    private final Plane plane;
    private final Renderer renderer;
    private final Matrix planeMatrix = new Matrix();
    private boolean isPlaneAddedToScene = false;
    private boolean isEnabled = false;
    private boolean isShadowReceiver = false;
    private boolean isVisible = false;
    @Nullable
    private ModelRenderable planeRenderable = null;
    @Nullable
    private RenderableInstance planeRenderableInstance;
    private final ArrayList<Vertex> vertices = new ArrayList();
    private final ArrayList<Integer> triangleIndices = new ArrayList();
    private final RenderableDefinition renderableDefinition;
    @Nullable
    private RenderableDefinition.Submesh planeSubmesh;
    @Nullable
    private RenderableDefinition.Submesh shadowSubmesh;
    private static final int VERTS_PER_BOUNDARY_VERT = 2;
    private static final float FEATHER_LENGTH = 0.2f;
    private static final float FEATHER_SCALE = 0.2f;

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.updatePlane();
        }
    }

    public void setShadowReceiver(boolean shadowReceiver) {
        if (this.isShadowReceiver != shadowReceiver) {
            this.isShadowReceiver = shadowReceiver;
            this.updatePlane();
        }
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            this.updatePlane();
        }
    }

    PlaneVisualizer(Plane plane, Renderer renderer) {
        this.plane = plane;
        this.renderer = renderer;
        this.renderableDefinition = RenderableDefinition.builder().setVertices(this.vertices).build();
    }

    Plane getPlane() {
        return this.plane;
    }

    void setShadowMaterial(Material material) {
        if (this.shadowSubmesh == null) {
            this.shadowSubmesh = RenderableDefinition.Submesh.builder().setTriangleIndices(this.triangleIndices).setMaterial(material).build();
        } else {
            this.shadowSubmesh.setMaterial(material);
        }
        if (this.planeRenderable != null) {
            this.updateRenderable();
        }
    }

    void setPlaneMaterial(Material material) {
        if (this.planeSubmesh == null) {
            this.planeSubmesh = RenderableDefinition.Submesh.builder().setTriangleIndices(this.triangleIndices).setMaterial(material).build();
        } else {
            this.planeSubmesh.setMaterial(material);
        }
        if (this.planeRenderable != null) {
            this.updateRenderable();
        }
    }

    public Matrix getWorldModelMatrix() {
        return this.planeMatrix;
    }

    void updatePlane() {
        if (!this.isEnabled || !this.isVisible && !this.isShadowReceiver) {
            this.removePlaneFromScene();
            return;
        }
        if (this.plane.getTrackingState() != TrackingState.TRACKING) {
            this.removePlaneFromScene();
            return;
        }
        this.plane.getCenterPose().toMatrix(this.planeMatrix.data, 0);
        boolean success = this.updateRenderableDefinitionForPlane();
        if (!success) {
            this.removePlaneFromScene();
            return;
        }
        this.updateRenderable();
        this.addPlaneToScene();
    }

    void updateRenderable() {
        List<RenderableDefinition.Submesh> submeshes = this.renderableDefinition.getSubmeshes();
        submeshes.clear();
        if (this.isVisible && this.planeSubmesh != null) {
            submeshes.add(this.planeSubmesh);
        }
        if (this.isShadowReceiver && this.shadowSubmesh != null) {
            submeshes.add(this.shadowSubmesh);
        }
        if (submeshes.isEmpty()) {
            this.removePlaneFromScene();
            return;
        }
        if (this.planeRenderable == null) {
            try {
                this.planeRenderable = (ModelRenderable)((ModelRenderable.Builder)ModelRenderable.builder().setSource(this.renderableDefinition)).build().get();
                this.planeRenderable.setShadowCaster(false);
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new AssertionError((Object)"Unable to create plane renderable.");
            }
            this.planeRenderableInstance = this.planeRenderable.createInstance(this);
        } else {
            this.planeRenderable.updateFromDefinition(this.renderableDefinition);
        }
        if (this.planeRenderableInstance != null && submeshes.size() > 1) {
            this.planeRenderableInstance.setBlendOrderAt(0, 0);
            this.planeRenderableInstance.setBlendOrderAt(1, 1);
        }
    }

    void release() {
        this.removePlaneFromScene();
        this.planeRenderable = null;
    }

    private void addPlaneToScene() {
        if (this.isPlaneAddedToScene || this.planeRenderableInstance == null) {
            return;
        }
        this.renderer.addInstance(this.planeRenderableInstance);
        this.isPlaneAddedToScene = true;
    }

    private void removePlaneFromScene() {
        if (!this.isPlaneAddedToScene || this.planeRenderableInstance == null) {
            return;
        }
        this.renderer.removeInstance(this.planeRenderableInstance);
        this.isPlaneAddedToScene = false;
    }

    private boolean updateRenderableDefinitionForPlane() {
        int i;
        float z;
        float x;
        FloatBuffer boundary = this.plane.getPolygon();
        if (boundary == null) {
            return false;
        }
        boundary.rewind();
        int boundaryVertices = boundary.limit() / 2;
        if (boundaryVertices == 0) {
            return false;
        }
        int numVertices = boundaryVertices * 2;
        this.vertices.clear();
        this.vertices.ensureCapacity(numVertices);
        int numIndices = boundaryVertices * 6 + (boundaryVertices - 2) * 3;
        this.triangleIndices.clear();
        this.triangleIndices.ensureCapacity(numIndices);
        Vector3 normal = Vector3.up();
        while (boundary.hasRemaining()) {
            x = boundary.get();
            z = boundary.get();
            this.vertices.add(Vertex.builder().setPosition(new Vector3(x, 0.0f, z)).setNormal(normal).build());
        }
        boundary.rewind();
        while (boundary.hasRemaining()) {
            x = boundary.get();
            z = boundary.get();
            float magnitude = (float)Math.hypot(x, z);
            float scale = 0.8f;
            if (magnitude != 0.0f) {
                scale = 1.0f - Math.min(0.2f / magnitude, 0.2f);
            }
            this.vertices.add(Vertex.builder().setPosition(new Vector3(x * scale, 1.0f, z * scale)).setNormal(normal).build());
        }
        int firstOuterVertex = 0;
        short firstInnerVertex = (short)boundaryVertices;
        for (i = 0; i < boundaryVertices - 2; ++i) {
            this.triangleIndices.add(Integer.valueOf(firstInnerVertex));
            this.triangleIndices.add(firstInnerVertex + i + 1);
            this.triangleIndices.add(firstInnerVertex + i + 2);
        }
        for (i = 0; i < boundaryVertices; ++i) {
            int outerVertex1 = firstOuterVertex + i;
            int outerVertex2 = firstOuterVertex + (i + 1) % boundaryVertices;
            int innerVertex1 = firstInnerVertex + i;
            int innerVertex2 = firstInnerVertex + (i + 1) % boundaryVertices;
            this.triangleIndices.add(outerVertex1);
            this.triangleIndices.add(outerVertex2);
            this.triangleIndices.add(innerVertex1);
            this.triangleIndices.add(innerVertex1);
            this.triangleIndices.add(outerVertex2);
            this.triangleIndices.add(innerVertex2);
        }
        return true;
    }
}

