/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.TextureSampler;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.Texture;
import java.util.HashMap;

@UsedByNative(value="material_java_wrappers.h")
final class MaterialParameters {
    private final HashMap<String, Parameter> namedParameters = new HashMap();

    MaterialParameters() {
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setBoolean(String name, boolean x) {
        this.namedParameters.put(name, new BooleanParameter(name, x));
    }

    boolean getBoolean(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof BooleanParameter) {
            BooleanParameter booleanParam = (BooleanParameter)param;
            return booleanParam.x;
        }
        return false;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setBoolean2(String name, boolean x, boolean y) {
        this.namedParameters.put(name, new Boolean2Parameter(name, x, y));
    }

    @Nullable
    boolean[] getBoolean2(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Boolean2Parameter) {
            Boolean2Parameter boolean2 = (Boolean2Parameter)param;
            return new boolean[]{boolean2.x, boolean2.y};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setBoolean3(String name, boolean x, boolean y, boolean z) {
        this.namedParameters.put(name, new Boolean3Parameter(name, x, y, z));
    }

    @Nullable
    boolean[] getBoolean3(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Boolean3Parameter) {
            Boolean3Parameter boolean3 = (Boolean3Parameter)param;
            return new boolean[]{boolean3.x, boolean3.y, boolean3.z};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setBoolean4(String name, boolean x, boolean y, boolean z, boolean w) {
        this.namedParameters.put(name, new Boolean4Parameter(name, x, y, z, w));
    }

    @Nullable
    boolean[] getBoolean4(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Boolean4Parameter) {
            Boolean4Parameter boolean4 = (Boolean4Parameter)param;
            return new boolean[]{boolean4.x, boolean4.y, boolean4.z, boolean4.w};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setFloat(String name, float x) {
        this.namedParameters.put(name, new FloatParameter(name, x));
    }

    float getFloat(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof FloatParameter) {
            FloatParameter floatParam = (FloatParameter)param;
            return floatParam.x;
        }
        return 0.0f;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setFloat2(String name, float x, float y) {
        this.namedParameters.put(name, new Float2Parameter(name, x, y));
    }

    @Nullable
    float[] getFloat2(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Float2Parameter) {
            Float2Parameter float2 = (Float2Parameter)param;
            return new float[]{float2.x, float2.y};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setFloat3(String name, float x, float y, float z) {
        this.namedParameters.put(name, new Float3Parameter(name, x, y, z));
    }

    void setFloat3(String name, Vector3 value) {
        this.namedParameters.put(name, new Float3Parameter(name, value.x, value.y, value.z));
    }

    @Nullable
    float[] getFloat3(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Float3Parameter) {
            Float3Parameter float3 = (Float3Parameter)param;
            return new float[]{float3.x, float3.y, float3.z};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setFloat4(String name, float x, float y, float z, float w) {
        this.namedParameters.put(name, new Float4Parameter(name, x, y, z, w));
    }

    @Nullable
    float[] getFloat4(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Float4Parameter) {
            Float4Parameter float4 = (Float4Parameter)param;
            return new float[]{float4.x, float4.y, float4.z, float4.w};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setInt(String name, int x) {
        this.namedParameters.put(name, new IntParameter(name, x));
    }

    int getInt(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof IntParameter) {
            IntParameter intParam = (IntParameter)param;
            return intParam.x;
        }
        return 0;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setInt2(String name, int x, int y) {
        this.namedParameters.put(name, new Int2Parameter(name, x, y));
    }

    @Nullable
    int[] getInt2(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Int2Parameter) {
            Int2Parameter int2 = (Int2Parameter)param;
            return new int[]{int2.x, int2.y};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setInt3(String name, int x, int y, int z) {
        this.namedParameters.put(name, new Int3Parameter(name, x, y, z));
    }

    @Nullable
    int[] getInt3(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Int3Parameter) {
            Int3Parameter int3 = (Int3Parameter)param;
            return new int[]{int3.x, int3.y, int3.z};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setInt4(String name, int x, int y, int z, int w) {
        this.namedParameters.put(name, new Int4Parameter(name, x, y, z, w));
    }

    @Nullable
    int[] getInt4(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof Int4Parameter) {
            Int4Parameter int4 = (Int4Parameter)param;
            return new int[]{int4.x, int4.y, int4.z, int4.w};
        }
        return null;
    }

    @UsedByNative(value="material_java_wrappers.h")
    void setTexture(String name, Texture texture) {
        this.namedParameters.put(name, new TextureParameter(name, texture));
    }

    @Nullable
    Texture getTexture(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof TextureParameter) {
            return ((TextureParameter)param).texture;
        }
        return null;
    }

    void setExternalTexture(String name, ExternalTexture externalTexture) {
        this.namedParameters.put(name, new ExternalTextureParameter(name, externalTexture));
    }

    @Nullable
    ExternalTexture getExternalTexture(String name) {
        Parameter param = this.namedParameters.get(name);
        if (param instanceof ExternalTextureParameter) {
            return ((ExternalTextureParameter)param).externalTexture;
        }
        return null;
    }

    void applyTo(MaterialInstance materialInstance) {
        Material material = materialInstance.getMaterial();
        for (Parameter value : this.namedParameters.values()) {
            if (!material.hasParameter(value.name)) continue;
            value.applyTo(materialInstance);
        }
    }

    void copyFrom(MaterialParameters other) {
        this.namedParameters.clear();
        this.merge(other);
    }

    void merge(MaterialParameters other) {
        for (Parameter value : other.namedParameters.values()) {
            Parameter clonedValue = value.clone();
            this.namedParameters.put(clonedValue.name, clonedValue);
        }
    }

    void mergeIfAbsent(MaterialParameters other) {
        for (Parameter value : other.namedParameters.values()) {
            if (this.namedParameters.containsKey(value.name)) continue;
            Parameter clonedValue = value.clone();
            this.namedParameters.put(clonedValue.name, clonedValue);
        }
    }

    private static TextureSampler convertTextureSampler(Texture.Sampler sampler) {
        TextureSampler convertedSampler = new TextureSampler();
        switch (sampler.getMinFilter()) {
            case NEAREST: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.NEAREST);
                break;
            }
            case LINEAR: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.LINEAR);
                break;
            }
            case NEAREST_MIPMAP_NEAREST: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.NEAREST_MIPMAP_NEAREST);
                break;
            }
            case LINEAR_MIPMAP_NEAREST: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.LINEAR_MIPMAP_NEAREST);
                break;
            }
            case NEAREST_MIPMAP_LINEAR: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.NEAREST_MIPMAP_LINEAR);
                break;
            }
            case LINEAR_MIPMAP_LINEAR: {
                convertedSampler.setMinFilter(TextureSampler.MinFilter.LINEAR_MIPMAP_LINEAR);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid MinFilter");
            }
        }
        switch (sampler.getMagFilter()) {
            case NEAREST: {
                convertedSampler.setMagFilter(TextureSampler.MagFilter.NEAREST);
                break;
            }
            case LINEAR: {
                convertedSampler.setMagFilter(TextureSampler.MagFilter.LINEAR);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid MagFilter");
            }
        }
        convertedSampler.setWrapModeS(MaterialParameters.convertWrapMode(sampler.getWrapModeS()));
        convertedSampler.setWrapModeT(MaterialParameters.convertWrapMode(sampler.getWrapModeT()));
        convertedSampler.setWrapModeR(MaterialParameters.convertWrapMode(sampler.getWrapModeR()));
        return convertedSampler;
    }

    private static TextureSampler.WrapMode convertWrapMode(Texture.Sampler.WrapMode wrapMode) {
        switch (wrapMode) {
            case CLAMP_TO_EDGE: {
                return TextureSampler.WrapMode.CLAMP_TO_EDGE;
            }
            case REPEAT: {
                return TextureSampler.WrapMode.REPEAT;
            }
            case MIRRORED_REPEAT: {
                return TextureSampler.WrapMode.MIRRORED_REPEAT;
            }
        }
        throw new IllegalArgumentException("Invalid WrapMode");
    }

    static class ExternalTextureParameter
    extends Parameter {
        private final ExternalTexture externalTexture;

        ExternalTextureParameter(String name, ExternalTexture externalTexture) {
            this.name = name;
            this.externalTexture = externalTexture;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            TextureSampler filamentSampler = this.getExternalFilamentSampler();
            materialInstance.setParameter(this.name, this.externalTexture.getFilamentTexture(), filamentSampler);
        }

        private TextureSampler getExternalFilamentSampler() {
            TextureSampler filamentSampler = new TextureSampler();
            filamentSampler.setMinFilter(TextureSampler.MinFilter.LINEAR);
            filamentSampler.setMagFilter(TextureSampler.MagFilter.LINEAR);
            filamentSampler.setWrapModeS(TextureSampler.WrapMode.CLAMP_TO_EDGE);
            filamentSampler.setWrapModeT(TextureSampler.WrapMode.CLAMP_TO_EDGE);
            filamentSampler.setWrapModeR(TextureSampler.WrapMode.CLAMP_TO_EDGE);
            return filamentSampler;
        }

        @Override
        public Parameter clone() {
            return new ExternalTextureParameter(this.name, this.externalTexture);
        }
    }

    static class TextureParameter
    extends Parameter {
        final Texture texture;

        TextureParameter(String name, Texture texture) {
            this.name = name;
            this.texture = texture;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.texture.getFilamentTexture(), MaterialParameters.convertTextureSampler(this.texture.getSampler()));
        }

        @Override
        public Parameter clone() {
            return new TextureParameter(this.name, this.texture);
        }
    }

    static class Int4Parameter
    extends Parameter {
        int x;
        int y;
        int z;
        int w;

        Int4Parameter(String name, int x, int y, int z, int w) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z, this.w);
        }
    }

    static class Int3Parameter
    extends Parameter {
        int x;
        int y;
        int z;

        Int3Parameter(String name, int x, int y, int z) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z);
        }
    }

    static class Int2Parameter
    extends Parameter {
        int x;
        int y;

        Int2Parameter(String name, int x, int y) {
            this.name = name;
            this.x = x;
            this.y = y;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y);
        }
    }

    static class IntParameter
    extends Parameter {
        int x;

        IntParameter(String name, int x) {
            this.name = name;
            this.x = x;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x);
        }
    }

    static class Float4Parameter
    extends Parameter {
        float x;
        float y;
        float z;
        float w;

        Float4Parameter(String name, float x, float y, float z, float w) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z, this.w);
        }
    }

    static class Float3Parameter
    extends Parameter {
        float x;
        float y;
        float z;

        Float3Parameter(String name, float x, float y, float z) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z);
        }
    }

    static class Float2Parameter
    extends Parameter {
        float x;
        float y;

        Float2Parameter(String name, float x, float y) {
            this.name = name;
            this.x = x;
            this.y = y;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y);
        }
    }

    static class FloatParameter
    extends Parameter {
        float x;

        FloatParameter(String name, float x) {
            this.name = name;
            this.x = x;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x);
        }
    }

    static class Boolean4Parameter
    extends Parameter {
        boolean x;
        boolean y;
        boolean z;
        boolean w;

        Boolean4Parameter(String name, boolean x, boolean y, boolean z, boolean w) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z, this.w);
        }
    }

    static class Boolean3Parameter
    extends Parameter {
        boolean x;
        boolean y;
        boolean z;

        Boolean3Parameter(String name, boolean x, boolean y, boolean z) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y, this.z);
        }
    }

    static class Boolean2Parameter
    extends Parameter {
        boolean x;
        boolean y;

        Boolean2Parameter(String name, boolean x, boolean y) {
            this.name = name;
            this.x = x;
            this.y = y;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x, this.y);
        }
    }

    static class BooleanParameter
    extends Parameter {
        boolean x;

        BooleanParameter(String name, boolean x) {
            this.name = name;
            this.x = x;
        }

        @Override
        void applyTo(MaterialInstance materialInstance) {
            materialInstance.setParameter(this.name, this.x);
        }
    }

    static abstract class Parameter
    implements Cloneable {
        String name;

        Parameter() {
        }

        abstract void applyTo(MaterialInstance var1);

        public Parameter clone() {
            try {
                return (Parameter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

