/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.util.Log;
import com.google.android.filament.TextureSampler;
import com.google.ar.schemas.lull.ModelInstanceDef;
import com.google.ar.schemas.lull.TextureDef;
import com.google.ar.schemas.lull.VertexAttribute;
import java.nio.ByteBuffer;

public class LullModel {
    private static final String TAG = LullModel.class.getName();
    public static final TextureSampler.WrapMode[] fromLullWrapMode = new TextureSampler.WrapMode[]{TextureSampler.WrapMode.CLAMP_TO_EDGE, TextureSampler.WrapMode.CLAMP_TO_EDGE, TextureSampler.WrapMode.MIRRORED_REPEAT, TextureSampler.WrapMode.CLAMP_TO_EDGE, TextureSampler.WrapMode.REPEAT};

    public static boolean isLullModel(ByteBuffer buffer) {
        int lullModelHeaderLen = 4;
        return buffer.limit() > 4 && buffer.get(0) < 32 && buffer.get(1) == 0 && buffer.get(2) == 0;
    }

    public static int getByteCountPerVertex(ModelInstanceDef modelInstanceDef) {
        int vertexAttributeCount = modelInstanceDef.vertexAttributesLength();
        int bytesPerVertex = 0;
        block6: for (int i = 0; i < vertexAttributeCount; ++i) {
            VertexAttribute attribute = modelInstanceDef.vertexAttributes(i);
            switch (attribute.type()) {
                case 3: {
                    bytesPerVertex += 12;
                    continue block6;
                }
                case 4: {
                    bytesPerVertex += 16;
                    continue block6;
                }
                case 2: 
                case 6: {
                    bytesPerVertex += 8;
                    continue block6;
                }
                case 1: 
                case 5: 
                case 7: {
                    bytesPerVertex += 4;
                    continue block6;
                }
            }
        }
        return bytesPerVertex;
    }

    public static TextureSampler.MinFilter fromLullToMinFilter(TextureDef textureDef) {
        switch (textureDef.minFilter()) {
            case 0: {
                return TextureSampler.MinFilter.NEAREST;
            }
            case 1: {
                return TextureSampler.MinFilter.LINEAR;
            }
            case 2: {
                return TextureSampler.MinFilter.NEAREST_MIPMAP_NEAREST;
            }
            case 3: {
                return TextureSampler.MinFilter.LINEAR_MIPMAP_NEAREST;
            }
            case 4: {
                return TextureSampler.MinFilter.NEAREST_MIPMAP_LINEAR;
            }
            case 5: {
                return TextureSampler.MinFilter.LINEAR_MIPMAP_LINEAR;
            }
        }
        Log.e((String)TAG, (String)String.valueOf(textureDef.name()).concat(": Sampler has unknown min filter"));
        return TextureSampler.MinFilter.NEAREST;
    }

    public static TextureSampler.MagFilter fromLullToMagFilter(TextureDef textureDef) {
        switch (textureDef.magFilter()) {
            case 0: {
                return TextureSampler.MagFilter.NEAREST;
            }
            case 1: {
                return TextureSampler.MagFilter.LINEAR;
            }
        }
        Log.e((String)TAG, (String)String.valueOf(textureDef.name()).concat(": Sampler has unknown mag filter"));
        return TextureSampler.MagFilter.NEAREST;
    }
}

