/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityManager;
import com.google.android.filament.LightManager;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.Light;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.utilities.AndroidPreconditions;

public class LightInstance {
    private static final String TAG = LightInstance.class.getSimpleName();
    @Entity
    private final int entity;
    private final Light light;
    @Nullable
    private Renderer renderer;
    @Nullable
    private TransformProvider transformProvider = null;
    private Vector3 localPosition;
    private Vector3 localDirection;
    private boolean dirty;
    private LightInstanceChangeListener changeListener = new LightInstanceChangeListener();

    LightInstance(Light light, TransformProvider transformProvider) {
        this.light = light;
        this.transformProvider = transformProvider;
        this.localPosition = light.getLocalPosition();
        this.localDirection = light.getLocalDirection();
        this.dirty = false;
        light.addChangedListener(this.changeListener);
        this.entity = EntityManager.get().create();
        IEngine engine = EngineInstance.getEngine();
        if (light.getType() == Light.Type.POINT) {
            new LightManager.Builder(LightManager.Type.POINT).position(light.getLocalPosition().x, light.getLocalPosition().y, light.getLocalPosition().z).color(light.getColor().r, light.getColor().g, light.getColor().b).intensity(light.getIntensity()).falloff(light.getFalloffRadius()).castShadows(light.isShadowCastingEnabled()).build(engine.getFilamentEngine(), this.entity);
        } else if (light.getType() == Light.Type.DIRECTIONAL) {
            new LightManager.Builder(LightManager.Type.DIRECTIONAL).direction(light.getLocalDirection().x, light.getLocalDirection().y, light.getLocalDirection().z).color(light.getColor().r, light.getColor().g, light.getColor().b).intensity(light.getIntensity()).castShadows(light.isShadowCastingEnabled()).build(engine.getFilamentEngine(), this.entity);
        } else if (light.getType() == Light.Type.SPOTLIGHT) {
            new LightManager.Builder(LightManager.Type.SPOT).position(light.getLocalPosition().x, light.getLocalPosition().y, light.getLocalPosition().z).direction(light.getLocalDirection().x, light.getLocalDirection().y, light.getLocalDirection().z).color(light.getColor().r, light.getColor().g, light.getColor().b).intensity(light.getIntensity()).spotLightCone(Math.min(light.getInnerConeAngle(), light.getOuterConeAngle()), light.getOuterConeAngle()).castShadows(light.isShadowCastingEnabled()).build(engine.getFilamentEngine(), this.entity);
        } else if (light.getType() == Light.Type.FOCUSED_SPOTLIGHT) {
            new LightManager.Builder(LightManager.Type.FOCUSED_SPOT).position(light.getLocalPosition().x, light.getLocalPosition().y, light.getLocalPosition().z).direction(light.getLocalDirection().x, light.getLocalDirection().y, light.getLocalDirection().z).color(light.getColor().r, light.getColor().g, light.getColor().b).intensity(light.getIntensity()).spotLightCone(Math.min(light.getInnerConeAngle(), light.getOuterConeAngle()), light.getOuterConeAngle()).castShadows(light.isShadowCastingEnabled()).build(engine.getFilamentEngine(), this.entity);
        } else {
            throw new UnsupportedOperationException("Unsupported light type.");
        }
    }

    public void updateTransform() {
        this.updateProperties();
        if (this.transformProvider == null) {
            return;
        }
        IEngine engine = EngineInstance.getEngine();
        LightManager lightManager = engine.getLightManager();
        int instance = lightManager.getInstance(this.entity);
        Matrix transform = this.transformProvider.getWorldModelMatrix();
        if (LightInstance.lightTypeRequiresPosition(this.light.getType())) {
            Vector3 position = transform.transformPoint(this.localPosition);
            lightManager.setPosition(instance, position.x, position.y, position.z);
        }
        if (LightInstance.lightTypeRequiresDirection(this.light.getType())) {
            Vector3 direction = transform.transformDirection(this.localDirection);
            lightManager.setDirection(instance, direction.x, direction.y, direction.z);
        }
    }

    public void attachToRenderer(Renderer renderer) {
        renderer.addLight(this);
        this.renderer = renderer;
    }

    public void detachFromRenderer() {
        if (this.renderer != null) {
            this.renderer.removeLight(this);
        }
    }

    public Light getLight() {
        return this.light;
    }

    @Entity
    int getEntity() {
        return this.entity;
    }

    public void dispose() {
        IEngine engine;
        AndroidPreconditions.checkUiThread();
        if (this.light != null) {
            this.light.removeChangedListener(this.changeListener);
            this.changeListener = null;
        }
        if ((engine = EngineInstance.getEngine()) != null && engine.isValid()) {
            LightManager lightManager = engine.getLightManager();
            lightManager.destroy(this.entity);
            EntityManager entityManager = EntityManager.get();
            entityManager.destroy(this.entity);
        }
    }

    protected void finalize() throws Throwable {
        try {
            ThreadPools.getMainExecutor().execute(() -> this.dispose());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while Finalizing Light Instance.", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    private void updateProperties() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        IEngine engine = EngineInstance.getEngine();
        LightManager lightManager = engine.getLightManager();
        int instance = lightManager.getInstance(this.entity);
        this.localPosition = this.light.getLocalPosition();
        this.localDirection = this.light.getLocalDirection();
        if (this.transformProvider == null) {
            if (LightInstance.lightTypeRequiresPosition(this.light.getType())) {
                lightManager.setPosition(instance, this.localPosition.x, this.localPosition.y, this.localPosition.z);
            }
            if (LightInstance.lightTypeRequiresDirection(this.light.getType())) {
                lightManager.setDirection(instance, this.localDirection.x, this.localDirection.y, this.localDirection.z);
            }
        }
        lightManager.setColor(instance, this.light.getColor().r, this.light.getColor().g, this.light.getColor().b);
        lightManager.setIntensity(instance, this.light.getIntensity());
        if (this.light.getType() == Light.Type.POINT) {
            lightManager.setFalloff(instance, this.light.getFalloffRadius());
        } else if (this.light.getType() == Light.Type.SPOTLIGHT || this.light.getType() == Light.Type.FOCUSED_SPOTLIGHT) {
            lightManager.setSpotLightCone(instance, Math.min(this.light.getInnerConeAngle(), this.light.getOuterConeAngle()), this.light.getOuterConeAngle());
        }
    }

    private static boolean lightTypeRequiresPosition(Light.Type type) {
        return type == Light.Type.POINT || type == Light.Type.SPOTLIGHT || type == Light.Type.FOCUSED_SPOTLIGHT;
    }

    private static boolean lightTypeRequiresDirection(Light.Type type) {
        return type == Light.Type.SPOTLIGHT || type == Light.Type.FOCUSED_SPOTLIGHT || type == Light.Type.DIRECTIONAL;
    }

    private class LightInstanceChangeListener
    implements Light.LightChangedListener {
        private LightInstanceChangeListener() {
        }

        @Override
        public void onChange() {
            LightInstance.this.dirty = true;
        }
    }
}

