/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.NativeSurface;
import com.google.android.filament.SwapChain;
import com.google.ar.sceneform.rendering.FilamentEngineWrapper;
import com.google.ar.sceneform.utilities.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class HeadlessEngineWrapper
extends FilamentEngineWrapper {
    public static final String TAG = HeadlessEngineWrapper.class.getName();
    long nativeHandle;
    private static final Constructor<SwapChain> swapChainInit;
    private static final Constructor<Engine> engineInit;
    private static final Method getNativeEngineMethod;
    private static final Method getNativeSwapChainMethod;

    public HeadlessEngineWrapper() throws ReflectiveOperationException {
        super(engineInit.newInstance(HeadlessEngineWrapper.nCreateSwiftShaderEngine()));
    }

    @Override
    public void destroy() {
        try {
            Long nativeEngineHandle = (Long)getNativeEngineMethod.invoke((Object)this.engine, new Object[0]);
            HeadlessEngineWrapper.nDestroySwiftShaderEngine((Long)Preconditions.checkNotNull((Object)nativeEngineHandle));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SwapChain createSwapChain(@NonNull Object surface) {
        try {
            Long nativeEngineHandle = (Long)getNativeEngineMethod.invoke((Object)this.engine, new Object[0]);
            Object fakeSurface = null;
            return swapChainInit.newInstance(HeadlessEngineWrapper.nCreateSwiftShaderSwapChain((Long)Preconditions.checkNotNull((Object)nativeEngineHandle), 0L), fakeSurface);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SwapChain createSwapChain(@NonNull Object surface, long flags) {
        try {
            Long nativeEngineHandle = (Long)getNativeEngineMethod.invoke((Object)this.engine, new Object[0]);
            Object fakeSurface = null;
            return swapChainInit.newInstance(HeadlessEngineWrapper.nCreateSwiftShaderSwapChain((Long)Preconditions.checkNotNull((Object)nativeEngineHandle), flags), fakeSurface);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SwapChain createSwapChainFromNativeSurface(@NonNull NativeSurface surface, long flags) {
        try {
            Long nativeEngineHandle = (Long)getNativeEngineMethod.invoke((Object)this.engine, new Object[0]);
            Object fakeSurface = null;
            return swapChainInit.newInstance(HeadlessEngineWrapper.nCreateSwiftShaderSwapChain((Long)Preconditions.checkNotNull((Object)nativeEngineHandle), flags), fakeSurface);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroySwapChain(@NonNull SwapChain swapChain) {
        try {
            Long nativeEngineHandle = (Long)getNativeEngineMethod.invoke((Object)this.engine, new Object[0]);
            Long swapChainHandle = (Long)getNativeSwapChainMethod.invoke((Object)swapChain, new Object[0]);
            HeadlessEngineWrapper.nDestroySwiftShaderSwapChain((Long)Preconditions.checkNotNull((Object)nativeEngineHandle), (Long)Preconditions.checkNotNull((Object)swapChainHandle));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static native long nCreateSwiftShaderEngine();

    private static native void nDestroySwiftShaderEngine(long var0);

    private static native long nCreateSwiftShaderSwapChain(long var0, long var2);

    private static native void nDestroySwiftShaderSwapChain(long var0, long var2);

    static {
        try {
            getNativeSwapChainMethod = SwapChain.class.getDeclaredMethod("getNativeObject", new Class[0]);
            swapChainInit = SwapChain.class.getDeclaredConstructor(Long.TYPE, Object.class);
            getNativeEngineMethod = Engine.class.getDeclaredMethod("getNativeObject", new Class[0]);
            engineInit = Engine.class.getDeclaredConstructor(Long.TYPE);
            getNativeSwapChainMethod.setAccessible(true);
            swapChainInit.setAccessible(true);
            getNativeEngineMethod.setAccessible(true);
            engineInit.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't get native getters", e);
        }
    }
}

