/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.view.View;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.ViewRenderableHelpers;
import com.google.ar.sceneform.rendering.ViewSizer;
import com.google.ar.sceneform.utilities.Preconditions;

public class FixedHeightViewSizer
implements ViewSizer {
    private final float heightMeters;
    private static final float DEFAULT_SIZE_Z = 0.0f;

    public FixedHeightViewSizer(float heightMeters) {
        if (heightMeters <= 0.0f) {
            throw new IllegalArgumentException("heightMeters must be greater than zero.");
        }
        this.heightMeters = heightMeters;
    }

    public float getHeight() {
        return this.heightMeters;
    }

    @Override
    public Vector3 getSize(View view) {
        Preconditions.checkNotNull((Object)view, (Object)"Parameter \"view\" was null.");
        float aspectRatio = ViewRenderableHelpers.getAspectRatio(view);
        if (aspectRatio == 0.0f) {
            return Vector3.zero();
        }
        return new Vector3(this.heightMeters * aspectRatio, this.heightMeters, 0.0f);
    }
}

