/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.google.android.filament.Stream;
import com.google.android.filament.Texture;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.Preconditions;

public class ExternalTexture {
    private static final String TAG = ExternalTexture.class.getSimpleName();
    @Nullable
    private final SurfaceTexture surfaceTexture;
    @Nullable
    private final Surface surface;
    @Nullable
    private Texture filamentTexture;
    @Nullable
    private Stream filamentStream;

    public ExternalTexture() {
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.detachFromGLContext();
        this.surfaceTexture = surfaceTexture;
        this.surface = new Surface(surfaceTexture);
        Stream stream = new Stream.Builder().stream((Object)surfaceTexture).build(EngineInstance.getEngine().getFilamentEngine());
        this.initialize(stream);
    }

    ExternalTexture(int textureId, int width, int height) {
        this.surfaceTexture = null;
        this.surface = null;
        Stream stream = new Stream.Builder().stream((long)textureId).width(width).height(height).build(EngineInstance.getEngine().getFilamentEngine());
        this.initialize(stream);
    }

    public SurfaceTexture getSurfaceTexture() {
        return (SurfaceTexture)Preconditions.checkNotNull((Object)this.surfaceTexture);
    }

    public Surface getSurface() {
        return (Surface)Preconditions.checkNotNull((Object)this.surface);
    }

    Texture getFilamentTexture() {
        return (Texture)Preconditions.checkNotNull((Object)this.filamentTexture);
    }

    Stream getFilamentStream() {
        return (Stream)Preconditions.checkNotNull((Object)this.filamentStream);
    }

    private void initialize(Stream filamentStream) {
        if (this.filamentTexture != null) {
            throw new AssertionError((Object)"Stream was initialized twice");
        }
        IEngine engine = EngineInstance.getEngine();
        this.filamentStream = filamentStream;
        Texture.Sampler textureSampler = Texture.Sampler.SAMPLER_EXTERNAL;
        Texture.InternalFormat textureInternalFormat = Texture.InternalFormat.RGB8;
        this.filamentTexture = new Texture.Builder().sampler(textureSampler).format(textureInternalFormat).build(engine.getFilamentEngine());
        this.filamentTexture.setExternalStream(engine.getFilamentEngine(), filamentStream);
        ResourceManager.getInstance().getExternalTextureCleanupRegistry().register(this, new CleanupCallback(this.filamentTexture, filamentStream));
    }

    private static final class CleanupCallback
    implements Runnable {
        @Nullable
        private final Texture filamentTexture;
        @Nullable
        private final Stream filamentStream;

        CleanupCallback(Texture filamentTexture, Stream filamentStream) {
            this.filamentTexture = filamentTexture;
            this.filamentStream = filamentStream;
        }

        @Override
        public void run() {
            AndroidPreconditions.checkUiThread();
            IEngine engine = EngineInstance.getEngine();
            if (engine == null || !engine.isValid()) {
                return;
            }
            if (this.filamentTexture != null) {
                engine.destroyTexture(this.filamentTexture);
            }
            if (this.filamentStream != null) {
                engine.destroyStream(this.filamentStream);
            }
        }
    }
}

