/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.view.View;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.ViewRenderableHelpers;
import com.google.ar.sceneform.rendering.ViewSizer;
import com.google.ar.sceneform.utilities.Preconditions;

public class DpToMetersViewSizer
implements ViewSizer {
    private final int dpPerMeters;
    private static final float DEFAULT_SIZE_Z = 0.0f;

    public DpToMetersViewSizer(int dpPerMeters) {
        if (dpPerMeters <= 0) {
            throw new IllegalArgumentException("dpPerMeters must be greater than zero.");
        }
        this.dpPerMeters = dpPerMeters;
    }

    public int getDpPerMeters() {
        return this.dpPerMeters;
    }

    @Override
    public Vector3 getSize(View view) {
        Preconditions.checkNotNull((Object)view, (Object)"Parameter \"view\" was null.");
        float widthDp = ViewRenderableHelpers.convertPxToDp(view.getWidth());
        float heightDp = ViewRenderableHelpers.convertPxToDp(view.getHeight());
        return new Vector3(widthDp / (float)this.dpPerMeters, heightDp / (float)this.dpPerMeters, 0.0f);
    }
}

