/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.filament.EntityManager;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.Scene;
import com.google.android.filament.VertexBuffer;
import com.google.ar.core.Camera;
import com.google.ar.core.CameraIntrinsics;
import com.google.ar.core.Frame;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.R;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.CompletableFuture;

public class CameraStream {
    public static final String MATERIAL_CAMERA_TEXTURE = "cameraTexture";
    private static final String TAG = CameraStream.class.getSimpleName();
    private static final short[] CAMERA_INDICES = new short[]{0, 1, 2};
    private static final int VERTEX_COUNT = 3;
    private static final int POSITION_BUFFER_INDEX = 0;
    private static final int UV_BUFFER_INDEX = 1;
    private static final int FLOAT_SIZE_IN_BYTES = 4;
    private static final float[] CAMERA_VERTICES = new float[]{-1.0f, 1.0f, 1.0f, -1.0f, -3.0f, 1.0f, 3.0f, 1.0f, 1.0f};
    private static final float[] CAMERA_UVS = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f};
    private static final int UNINITIALIZED_FILAMENT_RENDERABLE = -1;
    private final Scene scene;
    private final int cameraTextureId;
    private int cameraStreamRenderable = -1;
    private final IndexBuffer cameraIndexBuffer;
    private final VertexBuffer cameraVertexBuffer;
    private final FloatBuffer cameraUvCoords;
    private final FloatBuffer transformedCameraUvCoords;
    @Nullable
    private ExternalTexture cameraTexture;
    @Nullable
    private Material defaultCameraMaterial = null;
    @Nullable
    private Material cameraMaterial = null;
    private int renderablePriority = 7;
    private boolean isTextureInitialized = false;

    public CameraStream(int cameraTextureId, Renderer renderer) {
        this.scene = renderer.getFilamentScene();
        this.cameraTextureId = cameraTextureId;
        IEngine engine = EngineInstance.getEngine();
        ShortBuffer indexBufferData = ShortBuffer.allocate(CAMERA_INDICES.length);
        indexBufferData.put(CAMERA_INDICES);
        int indexCount = indexBufferData.capacity();
        this.cameraIndexBuffer = new IndexBuffer.Builder().indexCount(indexCount).bufferType(IndexBuffer.Builder.IndexType.USHORT).build(engine.getFilamentEngine());
        indexBufferData.rewind();
        ((IndexBuffer)Preconditions.checkNotNull((Object)this.cameraIndexBuffer)).setBuffer(engine.getFilamentEngine(), (Buffer)indexBufferData);
        this.cameraUvCoords = CameraStream.createCameraUVBuffer();
        this.transformedCameraUvCoords = CameraStream.createCameraUVBuffer();
        FloatBuffer vertexBufferData = FloatBuffer.allocate(CAMERA_VERTICES.length);
        vertexBufferData.put(CAMERA_VERTICES);
        this.cameraVertexBuffer = new VertexBuffer.Builder().vertexCount(3).bufferCount(2).attribute(VertexBuffer.VertexAttribute.POSITION, 0, VertexBuffer.AttributeType.FLOAT3, 0, CAMERA_VERTICES.length / 3 * 4).attribute(VertexBuffer.VertexAttribute.UV0, 1, VertexBuffer.AttributeType.FLOAT2, 0, CAMERA_UVS.length / 3 * 4).build(engine.getFilamentEngine());
        vertexBufferData.rewind();
        ((VertexBuffer)Preconditions.checkNotNull((Object)this.cameraVertexBuffer)).setBufferAt(engine.getFilamentEngine(), 0, (Buffer)vertexBufferData);
        this.adjustCameraUvsForOpenGL();
        this.cameraVertexBuffer.setBufferAt(engine.getFilamentEngine(), 1, (Buffer)this.transformedCameraUvCoords);
        CompletableFuture<Material> materialFuture = Material.builder().setSource(renderer.getContext(), R.raw.sceneform_camera_material).build();
        ((CompletableFuture)materialFuture.thenAccept(material -> {
            this.defaultCameraMaterial = material;
            if (this.cameraMaterial == null) {
                this.setCameraMaterial(this.defaultCameraMaterial);
            }
        })).exceptionally(throwable -> {
            Log.e((String)TAG, (String)"Unable to load camera stream materials.", (Throwable)throwable);
            return null;
        });
    }

    public boolean isTextureInitialized() {
        return this.isTextureInitialized;
    }

    public void initializeTexture(Frame frame) {
        if (this.isTextureInitialized()) {
            return;
        }
        Camera arCamera = frame.getCamera();
        CameraIntrinsics intrinsics = arCamera.getTextureIntrinsics();
        int[] dimensions = intrinsics.getImageDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        this.cameraTexture = new ExternalTexture(this.cameraTextureId, width, height);
        this.isTextureInitialized = true;
        if (this.cameraMaterial != null) {
            this.setCameraMaterial(this.cameraMaterial);
        }
    }

    public void recalculateCameraUvs(Frame frame) {
        IEngine engine = EngineInstance.getEngine();
        FloatBuffer cameraUvCoords = this.cameraUvCoords;
        FloatBuffer transformedCameraUvCoords = this.transformedCameraUvCoords;
        VertexBuffer cameraVertexBuffer = this.cameraVertexBuffer;
        frame.transformDisplayUvCoords(cameraUvCoords, transformedCameraUvCoords);
        this.adjustCameraUvsForOpenGL();
        cameraVertexBuffer.setBufferAt(engine.getFilamentEngine(), 1, (Buffer)transformedCameraUvCoords);
    }

    public void setCameraMaterial(Material material) {
        this.cameraMaterial = material;
        if (!this.isTextureInitialized()) {
            return;
        }
        material.setExternalTexture(MATERIAL_CAMERA_TEXTURE, (ExternalTexture)Preconditions.checkNotNull((Object)this.cameraTexture));
        if (this.cameraStreamRenderable == -1) {
            this.initializeFilamentRenderable();
        } else {
            RenderableManager renderableManager = EngineInstance.getEngine().getRenderableManager();
            int renderableInstance = renderableManager.getInstance(this.cameraStreamRenderable);
            renderableManager.setMaterialInstanceAt(renderableInstance, 0, material.getFilamentMaterialInstance());
        }
    }

    public void setCameraMaterialToDefault() {
        if (this.defaultCameraMaterial != null) {
            this.setCameraMaterial(this.defaultCameraMaterial);
        } else {
            this.cameraMaterial = null;
        }
    }

    public void setRenderPriority(int priority) {
        this.renderablePriority = priority;
        if (this.cameraStreamRenderable != -1) {
            RenderableManager renderableManager = EngineInstance.getEngine().getRenderableManager();
            int renderableInstance = renderableManager.getInstance(this.cameraStreamRenderable);
            renderableManager.setPriority(renderableInstance, this.renderablePriority);
        }
    }

    public int getRenderPriority() {
        return this.renderablePriority;
    }

    private void adjustCameraUvsForOpenGL() {
        for (int i = 1; i < 6; i += 2) {
            this.transformedCameraUvCoords.put(i, 1.0f - this.transformedCameraUvCoords.get(i));
        }
    }

    private static FloatBuffer createCameraUVBuffer() {
        FloatBuffer buffer = ByteBuffer.allocateDirect(CAMERA_UVS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buffer.put(CAMERA_UVS);
        buffer.rewind();
        return buffer;
    }

    private void initializeFilamentRenderable() {
        this.cameraStreamRenderable = EntityManager.get().create();
        RenderableManager.Builder builder = new RenderableManager.Builder(1);
        builder.castShadows(false).receiveShadows(false).culling(false).priority(this.renderablePriority).geometry(0, RenderableManager.PrimitiveType.TRIANGLES, this.cameraVertexBuffer, this.cameraIndexBuffer).material(0, ((Material)Preconditions.checkNotNull((Object)this.cameraMaterial)).getFilamentMaterialInstance()).build(EngineInstance.getEngine().getFilamentEngine(), this.cameraStreamRenderable);
        this.scene.addEntity(this.cameraStreamRenderable);
        ResourceManager.getInstance().getCameraStreamCleanupRegistry().register(this, new CleanupCallback(this.scene, this.cameraStreamRenderable, this.cameraIndexBuffer, this.cameraVertexBuffer));
    }

    private static final class CleanupCallback
    implements Runnable {
        private final Scene scene;
        private final int cameraStreamRenderable;
        private final IndexBuffer cameraIndexBuffer;
        private final VertexBuffer cameraVertexBuffer;

        CleanupCallback(Scene scene, int cameraStreamRenderable, IndexBuffer cameraIndexBuffer, VertexBuffer cameraVertexBuffer) {
            this.scene = scene;
            this.cameraStreamRenderable = cameraStreamRenderable;
            this.cameraIndexBuffer = cameraIndexBuffer;
            this.cameraVertexBuffer = cameraVertexBuffer;
        }

        @Override
        public void run() {
            AndroidPreconditions.checkUiThread();
            IEngine engine = EngineInstance.getEngine();
            if (engine == null && !engine.isValid()) {
                return;
            }
            if (this.cameraStreamRenderable != -1) {
                this.scene.remove(this.cameraStreamRenderable);
            }
            engine.destroyIndexBuffer(this.cameraIndexBuffer);
            engine.destroyVertexBuffer(this.cameraVertexBuffer);
        }
    }
}

