/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassPathBuilder {
    private static final Pattern CLASSES_REGEX = Pattern.compile(".*/classes/?");
    private static final Pattern APPENGINE_API_REGEX = Pattern.compile(".*/appengine-api(-?[0-9\\.]*-sdk-[0-9\\.]*)?\\.jar");
    private static final Comparator<UrlPriority> URL_PRIORITY_COMP = Comparator.comparingDouble(u -> u.priority).reversed();
    private final Set<UrlPriority> urls = new LinkedHashSet<UrlPriority>();
    private final List<AppEngineWebXml.PrioritySpecifierEntry> priorityEntries;
    private final boolean[] usedPrioritySpecifiers;
    private URL[] sortedUrls = null;

    public ClassPathBuilder(AppEngineWebXml.ClassLoaderConfig classLoaderConfig) {
        this.priorityEntries = classLoaderConfig == null ? ImmutableList.of() : classLoaderConfig.getEntries();
        this.usedPrioritySpecifiers = new boolean[this.priorityEntries.size()];
    }

    private void addUrl(URL url, double defaultPriority) {
        if (this.sortedUrls != null) {
            throw new IllegalStateException("add* calls are not allowed after getUrls() has been called");
        }
        Double priority = this.findPriority(url);
        this.urls.add(new UrlPriority(url, null == priority ? defaultPriority : priority));
    }

    private Double findPriority(URL url) {
        String fileName = new File(url.getPath()).getName();
        for (int i = 0; i < this.usedPrioritySpecifiers.length; ++i) {
            if (!this.priorityEntries.get(i).getFilename().equals(fileName)) continue;
            this.usedPrioritySpecifiers[i] = true;
            return this.priorityEntries.get(i).getPriorityValue();
        }
        return null;
    }

    public void addClassesUrl(URL url) {
        this.addUrl(url, 100.0);
    }

    public void addAppengineJar(URL url) {
        this.addUrl(url, 0.5);
    }

    public void addAppJar(URL url) {
        this.addUrl(url, 0.0);
    }

    public URL[] getUrls() {
        if (this.sortedUrls == null) {
            UrlPriority[] classPath = this.urls.toArray(new UrlPriority[this.urls.size()]);
            Arrays.sort(classPath, URL_PRIORITY_COMP);
            this.sortedUrls = new URL[classPath.length];
            for (int i = 0; i < classPath.length; ++i) {
                this.sortedUrls[i] = classPath[i].url;
            }
        }
        return this.sortedUrls;
    }

    public String getLogMessage() {
        if (this.sortedUrls == null) {
            throw new IllegalStateException("Cannot call getLogMessage() without first calling getUrls()");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.usedPrioritySpecifiers.length; ++i) {
            if (this.usedPrioritySpecifiers[i]) continue;
            builder.append("priority-specifier: filename: ");
            builder.append(this.priorityEntries.get(i).getFilename());
            if (this.priorityEntries.get(i).getPriority() == null) continue;
            builder.append(" priority: ");
            builder.append(this.priorityEntries.get(i).getPriorityValue());
        }
        String errors = builder.toString();
        if (!errors.isEmpty()) {
            return "appengine-web.xml contains unused class-loader-config priority-specifier values.\nunused values: " + errors + "\nresulting classpath: " + Arrays.toString(this.sortedUrls) + "\nTo remove this warning, remove the unused priority-specifier values from appengine-web.xml or add a file matching the unused priority-specifier values.";
        }
        return "";
    }

    public void addUrls(Collection<URL> urls) {
        for (URL url : urls) {
            if (CLASSES_REGEX.matcher(url.getPath()).matches()) {
                this.addClassesUrl(url);
                continue;
            }
            if (APPENGINE_API_REGEX.matcher(url.getPath()).matches()) {
                this.addAppengineJar(url);
                continue;
            }
            this.addAppJar(url);
        }
    }

    private static class UrlPriority {
        final URL url;
        final double priority;

        UrlPriority(URL url, double priority) {
            this.url = url;
            this.priority = priority;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UrlPriority)) {
                return false;
            }
            UrlPriority other = (UrlPriority)obj;
            return Objects.equals(this.url, other.url);
        }
    }
}

