/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.compilation;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

class DatastoreCallbacksConfigWriter {
    static final String INCORRECT_FORMAT_MESSAGE = "Existing config file has incorrect format version. Please do a clean rebuild of your application.";
    static final String FORMAT_VERSION_PROPERTY = "DatastoreCallbacksFormatVersion";
    private static final String FORMAT_VERSION = Integer.toString(1);
    final Map<String, Multimap<String, String>> callbacks = Maps.newHashMap();
    final SetMultimap<String, String> methodsWithCallbacks = LinkedHashMultimap.create();
    final Properties props = new Properties();
    final Set<String> prunedClasses = Sets.newHashSet();

    DatastoreCallbacksConfigWriter(@Nullable InputStream inputStream) throws IOException {
        if (inputStream != null) {
            this.props.loadFromXML(inputStream);
            Preconditions.checkState((boolean)FORMAT_VERSION.equals(this.props.remove(FORMAT_VERSION_PROPERTY)), (Object)INCORRECT_FORMAT_MESSAGE);
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        this.pruneExistingConfig();
        this.props.setProperty(FORMAT_VERSION_PROPERTY, FORMAT_VERSION);
        for (String kind : this.callbacks.keySet()) {
            Multimap<String, String> kindMap = this.callbacks.get(kind);
            for (String callbackType : kindMap.keySet()) {
                String propKey = String.format("%s.%s", kind, callbackType);
                Collection newMethods = kindMap.get((Object)callbackType);
                StringBuilder combinedMethods = new StringBuilder();
                String oldMethods = this.props.getProperty(propKey);
                if (oldMethods != null) {
                    combinedMethods.append(oldMethods).append(",");
                }
                this.props.setProperty(propKey, Joiner.on((String)",").appendTo(combinedMethods, (Iterable)newMethods).toString());
            }
        }
        this.props.storeToXML(outputStream, "Datastore Callbacks. DO NOT EDIT BY HAND!");
    }

    private void pruneExistingConfig() {
        for (String propName : this.props.stringPropertyNames()) {
            String propVal = this.props.getProperty(propName);
            ArrayList methodsToPreserve = Lists.newArrayList();
            for (String method : Splitter.on((char)',').split((CharSequence)propVal)) {
                String classStr = (String)Iterables.get((Iterable)Splitter.on((char)':').split((CharSequence)method), (int)0);
                if (this.methodsWithCallbacks.containsKey((Object)classStr) || !this.classExists(classStr)) continue;
                methodsToPreserve.add(method);
            }
            if (methodsToPreserve.isEmpty()) {
                this.props.remove(propName);
                continue;
            }
            this.props.setProperty(propName, Joiner.on((String)",").join((Iterable)methodsToPreserve));
        }
    }

    private boolean classExists(String classStr) {
        try {
            Class.forName(classStr);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.prunedClasses.add(classStr);
            return false;
        }
    }

    public void addCallback(Set<String> kinds, String callbackType, String cls, String method) {
        String clsMethod = String.format("%s:%s", cls, method);
        if (kinds.isEmpty()) {
            kinds = ImmutableSet.of((Object)"");
        }
        for (String kind : kinds) {
            Multimap kindMap = this.callbacks.computeIfAbsent(kind, k -> LinkedHashMultimap.create());
            kindMap.put((Object)callbackType, (Object)clsMethod);
        }
        this.methodsWithCallbacks.put((Object)cls, (Object)method);
    }

    public String toString() {
        return String.format("Datastore Callbacks: %s\nPruned Classes: %s", this.callbacks, this.prunedClasses);
    }

    public boolean hasCallback(String cls, String method) {
        return this.methodsWithCallbacks.containsEntry((Object)cls, (Object)method);
    }
}

