/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.checkers.FacetQueryChecker;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.QueryOptionsChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.RewriteCardinalityException;

public final class QueryChecker {
    public static String checkQuery(String query) {
        QueryChecker.checkQueryFast(query);
        return QueryChecker.checkQueryParses(query);
    }

    private static String checkQueryParses(String query) {
        try {
            new QueryTreeBuilder().parse(query);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new SearchQueryException("Unable to parse query: " + query);
        }
        return query;
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        QueryChecker.checkValidFast(params);
        QueryChecker.checkQueryParses(params.getQuery());
        return params;
    }

    public static SearchServicePb.SearchParams checkValidFast(SearchServicePb.SearchParams params) {
        IndexChecker.checkName(params.getIndexSpec().getName());
        QueryChecker.checkQueryFast(params.getQuery());
        QueryOptionsChecker.checkValid(params);
        FacetQueryChecker.checkValid(params);
        return params;
    }

    private static String checkQueryFast(String query) {
        int length;
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        try {
            length = query.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding UTF-8. Shouldn't  happen, ever!");
        }
        Preconditions.checkArgument((length <= 2000 ? 1 : 0) != 0, (String)"query string must not be longer than %s bytes, was %s", (int)2000, (int)length);
        return query;
    }
}

