/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;
import com.google.common.base.Preconditions;

@AppEngineInternal
public final class FacetChecker {
    public static String checkFacetName(String name) {
        return FacetChecker.checkFacetName(name, "facet name");
    }

    public static String checkFacetName(String name, String callerContext) {
        Preconditions.checkNotNull((Object)name, (Object)"Name is null");
        return FieldChecker.checkFieldName(name, callerContext);
    }

    public static String checkAtom(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value is null");
        FieldChecker.checkAtom(value);
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"Facet value is empty");
        return value;
    }

    public static Double checkNumber(Double value) {
        return FieldChecker.checkNumber(value);
    }

    public static DocumentPb.FacetValue checkFacetValue(DocumentPb.FacetValue value) {
        if (value != null) {
            switch (value.getType()) {
                case ATOM: {
                    FacetChecker.checkAtom(value.getStringValue());
                    break;
                }
                case NUMBER: {
                    FacetChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported facet type: " + value.getType());
                }
            }
        }
        return value;
    }

    public static DocumentPb.Facet checkValid(DocumentPb.Facet facet) {
        FacetChecker.checkFacetName(facet.getName());
        FacetChecker.checkFacetValue(facet.getValue());
        return facet;
    }

    private FacetChecker() {
    }
}

