/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Facet;
import com.google.appengine.api.search.FacetRange;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FacetQueryChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FacetRefinement {
    private static final int MAX_TOKEN_LENGTH_IN_EXCEPTIONS = 100;
    private final String name;
    private final String value;
    private final FacetRange range;

    public static FacetRefinement withValue(String name, String value) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Name should not be empty");
        FacetQueryChecker.checkFacetValue(value);
        return new FacetRefinement(name, value, null);
    }

    public static FacetRefinement withRange(String name, FacetRange range) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Name should not be empty");
        return new FacetRefinement(name, null, range);
    }

    private FacetRefinement(String name, String value, FacetRange range) {
        this.name = name;
        this.value = value;
        this.range = range;
        this.checkValid();
    }

    static FacetRefinement withProtoMessage(SearchServicePb.FacetRefinement refinementPb) {
        if (refinementPb.hasValue()) {
            return new FacetRefinement(refinementPb.getName(), refinementPb.getValue(), null);
        }
        if (refinementPb.hasRange()) {
            FacetRange range;
            if (refinementPb.getRange().hasStart()) {
                range = refinementPb.getRange().hasEnd() ? FacetRange.withStartEnd(Facet.stringToNumber(refinementPb.getRange().getStart()), Facet.stringToNumber(refinementPb.getRange().getEnd())) : FacetRange.withStart(Facet.stringToNumber(refinementPb.getRange().getStart()));
            } else if (refinementPb.getRange().hasEnd()) {
                range = FacetRange.withEnd(Facet.stringToNumber(refinementPb.getRange().getEnd()));
            } else {
                throw new IllegalStateException(String.format("Refinement %s has invalid range.", refinementPb.getName()));
            }
            return new FacetRefinement(refinementPb.getName(), null, range);
        }
        throw new IllegalStateException(String.format("Refinement %s should have value or range.", refinementPb.getName()));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public FacetRange getRange() {
        return this.range;
    }

    private void checkValid() {
        Preconditions.checkArgument((this.getName() != null && !this.getName().isEmpty() ? 1 : 0) != 0, (Object)"name should not be null or empty.");
        Preconditions.checkArgument((this.getValue() != null || this.getRange() != null ? 1 : 0) != 0, (String)"Neither value nor range is set for FacetRefinement %s", (Object)this.getName());
        Preconditions.checkArgument((this.getValue() == null || this.getRange() == null ? 1 : 0) != 0, (String)"Both value and range are set for FacetRefinement %s", (Object)this.getName());
    }

    SearchServicePb.FacetRefinement toProtocolBuffer() {
        SearchServicePb.FacetRefinement.Builder builder = SearchServicePb.FacetRefinement.newBuilder();
        builder.setName(this.getName());
        if (this.getValue() != null) {
            builder.setValue(this.getValue());
        }
        if (this.getRange() != null) {
            SearchServicePb.FacetRefinement.Range.Builder rangePb = builder.getRangeBuilder();
            if (this.getRange().getStart() != null) {
                rangePb.setStart(this.getRange().getStart());
            }
            if (this.getRange().getEnd() != null) {
                rangePb.setEnd(this.getRange().getEnd());
            }
        }
        return builder.build();
    }

    public String toTokenString() {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            this.toProtocolBuffer().writeTo((OutputStream)data);
            return BaseEncoding.base64Url().omitPadding().encode(data.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    private static String truncateAtMaxLength(String source, int maxLength) {
        if (source.length() <= maxLength) {
            return source;
        }
        return source.substring(0, maxLength) + " ...";
    }

    public static FacetRefinement fromTokenString(String token) {
        try {
            return FacetRefinement.withProtoMessage(SearchServicePb.FacetRefinement.parseFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)token)));
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot process refinement token: " + FacetRefinement.truncateAtMaxLength(token, 100), e);
        }
    }

    public String toString() {
        return new Util.ToStringHelper("FacetRefinement").addField("name", this.name).addField("value", this.value).addField("range", this.range).finish();
    }
}

