/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CompositeIndexUtils;
import com.google.appengine.api.datastore.IndexComponent;
import com.google.appengine.api.datastore.UnorderedIndexComponent;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompositeIndexManager {
    private static final Comparator<OnestoreEntity.Index.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Index.Property>(){

        @Override
        public int compare(OnestoreEntity.Index.Property o1, OnestoreEntity.Index.Property o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final SearchPropertyTransform TO_MODELESS_PROPERTY = new SearchPropertyTransform(null);
    private static final SearchPropertyTransform TO_GEOSPATIAL_PROPERTY = new SearchPropertyTransform(OnestoreEntity.Index.Property.Mode.GEOSPATIAL);

    protected String generateXmlForIndex(OnestoreEntity.Index index, IndexSource source) {
        return CompositeIndexUtils.generateXmlForIndex(index, source);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        List<OnestoreEntity.Index.Property> indexProperties;
        DatastoreV3Pb.Query query = indexOnlyQuery.getQuery();
        boolean hasKind = query.hasKind();
        boolean isAncestor = query.hasAncestor();
        List filters = query.filters();
        List orders = query.orders();
        if (filters.isEmpty() && orders.isEmpty()) {
            return null;
        }
        List<String> eqProps = indexOnlyQuery.getPrefix();
        List<OnestoreEntity.Index.Property> list = indexProperties = indexOnlyQuery.isGeo() ? this.getNeededSearchProps(eqProps, indexOnlyQuery.getGeoProperties()) : this.getRecommendedIndexProps(indexOnlyQuery);
        if (hasKind && !eqProps.isEmpty() && eqProps.size() == filters.size() && !indexOnlyQuery.hasKeyProperty() && orders.isEmpty()) {
            return null;
        }
        if (!(!hasKind || isAncestor || indexProperties.size() > 1 || indexOnlyQuery.isGeo() || indexOnlyQuery.hasKeyProperty() && indexProperties.get(0).getDirectionEnum() != OnestoreEntity.Index.Property.Direction.ASCENDING)) {
            return null;
        }
        OnestoreEntity.Index index = new OnestoreEntity.Index();
        index.setEntityType(query.getKind());
        index.setAncestor(isAncestor);
        index.mutablePropertys().addAll(indexProperties);
        return index;
    }

    private List<OnestoreEntity.Index.Property> getRecommendedIndexProps(IndexComponentsOnlyQuery query) {
        ArrayList<OnestoreEntity.Index.Property> indexProps = new ArrayList<OnestoreEntity.Index.Property>();
        indexProps.addAll(new UnorderedIndexComponent(Sets.newHashSet(query.getPrefix())).preferredIndexProperties());
        for (IndexComponent component : query.getPostfix()) {
            indexProps.addAll(component.preferredIndexProperties());
        }
        return indexProps;
    }

    private List<OnestoreEntity.Index.Property> getNeededSearchProps(List<String> eqProps, List<String> searchProps) {
        ArrayList<OnestoreEntity.Index.Property> result = new ArrayList<OnestoreEntity.Index.Property>();
        result.addAll((Collection<OnestoreEntity.Index.Property>)FluentIterable.from(eqProps).transform((Function)TO_MODELESS_PROPERTY).toSortedList(PROPERTY_NAME_COMPARATOR));
        result.addAll((Collection<OnestoreEntity.Index.Property>)FluentIterable.from(searchProps).transform((Function)TO_GEOSPATIAL_PROPERTY).toSortedList(PROPERTY_NAME_COMPARATOR));
        return result;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        OnestoreEntity.Index suggestedIndex = this.compositeIndexForQuery(indexOnlyQuery);
        if (suggestedIndex == null) {
            return null;
        }
        if (indexOnlyQuery.isGeo()) {
            return suggestedIndex;
        }
        class EqPropsAndAncestorConstraint {
            final Set<String> equalityProperties;
            final boolean ancestorConstraint;

            EqPropsAndAncestorConstraint(Set<String> equalityProperties, boolean ancestorConstraint) {
                this.equalityProperties = equalityProperties;
                this.ancestorConstraint = ancestorConstraint;
            }
        }
        HashMap remainingMap = new HashMap();
        block0: for (OnestoreEntity.Index index : indexes) {
            boolean remainingAncestor;
            HashSet remainingEqProps;
            Object component2;
            if (!indexOnlyQuery.getQuery().getKind().equals(index.getEntityType()) || !indexOnlyQuery.getQuery().hasAncestor() && index.isAncestor()) continue;
            int postfixSplit = index.propertySize();
            for (Object component2 : Lists.reverse(indexOnlyQuery.getPostfix())) {
                if (!component2.matches(index.propertys().subList(Math.max(postfixSplit - component2.size(), 0), postfixSplit))) continue block0;
                postfixSplit -= component2.size();
            }
            HashSet indexEqProps = Sets.newHashSetWithExpectedSize((int)postfixSplit);
            component2 = index.propertys().subList(0, postfixSplit).iterator();
            while (component2.hasNext()) {
                OnestoreEntity.Index.Property prop = (OnestoreEntity.Index.Property)component2.next();
                if (!indexOnlyQuery.getPrefix().contains(prop.getName())) continue block0;
                indexEqProps.add(prop.getName());
            }
            List indexPostfix = index.propertys().subList(postfixSplit, index.propertySize());
            EqPropsAndAncestorConstraint remaining = (EqPropsAndAncestorConstraint)remainingMap.get(indexPostfix);
            if (remaining == null) {
                remainingEqProps = Sets.newHashSet(indexOnlyQuery.getPrefix());
                remainingAncestor = indexOnlyQuery.getQuery().hasAncestor();
            } else {
                remainingEqProps = remaining.equalityProperties;
                remainingAncestor = remaining.ancestorConstraint;
            }
            boolean modified = remainingEqProps.removeAll(indexEqProps);
            if (remainingAncestor && index.isAncestor()) {
                modified = true;
                remainingAncestor = false;
            }
            if (remainingEqProps.isEmpty() && !remainingAncestor) {
                return null;
            }
            if (!modified) continue;
            remainingMap.put(indexPostfix, new EqPropsAndAncestorConstraint(remainingEqProps, remainingAncestor));
        }
        if (remainingMap.isEmpty()) {
            return suggestedIndex;
        }
        int minimumCost = Integer.MAX_VALUE;
        List minimumPostfix = null;
        EqPropsAndAncestorConstraint minimumRemaining = null;
        for (Map.Entry entry : remainingMap.entrySet()) {
            int cost = ((EqPropsAndAncestorConstraint)entry.getValue()).equalityProperties.size();
            if (((EqPropsAndAncestorConstraint)entry.getValue()).ancestorConstraint) {
                cost += 2;
            }
            if (cost >= minimumCost) continue;
            minimumCost = cost;
            minimumPostfix = (List)entry.getKey();
            minimumRemaining = (EqPropsAndAncestorConstraint)entry.getValue();
        }
        Objects.requireNonNull(minimumRemaining);
        Objects.requireNonNull(minimumPostfix);
        suggestedIndex.clearProperty();
        suggestedIndex.setAncestor(minimumRemaining.ancestorConstraint);
        for (String name : minimumRemaining.equalityProperties) {
            suggestedIndex.addProperty().setName(name).setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
        }
        Collections.sort(suggestedIndex.mutablePropertys(), PROPERTY_NAME_COMPARATOR);
        suggestedIndex.mutablePropertys().addAll(minimumPostfix);
        return suggestedIndex;
    }

    protected static class KeyTranslator
    extends com.google.appengine.api.datastore.KeyTranslator {
        protected KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends com.google.appengine.api.datastore.ValidatedQuery {
        public ValidatedQuery(DatastoreV3Pb.Query query) {
            super(query);
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends com.google.appengine.api.datastore.IndexComponentsOnlyQuery {
        public IndexComponentsOnlyQuery(DatastoreV3Pb.Query query) {
            super(query);
        }
    }

    static class SearchPropertyTransform
    implements Function<String, OnestoreEntity.Index.Property> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable OnestoreEntity.Index.Property.Mode mode;

        SearchPropertyTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable OnestoreEntity.Index.Property.Mode mode) {
            this.mode = mode;
        }

        public OnestoreEntity.Index.Property apply(String name) {
            OnestoreEntity.Index.Property p = new OnestoreEntity.Index.Property();
            p.setName(name);
            if (this.mode != null) {
                p.setMode(this.mode);
            }
            return p;
        }
    }

    protected static enum IndexSource {
        auto,
        manual;

    }
}

