/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class CursorModernizer {
    private CursorModernizer() {
    }

    private static void checkModernized(DatastoreV3Pb.CompiledCursor cursor) {
        Preconditions.checkArgument((!cursor.hasPosition() ? 1 : 0) != 0, (Object)"Modern cursors cannot specify a position.");
    }

    public static boolean isEmpty(DatastoreV3Pb.CompiledCursor cursor) {
        CursorModernizer.checkModernized(cursor);
        return !CursorModernizer.isEncoded(cursor) && !CursorModernizer.isPlannable(cursor);
    }

    public static boolean isEncoded(DatastoreV3Pb.CompiledCursor cursor) {
        CursorModernizer.checkModernized(cursor);
        return cursor.hasAbsolutePosition();
    }

    public static boolean isPlannable(DatastoreV3Pb.CompiledCursor cursor) {
        CursorModernizer.checkModernized(cursor);
        return cursor.hasPostfixPosition();
    }

    @Nullable
    public static DatastoreV3Pb.Query.Order.Direction firstSortDirection(DatastoreV3Pb.Query originalQuery) {
        return originalQuery.orderSize() == 0 ? null : originalQuery.getOrder(0).getDirectionEnum();
    }

    public static void modernizeQueryCursors(DatastoreV3Pb.Query query) throws InvalidConversionException {
        boolean hasStartCursor = query.hasCompiledCursor();
        boolean hasEndCursor = query.hasEndCompiledCursor();
        if (!hasStartCursor && !hasEndCursor) {
            return;
        }
        DatastoreV3Pb.Query.Order.Direction firstSortDirection = CursorModernizer.firstSortDirection(query);
        if (hasStartCursor) {
            CursorModernizer.modernizeCursor(query.getCompiledCursor(), firstSortDirection);
        }
        if (hasEndCursor) {
            CursorModernizer.modernizeCursor(query.getEndCompiledCursor(), firstSortDirection);
        }
    }

    public static void modernizeCursor(DatastoreV3Pb.CompiledCursor cursor, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) throws InvalidConversionException {
        if (cursor.hasPosition()) {
            InvalidConversionException.checkConversion(!cursor.hasPostfixPosition(), "A cursor cannot specify both position and postfix position.");
            InvalidConversionException.checkConversion(!cursor.hasAbsolutePosition(), "A cursor cannot specify both position and absolute position.");
            DatastoreV3Pb.CompiledCursor.Position pos = cursor.getPosition();
            if (pos.hasStartKey()) {
                OnestoreEntity.IndexPosition indexPos = cursor.getMutableAbsolutePosition();
                indexPos.setKeyAsBytes(pos.getStartKeyAsBytes());
                if (pos.hasStartInclusive()) {
                    indexPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    indexPos.setBeforeAscending(pos.isBeforeAscending());
                }
            } else if (pos.hasKey() || pos.indexValueSize() > 0) {
                OnestoreEntity.IndexPostfix postfixPos = cursor.getMutablePostfixPosition();
                for (DatastoreV3Pb.CompiledCursor.PositionIndexValue value : pos.indexValues()) {
                    OnestoreEntity.IndexPostfix_IndexValue indexValue = postfixPos.addIndexValue().setPropertyName(value.getProperty());
                    indexValue.getMutableValue().mergeFrom(value.getValue());
                }
                if (pos.hasKey()) {
                    postfixPos.getMutableKey().mergeFrom(pos.getKey());
                }
                if (pos.hasStartInclusive()) {
                    postfixPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    postfixPos.setBeforeAscending(pos.isBeforeAscending());
                }
            }
            cursor.clearPosition();
        }
        if (CursorModernizer.isEmpty(cursor)) {
            return;
        }
        if (cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition indexPosition = cursor.getAbsolutePosition();
            if (indexPosition.hasBeforeAscending()) {
                CursorModernizer.setBefore(indexPosition, firstSortDirection);
            } else {
                CursorModernizer.setBeforeAscending(indexPosition, firstSortDirection);
            }
        } else if (cursor.hasPostfixPosition()) {
            OnestoreEntity.IndexPostfix indexPostfix = cursor.getPostfixPosition();
            if (indexPostfix.hasBeforeAscending()) {
                CursorModernizer.setBefore(indexPostfix, firstSortDirection);
            } else {
                CursorModernizer.setBeforeAscending(indexPostfix, firstSortDirection);
            }
        }
    }

    @VisibleForTesting
    static void setBefore(OnestoreEntity.IndexPosition position, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CursorModernizer.computeBefore(position.isBeforeAscending(), firstSortDirection));
    }

    @VisibleForTesting
    static void setBefore(OnestoreEntity.IndexPostfix position, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CursorModernizer.computeBefore(position.isBeforeAscending(), firstSortDirection));
    }

    @VisibleForTesting
    static void setBeforeAscending(OnestoreEntity.IndexPosition position, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CursorModernizer.computeBeforeAscending(position.isBefore(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPostfix position, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CursorModernizer.computeBeforeAscending(position.isBefore(), firstSortDirection));
    }

    private static boolean computeBefore(boolean isBeforeAscending, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        return isBeforeAscending ^ firstSortDirection == DatastoreV3Pb.Query.Order.Direction.DESCENDING;
    }

    private static boolean computeBeforeAscending(boolean isBefore, @Nullable DatastoreV3Pb.Query.Order.Direction firstSortDirection) {
        return isBefore ^ firstSortDirection == DatastoreV3Pb.Query.Order.Direction.DESCENDING;
    }
}

