/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AbstractModule;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHelper;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.ManualInstanceHolder;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ManualModule
extends AbstractModule<ManualInstanceHolder> {
    private final AtomicInteger instanceCounter = new AtomicInteger();

    ManualModule(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, String address, DevAppServer devAppServer, AppEngineWebXml appEngineWebXml) {
        super(moduleConfigurationHandle, serverInfo, null, address, devAppServer, ManualModule.makeInstanceHolders(moduleConfigurationHandle, appEngineWebXml));
    }

    private static List<ManualInstanceHolder> makeInstanceHolders(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, AppEngineWebXml appEngineWebXml) {
        int instances;
        String instancesString = appEngineWebXml.getManualScaling().getInstances();
        int n = instances = instancesString == null ? 0 : Integer.parseInt(instancesString);
        if (instances < 0) {
            throw new AppEngineConfigException("Invalid instances " + instances + " in file " + moduleConfigurationHandle.getModule().getAppEngineWebXmlFile());
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int ix = -1; ix < instances; ++ix) {
            String moduleName = moduleConfigurationHandle.getModule().getModuleName();
            InstanceStateHolder stateHolder = new InstanceStateHolder(moduleName, ix);
            ContainerService containerService = ContainerUtils.loadContainer();
            InstanceHelper instanceHelper = new InstanceHelper(moduleName, ix, stateHolder, containerService);
            listBuilder.add((Object)new ManualInstanceHolder(moduleName, containerService, ix, stateHolder, instanceHelper));
        }
        return listBuilder.build();
    }

    @Override
    public LocalServerEnvironment doConfigure(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, File externalResourceDir, String address, Map<String, Object> containerConfigProperties, DevAppServer devAppServer) throws Exception {
        LocalServerEnvironment result = null;
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.setConfiguration(moduleConfigurationHandle, serverInfo, externalResourceDir, address, containerConfigProperties, devAppServer);
            LocalServerEnvironment thisEnvironment = instanceHolder.doConfigure();
            if (result != null) continue;
            result = thisEnvironment;
        }
        return result;
    }

    @Override
    public int getInstanceCount() {
        return this.getInstanceHolders().size() - 1;
    }

    private ManualInstanceHolder getFirstMaybeAvailableInstanceHolder() {
        int instance = this.instanceCounter.getAndIncrement() % this.getInstanceCount();
        return (ManualInstanceHolder)this.getInstanceHolder(instance);
    }

    @Override
    public ManualInstanceHolder getAndReserveAvailableInstanceHolder() {
        ManualInstanceHolder result = null;
        for (ManualInstanceHolder instanceHolder : new Iterable<ManualInstanceHolder>(){

            @Override
            public Iterator<ManualInstanceHolder> iterator() {
                return new FromFirstMaybeAvailableInstanceIterator();
            }
        }) {
            if (!instanceHolder.acquireServingPermit()) continue;
            result = instanceHolder;
            break;
        }
        return result;
    }

    @Override
    public void startServing() throws Exception {
        this.requireState("startServing", InstanceStateHolder.InstanceState.STOPPED);
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.startServing();
        }
    }

    @Override
    public void stopServing() throws Exception {
        this.requireState("stopServing", InstanceStateHolder.InstanceState.RUNNING);
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.stopServing();
        }
    }

    private void requireState(String operation, InstanceStateHolder.InstanceState requiredState) {
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.requireState(operation, requiredState);
        }
    }

    private class FromFirstMaybeAvailableInstanceIterator
    extends AbstractIterator<ManualInstanceHolder> {
        private static final int INVALID_INSTANCE_ID = -1;
        private int startInstanceId = -1;
        private int currentInstanceId = -1;

        private FromFirstMaybeAvailableInstanceIterator() {
        }

        protected ManualInstanceHolder computeNext() {
            if (ManualModule.this.getInstanceCount() == 0) {
                this.endOfData();
                return null;
            }
            if (this.startInstanceId == -1) {
                ManualInstanceHolder instanceHolder = ManualModule.this.getFirstMaybeAvailableInstanceHolder();
                this.currentInstanceId = this.startInstanceId = instanceHolder.getInstance();
                return instanceHolder;
            }
            int nextInstanceId = (this.currentInstanceId + 1) % ManualModule.this.getInstanceCount();
            if (nextInstanceId == this.startInstanceId) {
                this.endOfData();
                return null;
            }
            this.currentInstanceId = nextInstanceId;
            return (ManualInstanceHolder)ManualModule.this.getInstanceHolder(this.currentInstanceId);
        }
    }
}

