/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AbstractModule;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHelper;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.ManualInstanceHolder;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class BasicModule
extends AbstractModule<ManualInstanceHolder> {
    private static final int MAX_INSTANCES_CAP = 2;
    private AtomicReference<ManualInstanceHolder> lastUsedInstance = new AtomicReference();

    BasicModule(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, String address, DevAppServer devAppServer, AppEngineWebXml appEngineWebXml) {
        super(moduleConfigurationHandle, serverInfo, null, address, devAppServer, BasicModule.toInstanceHolders(appEngineWebXml, moduleConfigurationHandle));
    }

    private static List<ManualInstanceHolder> toInstanceHolders(AppEngineWebXml appEngineWebXml, ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle) {
        int instances;
        String instancesString = appEngineWebXml.getBasicScaling().getMaxInstances();
        int n = instances = instancesString == null ? 0 : Integer.parseInt(instancesString);
        if (instances <= 0) {
            throw new AppEngineConfigException("Invalid instances " + instances + " in file " + moduleConfigurationHandle.getModule().getAppEngineWebXmlFile());
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int index = -1; index < 2 && index < instances; ++index) {
            listBuilder.add((Object)BasicModule.toInstanceHolder(moduleConfigurationHandle, index));
        }
        return listBuilder.build();
    }

    private static ManualInstanceHolder toInstanceHolder(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, int index) {
        String moduleName = moduleConfigurationHandle.getModule().getModuleName();
        InstanceStateHolder stateHolder = new InstanceStateHolder(moduleName, index);
        ContainerService containerService = ContainerUtils.loadContainer();
        InstanceHelper instanceHelper = new InstanceHelper(moduleName, index, stateHolder, containerService);
        return new ManualInstanceHolder(moduleName, containerService, index, stateHolder, instanceHelper);
    }

    @Override
    public LocalServerEnvironment doConfigure(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, File externalResourceDir, String address, Map<String, Object> containerConfigProperties, DevAppServer devAppServer) throws Exception {
        LocalServerEnvironment result = null;
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.setConfiguration(moduleConfigurationHandle, serverInfo, externalResourceDir, address, containerConfigProperties, devAppServer);
            LocalServerEnvironment thisEnvironment = instanceHolder.doConfigure();
            if (result != null) continue;
            result = thisEnvironment;
        }
        return result;
    }

    @Override
    public int getInstanceCount() {
        return this.getInstanceHolders().size() - 1;
    }

    @Override
    public ManualInstanceHolder getAndReserveAvailableInstanceHolder() {
        if (this.getInstanceCount() == 1) {
            return (ManualInstanceHolder)Iterables.getLast(this.getInstanceHolders(), null);
        }
        for (ManualInstanceHolder instance : this.getInstanceHolders()) {
            if (instance == this.lastUsedInstance.get() || !instance.acquireServingPermit()) continue;
            this.lastUsedInstance.set(instance);
            return instance;
        }
        return null;
    }

    @Override
    public void startServing() throws Exception {
        this.requireState("startServing", InstanceStateHolder.InstanceState.STOPPED);
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.startServing();
        }
    }

    @Override
    public void stopServing() throws Exception {
        this.requireState("stopServing", InstanceStateHolder.InstanceState.RUNNING);
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.stopServing();
        }
    }

    private void requireState(String operation, InstanceStateHolder.InstanceState requiredState) {
        for (ManualInstanceHolder instanceHolder : this.getInstanceHolders()) {
            instanceHolder.requireState(operation, requiredState);
        }
    }
}

