/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class SnippetExpressionQueryParser {
    private final List<String> tokens = new ArrayList<String>();
    private final String fieldName;

    public SnippetExpressionQueryParser(String fieldName) {
        this.fieldName = fieldName == null ? "" : fieldName;
    }

    public List<String> parse(String query) {
        try {
            CommonTree tree = new QueryTreeBuilder(new QueryParserFactory()).parse(query);
            if (tree.getChildCount() == 0) {
                return null;
            }
            this.getTokens((Tree)tree);
            return this.tokens;
        }
        catch (RecognitionException e) {
            throw new SearchQueryException("Failed to parse " + query);
        }
    }

    private void textQuery(Tree tree) {
        switch (tree.getChild(0).getType()) {
            case 42: {
                this.tokens.add(tree.getChild(1).getText());
                break;
            }
            case 41: {
                for (int i = 0; i < tree.getChild(1).getChildCount(); ++i) {
                    String token = tree.getChild(1).getChild(i).getText().trim();
                    if (this.tokens.isEmpty()) continue;
                    this.tokens.add(token);
                }
                break;
            }
        }
    }

    private void getTokens(Tree tree) {
        if (tree == null) {
            throw new SearchQueryException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 8: 
            case 10: 
            case 31: 
            case 39: {
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    this.getTokens(tree.getChild(i));
                }
                break;
            }
            case 45: {
                this.textQuery(tree);
                break;
            }
            case 12: 
            case 22: {
                Tree lhs = tree.getChild(0);
                if (lhs.getType() == 45) {
                    if (!lhs.getChild(1).getText().equals(this.fieldName)) break;
                    this.getTokens(tree.getChild(1));
                    break;
                }
                if (lhs.getType() != 20) break;
                this.getTokens(tree.getChild(1));
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                throw new SearchQueryException("Not yet implemented: " + tree.getType());
            }
        }
    }
}

