/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

class GeometricTokenStream
extends TokenStream {
    public static final String TOKEN_TYPE_GEOMETRIC = "geometric";
    private static final int ANYWHERE_LEVEL = -1;
    static final String ANYWHERE_TOKEN = "anywhere";
    private int i = -1;
    private final TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final S2CellId maxCell;

    GeometricTokenStream(S2LatLng point) {
        this.maxCell = S2CellId.fromLatLng((S2LatLng)point);
    }

    public boolean incrementToken() throws IOException {
        if (this.i == -1) {
            this.typeAtt.setType(TOKEN_TYPE_GEOMETRIC);
            this.termAtt.setTermBuffer(ANYWHERE_TOKEN);
            this.i = 0;
            return true;
        }
        if (this.i > 30) {
            return false;
        }
        S2CellId cellId = this.maxCell.parent(this.i++);
        this.typeAtt.setType(TOKEN_TYPE_GEOMETRIC);
        this.termAtt.setTermBuffer("S2:" + cellId.level() + ":" + cellId.toToken());
        return true;
    }
}

