/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.KeyFilteredPseudoKind;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.Lists;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class KindPseudoKind
extends KeyFilteredPseudoKind {
    KindPseudoKind(LocalDatastoreService localDatastore) {
        super(localDatastore);
    }

    @Override
    public String getKindName() {
        return "__kind__";
    }

    private String kindKeyToString(Key key) {
        if (key == null) {
            return null;
        }
        Utils.checkRequest(key.getParent() == null, String.format("Key filter on %s is invalid (key has parent) - received %s", "__kind__", key));
        Utils.checkRequest(key.getKind().equals("__kind__") && key.getName() != null, String.format("Key filter on %s is invalid (must be a named key for %s) - received %s", "__kind__", "__kind__", key));
        return key.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OnestoreEntity.EntityProto> runQuery(DatastoreV3Pb.Query query, Key startKey, boolean startInclusive, Key endKey, boolean endInclusive) {
        Utils.checkRequest(!query.hasAncestor(), "ancestor queries on __kind__ not allowed");
        String app = query.getApp();
        String namespace = query.getNameSpace();
        String startKind = this.kindKeyToString(startKey);
        String endKind = this.kindKeyToString(endKey);
        LocalDatastoreService.Profile profile = this.getDatastore().getOrCreateProfile(app);
        Map<String, LocalDatastoreService.Extent> extents = profile.getExtents();
        ArrayList kinds = Lists.newArrayList();
        Map<String, LocalDatastoreService.Extent> map = extents;
        synchronized (map) {
            for (Map.Entry<String, LocalDatastoreService.Extent> entry : extents.entrySet()) {
                int kindsCompared;
                String kind = entry.getKey();
                if (startKind != null) {
                    kindsCompared = kind.compareTo(startKind);
                    if (startInclusive && kindsCompared < 0 || !startInclusive && kindsCompared <= 0) continue;
                }
                if (endKind != null) {
                    kindsCompared = kind.compareTo(endKind);
                    if (endInclusive && kindsCompared > 0 || !endInclusive && kindsCompared >= 0) continue;
                }
                if (entry.getValue().getAllEntityProtos().isEmpty() || !KindPseudoKind.isKindPresentInNamespace(entry.getValue(), namespace)) continue;
                kinds.add(KindPseudoKind.makeKindEntity(kind, app, namespace));
            }
        }
        return kinds;
    }

    private static boolean isKindPresentInNamespace(LocalDatastoreService.Extent extent, String namespace) {
        for (OnestoreEntity.EntityProto entity : extent.getAllEntityProtos()) {
            if (!entity.getKey().getNameSpace().equals(namespace)) continue;
            return true;
        }
        return false;
    }

    private static OnestoreEntity.EntityProto makeKindEntity(String kind, String app, String namespace) {
        OnestoreEntity.EntityProto kindEntity = new OnestoreEntity.EntityProto();
        OnestoreEntity.Path path = new OnestoreEntity.Path();
        path.addElement().setType("__kind__").setName(kind);
        OnestoreEntity.Reference key = new OnestoreEntity.Reference().setApp(app).setPath(path);
        if (namespace.length() > 0) {
            key.setNameSpace(namespace);
        }
        kindEntity.setKey(key);
        kindEntity.getMutableEntityGroup().addElement(path.getElement(0));
        return kindEntity;
    }
}

