/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class CompiledCursorUtil {
    private CompiledCursorUtil() {
    }

    private static void checkNormalized(DatastorePb.CompiledCursor cursor) {
        Preconditions.checkArgument((!cursor.hasPosition() ? 1 : 0) != 0, (Object)"Normalized cursors cannot specify a position.");
    }

    public static boolean isEmpty(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return !CompiledCursorUtil.isEncoded(normalizedCursor) && !CompiledCursorUtil.isPlannable(normalizedCursor);
    }

    public static boolean isEncoded(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return normalizedCursor.hasAbsolutePosition();
    }

    public static boolean isPlannable(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return normalizedCursor.hasPostfixPosition();
    }

    @Nullable
    public static DatastorePb.Query.Order.Direction getFirstSortDirection(DatastorePb.Query query) {
        return query.orders().isEmpty() ? null : query.getOrder(0).getDirectionEnum();
    }

    public static void normalizeCursors(DatastorePb.Query query) {
        DatastorePb.Query.Order.Direction firstSortDirection = CompiledCursorUtil.getFirstSortDirection(query);
        if (query.hasCompiledCursor()) {
            CompiledCursorUtil.normalizeCursor(query.getCompiledCursor(), firstSortDirection);
        }
        if (query.hasEndCompiledCursor()) {
            CompiledCursorUtil.normalizeCursor(query.getEndCompiledCursor(), firstSortDirection);
        }
    }

    private static void normalizeCursor(DatastorePb.CompiledCursor cursor, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        Preconditions.checkArgument((!(cursor.hasPosition() && cursor.hasPostfixPosition() || cursor.hasPosition() && cursor.hasAbsolutePosition() || cursor.hasPostfixPosition() && cursor.hasAbsolutePosition()) ? 1 : 0) != 0, (Object)"Cursor may specify at most one of position, postfix_position, and absolute_position.");
        if (cursor.hasPosition()) {
            DatastorePb.CompiledCursor.Position pos = cursor.getPosition();
            if (pos.hasStartKey()) {
                OnestoreEntity.IndexPosition indexPos = cursor.getMutableAbsolutePosition();
                indexPos.setKeyAsBytes(pos.getStartKeyAsBytes());
                if (pos.hasStartInclusive()) {
                    indexPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    indexPos.setBeforeAscending(pos.isBeforeAscending());
                }
            } else if (pos.hasKey() || pos.indexValueSize() > 0) {
                OnestoreEntity.IndexPostfix postfixPos = cursor.getMutablePostfixPosition();
                for (DatastorePb.CompiledCursor.PositionIndexValue value : pos.indexValues()) {
                    OnestoreEntity.IndexPostfix_IndexValue indexValue = postfixPos.addIndexValue().setPropertyName(value.getProperty());
                    indexValue.getMutableValue().mergeFrom(value.getValue());
                }
                if (pos.hasKey()) {
                    postfixPos.getMutableKey().mergeFrom(pos.getKey());
                }
                if (pos.hasStartInclusive()) {
                    postfixPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    postfixPos.setBeforeAscending(pos.isBeforeAscending());
                }
            }
            cursor.clearPosition();
        }
        if (CompiledCursorUtil.isEmpty(cursor)) {
            return;
        }
        if (cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition indexPosition = cursor.getAbsolutePosition();
            if (indexPosition.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPosition, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPosition, firstSortDirection);
            }
        } else if (cursor.hasPostfixPosition()) {
            OnestoreEntity.IndexPostfix indexPostfix = cursor.getPostfixPosition();
            if (indexPostfix.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPostfix, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPostfix, firstSortDirection);
            }
        }
    }

    public static void setBefore(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.getBefore(position.isBeforeAscending(), firstSortDirection));
    }

    public static void setBefore(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.getBefore(position.isBeforeAscending(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.getBeforeAscending(position.isBefore(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.getBeforeAscending(position.isBefore(), firstSortDirection));
    }

    private static boolean getBefore(boolean isBeforeAscending, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBeforeAscending ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }

    private static boolean getBeforeAscending(boolean isBefore, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBefore ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }
}

