/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

class SocketImplAccessor {
    private static Constructor<?> SOCKET_IMPL_CONSTRUCTOR = SocketImplAccessor.fetchConstructor("java.net.SocksSocketImpl");
    private static final Method CREATE = SocketImplAccessor.fetchMethod("create", Boolean.TYPE);
    private static final Method CONNECT_STRING = SocketImplAccessor.fetchMethod("connect", String.class, Integer.TYPE);
    private static final Method CONNECT_INET_ADDRESS = SocketImplAccessor.fetchMethod("connect", InetAddress.class, Integer.TYPE);
    private static final Method CONNECT_SOCKET_ADDRESS = SocketImplAccessor.fetchMethod("connect", SocketAddress.class, Integer.TYPE);
    private static final Method BIND_INET_ADDRESS = SocketImplAccessor.fetchMethod("bind", InetAddress.class, Integer.TYPE);
    private static final Method LISTEN = SocketImplAccessor.fetchMethod("listen", Integer.TYPE);
    private static final Method ACCEPT = SocketImplAccessor.fetchMethod("accept", SocketImpl.class);
    private static final Method GET_INPUT_STREAM = SocketImplAccessor.fetchMethod("getInputStream", new Class[0]);
    private static final Method GET_OUTPUT_STREAM = SocketImplAccessor.fetchMethod("getOutputStream", new Class[0]);
    private static final Method AVAILABLE = SocketImplAccessor.fetchMethod("available", new Class[0]);
    private static final Method CLOSE = SocketImplAccessor.fetchMethod("close", new Class[0]);
    private static final Method SEND_URGENT_DATA = SocketImplAccessor.fetchMethod("sendUrgentData", Integer.TYPE);
    private static final Method SHUTDOWN_INPUT = SocketImplAccessor.fetchMethod("shutdownInput", new Class[0]);
    private static final Method SHUTDOWN_OUTPUT = SocketImplAccessor.fetchMethod("shutdownOutput", new Class[0]);
    private static final Method GET_INETADDRESS = SocketImplAccessor.fetchMethod("getInetAddress", new Class[0]);
    private static final Method GET_PORT = SocketImplAccessor.fetchMethod("getPort", new Class[0]);
    private static final Method GET_LOCAL_PORT = SocketImplAccessor.fetchMethod("getLocalPort", new Class[0]);
    private static final Method TO_STRING = SocketImplAccessor.fetchMethod("toString", new Class[0]);
    SocketImpl socketImpl;
    private static final SocketImplAccessorFactory BASE_FACTORY;
    private static SocketImplAccessorFactory factory;

    @VisibleForTesting
    SocketImplAccessor(SocketImpl socketImpl) {
        if (socketImpl == null) {
            throw new IllegalArgumentException("socketImpl cannot be null");
        }
        this.socketImpl = socketImpl;
    }

    private static Constructor<?> fetchConstructor(String className) {
        Constructor<?> constructor;
        Class<?> plainSocketClass;
        try {
            plainSocketClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        try {
            constructor = plainSocketClass.getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        constructor.setAccessible(true);
        return constructor;
    }

    private static SocketImpl newPlainSocket() {
        try {
            return (SocketImpl)SOCKET_IMPL_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    public static SocketImplAccessor newSocketImplAccessor() {
        return factory.newSocketImplAccessor();
    }

    static void setSocketImplAccessorFactory(SocketImplAccessorFactory factory) {
        SocketImplAccessor.factory = factory == null ? BASE_FACTORY : factory;
    }

    static Method fetchMethod(String name, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = SocketImpl.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        method.setAccessible(true);
        return method;
    }

    private Object invoke(Method method, Object ... args) throws IOException {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            String string = String.valueOf(this.socketImpl.getClass().getSimpleName());
            String string2 = String.valueOf(method.getName());
            throw new IllegalStateException(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unexpected exception thrown by method: ").append(string).append("#").append(string2).toString(), e.getCause());
        }
    }

    private Object invokeNoException(Method method, Object ... args) {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(this.socketImpl.getClass().getSimpleName());
            String string2 = String.valueOf(method.getName());
            throw new IllegalStateException(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unexpected exception thrown by method: ").append(string).append("#").append(string2).toString(), e.getCause());
        }
    }

    InetAddress getInetAddress() {
        return (InetAddress)this.invokeNoException(GET_INETADDRESS, new Object[0]);
    }

    int getPort() {
        return (Integer)this.invokeNoException(GET_PORT, new Object[0]);
    }

    int getLocalPort() {
        return (Integer)this.invokeNoException(GET_LOCAL_PORT, new Object[0]);
    }

    public String toString() {
        return (String)this.invokeNoException(TO_STRING, new Object[0]);
    }

    void setOption(int optID, Object value) throws SocketException {
        this.socketImpl.setOption(optID, value);
    }

    Object getOption(int optID) throws SocketException {
        return this.socketImpl.getOption(optID);
    }

    void create(boolean stream) throws IOException {
        this.invoke(CREATE, stream);
    }

    void connect(String host, int port) throws IOException {
        this.invoke(CONNECT_STRING, host, port);
    }

    void connect(InetAddress address, int port) throws IOException {
        this.invoke(CONNECT_INET_ADDRESS, address, port);
    }

    void connect(SocketAddress address, int timeout) throws IOException {
        this.invoke(CONNECT_SOCKET_ADDRESS, address, timeout);
    }

    void bind(InetAddress host, int port) throws IOException {
        this.invoke(BIND_INET_ADDRESS, host, port);
    }

    void listen(int backlog) throws IOException {
        this.invoke(LISTEN, backlog);
    }

    void accept(SocketImplAccessor s) throws IOException {
        this.invoke(ACCEPT, s.socketImpl);
    }

    InputStream getInputStream() throws IOException {
        return (InputStream)this.invoke(GET_INPUT_STREAM, new Object[0]);
    }

    OutputStream getOutputStream() throws IOException {
        return (OutputStream)this.invoke(GET_OUTPUT_STREAM, new Object[0]);
    }

    int available() throws IOException {
        return (Integer)this.invoke(AVAILABLE, new Object[0]);
    }

    void close() throws IOException {
        this.invoke(CLOSE, new Object[0]);
    }

    void shutdownInput() throws IOException {
        this.invoke(SHUTDOWN_INPUT, new Object[0]);
    }

    void shutdownOutput() throws IOException {
        this.invoke(SHUTDOWN_OUTPUT, new Object[0]);
    }

    void sendUrgentData(int data) throws IOException {
        this.invoke(SEND_URGENT_DATA, data);
    }

    static {
        factory = BASE_FACTORY = new SocketImplAccessorFactory(){

            @Override
            public SocketImplAccessor newSocketImplAccessor() {
                return new SocketImplAccessor(SocketImplAccessor.newPlainSocket());
            }
        };
    }

    @VisibleForTesting
    static interface SocketImplAccessorFactory {
        public SocketImplAccessor newSocketImplAccessor();
    }
}

