/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-30 at 21:28:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A vector style contains styling information for vector layer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VectorStyle extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DisplayRule> displayRules;

  static {
    // hack to force ProGuard to consider DisplayRule used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(DisplayRule.class);
  }

  /**
   * Individual feature info, this is called Info Window in Maps Engine UI. If not provided, a
   * default template with all attributes will be generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FeatureInfo featureInfo;

  /**
   * The type of the vector style. Currently, only displayRule is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<DisplayRule> getDisplayRules() {
    return displayRules;
  }

  /**
   * @param displayRules displayRules or {@code null} for none
   */
  public VectorStyle setDisplayRules(java.util.List<DisplayRule> displayRules) {
    this.displayRules = displayRules;
    return this;
  }

  /**
   * Individual feature info, this is called Info Window in Maps Engine UI. If not provided, a
   * default template with all attributes will be generated.
   * @return value or {@code null} for none
   */
  public FeatureInfo getFeatureInfo() {
    return featureInfo;
  }

  /**
   * Individual feature info, this is called Info Window in Maps Engine UI. If not provided, a
   * default template with all attributes will be generated.
   * @param featureInfo featureInfo or {@code null} for none
   */
  public VectorStyle setFeatureInfo(FeatureInfo featureInfo) {
    this.featureInfo = featureInfo;
    return this;
  }

  /**
   * The type of the vector style. Currently, only displayRule is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the vector style. Currently, only displayRule is supported.
   * @param type type or {@code null} for none
   */
  public VectorStyle setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public VectorStyle set(String fieldName, Object value) {
    return (VectorStyle) super.set(fieldName, value);
  }

  @Override
  public VectorStyle clone() {
    return (VectorStyle) super.clone();
  }

}
