/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-03 at 12:02:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Model definition for Permission.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends com.google.api.client.json.GenericJson {

  /**
   * True if asset is listed and is searchable by the public.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean discoverable;

  /**
   * The email address of the user this permission refers to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The ID of the permission. When making a mapsengine.permissions.batchInsert request, the id or
   * emailAddress fields must be specified. If both id and emailAddress are provided they must be
   * consistent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The primary role for this user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The account type. Allowed values are:
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * True if asset is listed and is searchable by the public.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDiscoverable() {
    return discoverable;
  }

  /**
   * True if asset is listed and is searchable by the public.
   * @param discoverable discoverable or {@code null} for none
   */
  public Permission setDiscoverable(java.lang.Boolean discoverable) {
    this.discoverable = discoverable;
    return this;
  }

  /**
   * The email address of the user this permission refers to.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user this permission refers to.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public Permission setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The ID of the permission. When making a mapsengine.permissions.batchInsert request, the id or
   * emailAddress fields must be specified. If both id and emailAddress are provided they must be
   * consistent.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the permission. When making a mapsengine.permissions.batchInsert request, the id or
   * emailAddress fields must be specified. If both id and emailAddress are provided they must be
   * consistent.
   * @param id id or {@code null} for none
   */
  public Permission setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The primary role for this user.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The primary role for this user.
   * @param role role or {@code null} for none
   */
  public Permission setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The account type. Allowed values are:
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The account type. Allowed values are:
   * @param type type or {@code null} for none
   */
  public Permission setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Permission set(String fieldName, Object value) {
    return (Permission) super.set(fieldName, value);
  }

  @Override
  public Permission clone() {
    return (Permission) super.clone();
  }

}
