/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Dimension filter specifies the filtering options on a dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SegmentDimensionFilter extends com.google.api.client.json.GenericJson {

  /**
   * Should the match be case sensitive, ignored for `IN_LIST` operator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean caseSensitive;

  /**
   * Name of the dimension for which the filter is being applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionName;

  /**
   * The list of expressions, only the first element is used for all operators
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> expressions;

  /**
   * Maximum comparison values for `BETWEEN` match type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxComparisonValue;

  /**
   * Minimum comparison values for `BETWEEN` match type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minComparisonValue;

  /**
   * The operator to use to match the dimension with the expressions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operator;

  /**
   * Should the match be case sensitive, ignored for `IN_LIST` operator.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCaseSensitive() {
    return caseSensitive;
  }

  /**
   * Should the match be case sensitive, ignored for `IN_LIST` operator.
   * @param caseSensitive caseSensitive or {@code null} for none
   */
  public SegmentDimensionFilter setCaseSensitive(java.lang.Boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
    return this;
  }

  /**
   * Name of the dimension for which the filter is being applied.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionName() {
    return dimensionName;
  }

  /**
   * Name of the dimension for which the filter is being applied.
   * @param dimensionName dimensionName or {@code null} for none
   */
  public SegmentDimensionFilter setDimensionName(java.lang.String dimensionName) {
    this.dimensionName = dimensionName;
    return this;
  }

  /**
   * The list of expressions, only the first element is used for all operators
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExpressions() {
    return expressions;
  }

  /**
   * The list of expressions, only the first element is used for all operators
   * @param expressions expressions or {@code null} for none
   */
  public SegmentDimensionFilter setExpressions(java.util.List<java.lang.String> expressions) {
    this.expressions = expressions;
    return this;
  }

  /**
   * Maximum comparison values for `BETWEEN` match type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxComparisonValue() {
    return maxComparisonValue;
  }

  /**
   * Maximum comparison values for `BETWEEN` match type.
   * @param maxComparisonValue maxComparisonValue or {@code null} for none
   */
  public SegmentDimensionFilter setMaxComparisonValue(java.lang.String maxComparisonValue) {
    this.maxComparisonValue = maxComparisonValue;
    return this;
  }

  /**
   * Minimum comparison values for `BETWEEN` match type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinComparisonValue() {
    return minComparisonValue;
  }

  /**
   * Minimum comparison values for `BETWEEN` match type.
   * @param minComparisonValue minComparisonValue or {@code null} for none
   */
  public SegmentDimensionFilter setMinComparisonValue(java.lang.String minComparisonValue) {
    this.minComparisonValue = minComparisonValue;
    return this;
  }

  /**
   * The operator to use to match the dimension with the expressions.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperator() {
    return operator;
  }

  /**
   * The operator to use to match the dimension with the expressions.
   * @param operator operator or {@code null} for none
   */
  public SegmentDimensionFilter setOperator(java.lang.String operator) {
    this.operator = operator;
    return this;
  }

  @Override
  public SegmentDimensionFilter set(String fieldName, Object value) {
    return (SegmentDimensionFilter) super.set(fieldName, value);
  }

  @Override
  public SegmentDimensionFilter clone() {
    return (SegmentDimensionFilter) super.clone();
  }

}
