/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-03-25 20:06:55 UTC)
 * on 2016-04-07 at 21:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * A row in the report.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API V4. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportRow extends com.google.api.client.json.GenericJson {

  /**
   * List of requested dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dimensions;

  /**
   * List of metrics for each requested DateRange
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DateRangeValues> metrics;

  static {
    // hack to force ProGuard to consider DateRangeValues used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(DateRangeValues.class);
  }

  /**
   * List of requested dimensions.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDimensions() {
    return dimensions;
  }

  /**
   * List of requested dimensions.
   * @param dimensions dimensions or {@code null} for none
   */
  public ReportRow setDimensions(java.util.List<java.lang.String> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * List of metrics for each requested DateRange
   * @return value or {@code null} for none
   */
  public java.util.List<DateRangeValues> getMetrics() {
    return metrics;
  }

  /**
   * List of metrics for each requested DateRange
   * @param metrics metrics or {@code null} for none
   */
  public ReportRow setMetrics(java.util.List<DateRangeValues> metrics) {
    this.metrics = metrics;
    return this;
  }

  @Override
  public ReportRow set(String fieldName, Object value) {
    return (ReportRow) super.set(fieldName, value);
  }

  @Override
  public ReportRow clone() {
    return (ReportRow) super.clone();
  }

}
