/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-03-25 20:06:55 UTC)
 * on 2016-04-07 at 21:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Defines a cohort group. For example:
 *
 *     "cohortGroup": {       "cohorts": [{         "name": "cohort 1",         "type":
 * "FIRST_VISIT_DATE",         "dateRange": { "startDate": "2015-08-01", "endDate": "2015-08-01" }
 * },{         "name": "cohort 2"          "type": "FIRST_VISIT_DATE"          "dateRange": {
 * "startDate": "2015-07-01", "endDate": "2015-07-01" }       }]     }
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API V4. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CohortGroup extends com.google.api.client.json.GenericJson {

  /**
   * The definition for the cohort.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Cohort> cohorts;

  static {
    // hack to force ProGuard to consider Cohort used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Cohort.class);
  }

  /**
   * Enable Life Time Value (LTV).  LTV measures lifetime value for users acquired through different
   * channels. Please see: [Cohort Analysis](https://support.google.com/analytics/answer/6074676)
   * and [Lifetime Value](https://support.google.com/analytics/answer/6182550) If the value of
   * lifetimeValue is false:
   *
   * - The metric values are similar to the values in the web interface cohort   report. - The
   * cohort definition date ranges must be aligned to the calendar week   and month. i.e. while
   * requesting `ga:cohortNthWeek` the `startDate` in   the cohort definition should be a Sunday and
   * the `endDate` should be the   following Saturday, and for `ga:cohortNthMonth`, the `startDate`
   * should be the 1st of the month and `endDate` should be the last day   of the month.
   *
   * When the lifetimeValue is true:
   *
   * - The metric values will correspond to the values in the web interface   LifeTime value report.
   * - The Lifetime Value report shows you how user value (Revenue) and   engagement (Appviews, Goal
   * Completions, Sessions, and Session Duration)   grow during the 90 days after a user is
   * acquired. - The metrics are calculated as a cumulative average per user per the time
   * increment. - The cohort definition date ranges need not be aligned to the calendar   week and
   * month boundaries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean lifetimeValue;

  /**
   * The definition for the cohort.
   * @return value or {@code null} for none
   */
  public java.util.List<Cohort> getCohorts() {
    return cohorts;
  }

  /**
   * The definition for the cohort.
   * @param cohorts cohorts or {@code null} for none
   */
  public CohortGroup setCohorts(java.util.List<Cohort> cohorts) {
    this.cohorts = cohorts;
    return this;
  }

  /**
   * Enable Life Time Value (LTV).  LTV measures lifetime value for users acquired through different
   * channels. Please see: [Cohort Analysis](https://support.google.com/analytics/answer/6074676)
   * and [Lifetime Value](https://support.google.com/analytics/answer/6182550) If the value of
   * lifetimeValue is false:
   *
   * - The metric values are similar to the values in the web interface cohort   report. - The
   * cohort definition date ranges must be aligned to the calendar week   and month. i.e. while
   * requesting `ga:cohortNthWeek` the `startDate` in   the cohort definition should be a Sunday and
   * the `endDate` should be the   following Saturday, and for `ga:cohortNthMonth`, the `startDate`
   * should be the 1st of the month and `endDate` should be the last day   of the month.
   *
   * When the lifetimeValue is true:
   *
   * - The metric values will correspond to the values in the web interface   LifeTime value report.
   * - The Lifetime Value report shows you how user value (Revenue) and   engagement (Appviews, Goal
   * Completions, Sessions, and Session Duration)   grow during the 90 days after a user is
   * acquired. - The metrics are calculated as a cumulative average per user per the time
   * increment. - The cohort definition date ranges need not be aligned to the calendar   week and
   * month boundaries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLifetimeValue() {
    return lifetimeValue;
  }

  /**
   * Enable Life Time Value (LTV).  LTV measures lifetime value for users acquired through different
   * channels. Please see: [Cohort Analysis](https://support.google.com/analytics/answer/6074676)
   * and [Lifetime Value](https://support.google.com/analytics/answer/6182550) If the value of
   * lifetimeValue is false:
   *
   * - The metric values are similar to the values in the web interface cohort   report. - The
   * cohort definition date ranges must be aligned to the calendar week   and month. i.e. while
   * requesting `ga:cohortNthWeek` the `startDate` in   the cohort definition should be a Sunday and
   * the `endDate` should be the   following Saturday, and for `ga:cohortNthMonth`, the `startDate`
   * should be the 1st of the month and `endDate` should be the last day   of the month.
   *
   * When the lifetimeValue is true:
   *
   * - The metric values will correspond to the values in the web interface   LifeTime value report.
   * - The Lifetime Value report shows you how user value (Revenue) and   engagement (Appviews, Goal
   * Completions, Sessions, and Session Duration)   grow during the 90 days after a user is
   * acquired. - The metrics are calculated as a cumulative average per user per the time
   * increment. - The cohort definition date ranges need not be aligned to the calendar   week and
   * month boundaries.
   * @param lifetimeValue lifetimeValue or {@code null} for none
   */
  public CohortGroup setLifetimeValue(java.lang.Boolean lifetimeValue) {
    this.lifetimeValue = lifetimeValue;
    return this;
  }

  @Override
  public CohortGroup set(String fieldName, Object value) {
    return (CohortGroup) super.set(fieldName, value);
  }

  @Override
  public CohortGroup clone() {
    return (CohortGroup) super.clone();
  }

}
