/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-09 17:08:39 UTC)
 * on 2014-07-23 at 21:30:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * Metadata for daily upload entity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DailyUpload extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Number of appends for this date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer appendCount;

  /**
   * Time this daily upload was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdTime;

  /**
   * Custom data source ID to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customDataSourceId;

  /**
   * Date associated with daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String date;

  /**
   * Resource type for Analytics daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Time this daily upload was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedTime;

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Change log for last 10 changes in chronological order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RecentChanges> recentChanges;

  static {
    // hack to force ProGuard to consider RecentChanges used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(RecentChanges.class);
  }

  /**
   * Link for this daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this daily upload belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this daily upload belongs.
   * @param accountId accountId or {@code null} for none
   */
  public DailyUpload setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Number of appends for this date.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAppendCount() {
    return appendCount;
  }

  /**
   * Number of appends for this date.
   * @param appendCount appendCount or {@code null} for none
   */
  public DailyUpload setAppendCount(java.lang.Integer appendCount) {
    this.appendCount = appendCount;
    return this;
  }

  /**
   * Time this daily upload was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * Time this daily upload was created.
   * @param createdTime createdTime or {@code null} for none
   */
  public DailyUpload setCreatedTime(com.google.api.client.util.DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * Custom data source ID to which this daily upload belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomDataSourceId() {
    return customDataSourceId;
  }

  /**
   * Custom data source ID to which this daily upload belongs.
   * @param customDataSourceId customDataSourceId or {@code null} for none
   */
  public DailyUpload setCustomDataSourceId(java.lang.String customDataSourceId) {
    this.customDataSourceId = customDataSourceId;
    return this;
  }

  /**
   * Date associated with daily upload.
   * @return value or {@code null} for none
   */
  public java.lang.String getDate() {
    return date;
  }

  /**
   * Date associated with daily upload.
   * @param date date or {@code null} for none
   */
  public DailyUpload setDate(java.lang.String date) {
    this.date = date;
    return this;
  }

  /**
   * Resource type for Analytics daily upload.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics daily upload.
   * @param kind kind or {@code null} for none
   */
  public DailyUpload setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Time this daily upload was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * Time this daily upload was last modified.
   * @param modifiedTime modifiedTime or {@code null} for none
   */
  public DailyUpload setModifiedTime(com.google.api.client.util.DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public DailyUpload setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Change log for last 10 changes in chronological order.
   * @return value or {@code null} for none
   */
  public java.util.List<RecentChanges> getRecentChanges() {
    return recentChanges;
  }

  /**
   * Change log for last 10 changes in chronological order.
   * @param recentChanges recentChanges or {@code null} for none
   */
  public DailyUpload setRecentChanges(java.util.List<RecentChanges> recentChanges) {
    this.recentChanges = recentChanges;
    return this;
  }

  /**
   * Link for this daily upload.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this daily upload.
   * @param selfLink selfLink or {@code null} for none
   */
  public DailyUpload setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public DailyUpload setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public DailyUpload set(String fieldName, Object value) {
    return (DailyUpload) super.set(fieldName, value);
  }

  @Override
  public DailyUpload clone() {
    return (DailyUpload) super.clone();
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the custom data source to which this daily upload belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#customDataSource".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the custom data source to which this daily upload belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the custom data source to which this daily upload belongs.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#customDataSource".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#customDataSource".
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

  /**
   * Model definition for DailyUploadRecentChanges.
   */
  public static final class RecentChanges extends com.google.api.client.json.GenericJson {

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String change;

    /**
     * The time when the change occurred.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime time;

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * @return value or {@code null} for none
     */
    public java.lang.String getChange() {
      return change;
    }

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * @param change change or {@code null} for none
     */
    public RecentChanges setChange(java.lang.String change) {
      this.change = change;
      return this;
    }

    /**
     * The time when the change occurred.
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getTime() {
      return time;
    }

    /**
     * The time when the change occurred.
     * @param time time or {@code null} for none
     */
    public RecentChanges setTime(com.google.api.client.util.DateTime time) {
      this.time = time;
      return this;
    }

    @Override
    public RecentChanges set(String fieldName, Object value) {
      return (RecentChanges) super.set(fieldName, value);
    }

    @Override
    public RecentChanges clone() {
      return (RecentChanges) super.clone();
    }

  }

}
