/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;

/**
 * A daily upload collection lists Analytics daily uploads to which the user has access. Each
 * resource in the collection corresponds to a single Analytics daily upload.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DailyUploads extends GenericJson {

  /**
   * A collection of daily uploads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DailyUpload> items;

  static {
    // hack to force ProGuard to consider DailyUpload used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(DailyUpload.class);
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer itemsPerPage;

  /**
   * Collection type. Value is analytics#dailyUploads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Link to next page for this daily upload collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;

  /**
   * Link to previous page for this daily upload collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String previousLink;

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String username;

  /**
   * A collection of daily uploads.
   * The value returned may be {@code null}.
   */
  public java.util.List<DailyUpload> getItems() {
    return items;
  }

  /**
   * A collection of daily uploads.
   * The value set may be {@code null}.
   */
  public DailyUploads setItems(java.util.List<DailyUpload> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value set may be {@code null}.
   */
  public DailyUploads setItemsPerPage(Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type. Value is analytics#dailyUploads.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Collection type. Value is analytics#dailyUploads.
   * The value set may be {@code null}.
   */
  public DailyUploads setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this daily upload collection.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this daily upload collection.
   * The value set may be {@code null}.
   */
  public DailyUploads setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this daily upload collection.
   * The value returned may be {@code null}.
   */
  public String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this daily upload collection.
   * The value set may be {@code null}.
   */
  public DailyUploads setPreviousLink(String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value set may be {@code null}.
   */
  public DailyUploads setStartIndex(Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value returned may be {@code null}.
   */
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value set may be {@code null}.
   */
  public DailyUploads setTotalResults(Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * The value returned may be {@code null}.
   */
  public String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * The value set may be {@code null}.
   */
  public DailyUploads setUsername(String username) {
    this.username = username;
    return this;
  }

}
