/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.4.0 (build: 2013-06-20 19:08:55 UTC)
 *  on 2013-06-25 at 19:37:49 UTC 
 */

package com.google.api.services.analytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Analytics (v3).
 *
 * <p>
 * View and manage your Google Analytics data
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Analytics extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Google Analytics API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Analytics(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Analytics(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Data collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Data.List request = analytics.data().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Data data() {
    return new Data();
  }

  /**
   * The "data" collection of methods.
   */
  public class Data {

    /**
     * An accessor for creating requests from the Ga collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Ga.List request = analytics.ga().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Ga ga() {
      return new Ga();
    }

    /**
     * The "ga" collection of methods.
     */
    public class Ga {

      /**
       * Returns Analytics data for a profile.
       *
       * Create a request for the method "ga.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics profile ID.
       * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
       * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
       * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       *        must be specified.
       * @return the request
       */
      public Get get(String ids, String startDate, String endDate, String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.GaData> {

        private static final String REST_PATH = "data/ga";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?ga:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        /**
         * Returns Analytics data for a profile.
         *
         * Create a request for the method "ga.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics profile ID.
         * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
         * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
         * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       *        must be specified.
         * @since 1.13
         */
        protected Get(String ids, String startDate, String endDate, String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.GaData.class);
          this.ids = Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.metrics = Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
       * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX
       * is the Analytics profile ID.
       */
        @com.google.api.client.util.Key
        private String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics profile ID.
         */
        public String getIds() {
          return ids;
        }

        /**
       * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX
       * is the Analytics profile ID.
       */
        public Get setIds(String ids) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
       * Start date for fetching Analytics data. All requests should specify a start date formatted
       * as YYYY-MM-DD.
       */
        @com.google.api.client.util.Key("start-date")
        private String startDate;

        /** Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       MM-DD.
         */
        public String getStartDate() {
          return startDate;
        }

        /**
       * Start date for fetching Analytics data. All requests should specify a start date formatted
       * as YYYY-MM-DD.
       */
        public Get setStartDate(String startDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /**
       * End date for fetching Analytics data. All requests should specify an end date formatted as
       * YYYY-MM-DD.
       */
        @com.google.api.client.util.Key("end-date")
        private String endDate;

        /** End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       DD.
         */
        public String getEndDate() {
          return endDate;
        }

        /**
       * End date for fetching Analytics data. All requests should specify an end date formatted as
       * YYYY-MM-DD.
       */
        public Get setEndDate(String endDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /**
       * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
       * metric must be specified.
       */
        @com.google.api.client.util.Key
        private String metrics;

        /** A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       must be specified.
         */
        public String getMetrics() {
          return metrics;
        }

        /**
       * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
       * metric must be specified.
       */
        public Get setMetrics(String metrics) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * A comma-separated list of dimensions or metrics that determine the sort order for Analytics
       * data.
       */
        @com.google.api.client.util.Key
        private String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.
         */
        public String getSort() {
          return sort;
        }

        /**
       * A comma-separated list of dimensions or metrics that determine the sort order for Analytics
       * data.
       */
        public Get setSort(String sort) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?ga:.+");
          }
          this.sort = sort;
          return this;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        @com.google.api.client.util.Key
        private String dimensions;

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'.
         */
        public String getDimensions() {
          return dimensions;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        public Get setDimensions(String dimensions) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(ga:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public Get setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /** An Analytics advanced segment to be applied to data. */
        @com.google.api.client.util.Key
        private String segment;

        /** An Analytics advanced segment to be applied to data.
         */
        public String getSegment() {
          return segment;
        }

        /** An Analytics advanced segment to be applied to data. */
        public Get setSegment(String segment) {
          this.segment = segment;
          return this;
        }

        /** A comma-separated list of dimension or metric filters to be applied to Analytics data. */
        @com.google.api.client.util.Key
        private String filters;

        /** A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        public String getFilters() {
          return filters;
        }

        /** A comma-separated list of dimension or metric filters to be applied to Analytics data. */
        public Get setFilters(String filters) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "ga:.+");
          }
          this.filters = filters;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Mcf collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Mcf.List request = analytics.mcf().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Mcf mcf() {
      return new Mcf();
    }

    /**
     * The "mcf" collection of methods.
     */
    public class Mcf {

      /**
       * Returns Analytics Multi-Channel Funnels data for a profile.
       *
       * Create a request for the method "mcf.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics profile ID.
       * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
       * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
       * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
       * @return the request
       */
      public Get get(String ids, String startDate, String endDate, String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.McfData> {

        private static final String REST_PATH = "data/mcf";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?mcf:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(mcf:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        /**
         * Returns Analytics Multi-Channel Funnels data for a profile.
         *
         * Create a request for the method "mcf.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics profile ID.
         * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
         * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
         * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         * @since 1.13
         */
        protected Get(String ids, String startDate, String endDate, String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.McfData.class);
          this.ids = Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.metrics = Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
       * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX
       * is the Analytics profile ID.
       */
        @com.google.api.client.util.Key
        private String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics profile ID.
         */
        public String getIds() {
          return ids;
        }

        /**
       * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX
       * is the Analytics profile ID.
       */
        public Get setIds(String ids) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
       * Start date for fetching Analytics data. All requests should specify a start date formatted
       * as YYYY-MM-DD.
       */
        @com.google.api.client.util.Key("start-date")
        private String startDate;

        /** Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       MM-DD.
         */
        public String getStartDate() {
          return startDate;
        }

        /**
       * Start date for fetching Analytics data. All requests should specify a start date formatted
       * as YYYY-MM-DD.
       */
        public Get setStartDate(String startDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /**
       * End date for fetching Analytics data. All requests should specify an end date formatted as
       * YYYY-MM-DD.
       */
        @com.google.api.client.util.Key("end-date")
        private String endDate;

        /** End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       DD.
         */
        public String getEndDate() {
          return endDate;
        }

        /**
       * End date for fetching Analytics data. All requests should specify an end date formatted as
       * YYYY-MM-DD.
       */
        public Get setEndDate(String endDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /**
       * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
       */
        @com.google.api.client.util.Key
        private String metrics;

        /** A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        public String getMetrics() {
          return metrics;
        }

        /**
       * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
       */
        public Get setMetrics(String metrics) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * A comma-separated list of dimensions or metrics that determine the sort order for the
       * Analytics data.
       */
        @com.google.api.client.util.Key
        private String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for the Analytics
       data.
         */
        public String getSort() {
          return sort;
        }

        /**
       * A comma-separated list of dimensions or metrics that determine the sort order for the
       * Analytics data.
       */
        public Get setSort(String sort) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?mcf:.+");
          }
          this.sort = sort;
          return this;
        }

        /**
       * A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
       */
        @com.google.api.client.util.Key
        private String dimensions;

        /** A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
         */
        public String getDimensions() {
          return dimensions;
        }

        /**
       * A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
       */
        public Get setDimensions(String dimensions) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(mcf:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public Get setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /**
       * A comma-separated list of dimension or metric filters to be applied to the Analytics data.
       */
        @com.google.api.client.util.Key
        private String filters;

        /** A comma-separated list of dimension or metric filters to be applied to the Analytics data.
         */
        public String getFilters() {
          return filters;
        }

        /**
       * A comma-separated list of dimension or metric filters to be applied to the Analytics data.
       */
        public Get setFilters(String filters) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "mcf:.+");
          }
          this.filters = filters;
          return this;
        }

      }

    }
  }

  /**
   * An accessor for creating requests from the Management collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Management.List request = analytics.management().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Management management() {
    return new Management();
  }

  /**
   * The "management" collection of methods.
   */
  public class Management {

    /**
     * An accessor for creating requests from the Accounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Accounts.List request = analytics.accounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Accounts accounts() {
      return new Accounts();
    }

    /**
     * The "accounts" collection of methods.
     */
    public class Accounts {

      /**
       * Lists all accounts to which the user has access.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {

        private static final String REST_PATH = "management/accounts";

        /**
         * Lists all accounts to which the user has access.
         *
         * Create a request for the method "accounts.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of accounts to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of accounts to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of accounts to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first account to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first account to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first account to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the CustomDataSources collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.CustomDataSources.List request = analytics.customDataSources().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomDataSources customDataSources() {
      return new CustomDataSources();
    }

    /**
     * The "customDataSources" collection of methods.
     */
    public class CustomDataSources {

      /**
       * List custom data sources to which the user has access.
       *
       * Create a request for the method "customDataSources.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the custom data sources to retrieve.
       * @param webPropertyId Web property Id for the custom data sources to retrieve.
       * @return the request
       */
      public List list(String accountId, String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        /**
         * List custom data sources to which the user has access.
         *
         * Create a request for the method "customDataSources.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the custom data sources to retrieve.
         * @param webPropertyId Web property Id for the custom data sources to retrieve.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account Id for the custom data sources to retrieve.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account Id for the custom data sources to retrieve. */
        public List setAccountId(String accountId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property Id for the custom data sources to retrieve.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the custom data sources to retrieve. */
        public List setWebPropertyId(String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of custom data sources to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of custom data sources to include in this response.

       [minimum: 1]
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom data sources to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * A 1-based index of the first custom data source to retrieve. Use this parameter as a
       * pagination mechanism along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** A 1-based index of the first custom data source to retrieve. Use this parameter as a pagination
       mechanism along with the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * A 1-based index of the first custom data source to retrieve. Use this parameter as a
       * pagination mechanism along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the DailyUploads collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.DailyUploads.List request = analytics.dailyUploads().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DailyUploads dailyUploads() {
      return new DailyUploads();
    }

    /**
     * The "dailyUploads" collection of methods.
     */
    public class DailyUploads {

      /**
       * Delete uploaded data for the given date.
       *
       * Create a request for the method "dailyUploads.delete".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id associated with daily upload delete.
       * @param webPropertyId Web property Id associated with daily upload delete.
       * @param customDataSourceId Custom data source Id associated with daily upload delete.
       * @param date Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
       * @param type Type of data for this delete.
       * @return the request
       */
      public Delete delete(String accountId, String webPropertyId, String customDataSourceId, String date, String type) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, customDataSourceId, date, type);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("[0-9]+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-[0-9]+-[0-9]+");

        private final java.util.regex.Pattern DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * Delete uploaded data for the given date.
         *
         * Create a request for the method "dailyUploads.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id associated with daily upload delete.
         * @param webPropertyId Web property Id associated with daily upload delete.
         * @param customDataSourceId Custom data source Id associated with daily upload delete.
         * @param date Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
         * @param type Type of data for this delete.
         * @since 1.13
         */
        protected Delete(String accountId, String webPropertyId, String customDataSourceId, String date, String type) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.customDataSourceId = Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.type = Preconditions.checkNotNull(type, "Required parameter type must be specified.");
        }

        @Override
        public Delete setAlt(String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account Id associated with daily upload delete.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account Id associated with daily upload delete. */
        public Delete setAccountId(String accountId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property Id associated with daily upload delete.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id associated with daily upload delete. */
        public Delete setWebPropertyId(String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private String customDataSourceId;

        /** Custom data source Id associated with daily upload delete.
         */
        public String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id associated with daily upload delete. */
        public Delete setCustomDataSourceId(String customDataSourceId) {
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD. */
        @com.google.api.client.util.Key
        private String date;

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
         */
        public String getDate() {
          return date;
        }

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD. */
        public Delete setDate(String date) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.date = date;
          return this;
        }

        /** Type of data for this delete. */
        @com.google.api.client.util.Key
        private String type;

        /** Type of data for this delete.
         */
        public String getType() {
          return type;
        }

        /** Type of data for this delete. */
        public Delete setType(String type) {
          this.type = type;
          return this;
        }

      }
      /**
       * List daily uploads to which the user has access.
       *
       * Create a request for the method "dailyUploads.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the daily uploads to retrieve.
       * @param webPropertyId Web property Id for the daily uploads to retrieve.
       * @param customDataSourceId Custom data source Id for daily uploads to retrieve.
       * @param startDate Start date of the form YYYY-MM-DD.
       * @param endDate End date of the form YYYY-MM-DD.
       * @return the request
       */
      public List list(String accountId, String webPropertyId, String customDataSourceId, String startDate, String endDate) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, customDataSourceId, startDate, endDate);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.DailyUploads> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern CUSTOMDATASOURCEID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * List daily uploads to which the user has access.
         *
         * Create a request for the method "dailyUploads.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the daily uploads to retrieve.
         * @param webPropertyId Web property Id for the daily uploads to retrieve.
         * @param customDataSourceId Custom data source Id for daily uploads to retrieve.
         * @param startDate Start date of the form YYYY-MM-DD.
         * @param endDate End date of the form YYYY-MM-DD.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId, String customDataSourceId, String startDate, String endDate) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.DailyUploads.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.customDataSourceId = Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(CUSTOMDATASOURCEID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.startDate = Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account Id for the daily uploads to retrieve.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account Id for the daily uploads to retrieve. */
        public List setAccountId(String accountId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property Id for the daily uploads to retrieve.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the daily uploads to retrieve. */
        public List setWebPropertyId(String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id for daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private String customDataSourceId;

        /** Custom data source Id for daily uploads to retrieve.
         */
        public String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id for daily uploads to retrieve. */
        public List setCustomDataSourceId(String customDataSourceId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(CUSTOMDATASOURCEID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Start date of the form YYYY-MM-DD. */
        @com.google.api.client.util.Key("start-date")
        private String startDate;

        /** Start date of the form YYYY-MM-DD.
         */
        public String getStartDate() {
          return startDate;
        }

        /** Start date of the form YYYY-MM-DD. */
        public List setStartDate(String startDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /** End date of the form YYYY-MM-DD. */
        @com.google.api.client.util.Key("end-date")
        private String endDate;

        /** End date of the form YYYY-MM-DD.
         */
        public String getEndDate() {
          return endDate;
        }

        /** End date of the form YYYY-MM-DD. */
        public List setEndDate(String endDate) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /** The maximum number of custom data sources to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of custom data sources to include in this response.

       [minimum: 1]
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom data sources to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }
      /**
       * Update/Overwrite data for a custom data source.
       *
       * Create a request for the method "dailyUploads.upload".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id associated with daily upload.
       * @param webPropertyId Web property Id associated with daily upload.
       * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
       * @param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
       * @param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]
       * @param type Type of data for this upload.
       * @return the request
       */
      public Upload upload(String accountId, String webPropertyId, String customDataSourceId, String date, Integer appendNumber, String type) throws java.io.IOException {
        Upload result = new Upload(accountId, webPropertyId, customDataSourceId, date, appendNumber, type);
        initialize(result);
        return result;
      }

      /**
       * Update/Overwrite data for a custom data source.
       *
       * Create a request for the method "dailyUploads.upload".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param accountId Account Id associated with daily upload.@param webPropertyId Web property Id associated with daily upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.@param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.@param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]@param type Type of data for this upload.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(String accountId, String webPropertyId, String customDataSourceId, String date, Integer appendNumber, String type,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(accountId, webPropertyId, customDataSourceId, date, appendNumber, type, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AnalyticsRequest<com.google.api.services.analytics.model.DailyUploadAppend> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}/uploads";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-\\d+-\\d+");

        private final java.util.regex.Pattern DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * Update/Overwrite data for a custom data source.
         *
         * Create a request for the method "dailyUploads.upload".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link Upload#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id associated with daily upload.
         * @param webPropertyId Web property Id associated with daily upload.
         * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
         * @param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
         * @param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]
         * @param type Type of data for this upload.
         * @since 1.13
         */
        protected Upload(String accountId, String webPropertyId, String customDataSourceId, String date, Integer appendNumber, String type) {
          super(Analytics.this, "POST", REST_PATH, null, com.google.api.services.analytics.model.DailyUploadAppend.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.customDataSourceId = Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.appendNumber = Preconditions.checkNotNull(appendNumber, "Required parameter appendNumber must be specified.");
          this.type = Preconditions.checkNotNull(type, "Required parameter type must be specified.");
        }

        /**
         * Update/Overwrite data for a custom data source.
         *
         * Create a request for the method "dailyUploads.upload".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link Upload#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param accountId Account Id associated with daily upload.@param webPropertyId Web property Id associated with daily upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.@param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.@param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]@param type Type of data for this upload.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(String accountId, String webPropertyId, String customDataSourceId, String date, Integer appendNumber, String type,
            com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Analytics.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.analytics.model.DailyUploadAppend.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDataSourceId = Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          this.appendNumber = Preconditions.checkNotNull(appendNumber, "Required parameter appendNumber must be specified.");
          this.type = Preconditions.checkNotNull(type, "Required parameter type must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload setAlt(String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setFields(String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUserIp(String userIp) {
          return (Upload) super.setUserIp(userIp);
        }

        /** Account Id associated with daily upload. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account Id associated with daily upload.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account Id associated with daily upload. */
        public Upload setAccountId(String accountId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id associated with daily upload. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property Id associated with daily upload.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id associated with daily upload. */
        public Upload setWebPropertyId(String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        @com.google.api.client.util.Key
        private String customDataSourceId;

        /** Custom data source Id to which the data being uploaded belongs.
         */
        public String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        public Upload setCustomDataSourceId(String customDataSourceId) {
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD. */
        @com.google.api.client.util.Key
        private String date;

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
         */
        public String getDate() {
          return date;
        }

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD. */
        public Upload setDate(String date) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.date = date;
          return this;
        }

        /** Append number for this upload indexed from 1. */
        @com.google.api.client.util.Key
        private Integer appendNumber;

        /** Append number for this upload indexed from 1.

       [minimum: 1] [maximum: 20]
         */
        public Integer getAppendNumber() {
          return appendNumber;
        }

        /** Append number for this upload indexed from 1. */
        public Upload setAppendNumber(Integer appendNumber) {
          this.appendNumber = appendNumber;
          return this;
        }

        /** Type of data for this upload. */
        @com.google.api.client.util.Key
        private String type;

        /** Type of data for this upload.
         */
        public String getType() {
          return type;
        }

        /** Type of data for this upload. */
        public Upload setType(String type) {
          this.type = type;
          return this;
        }

        /**
       * Reset/Overwrite all previous appends for this date and start over with this file as the
       * first upload.
       */
        @com.google.api.client.util.Key
        private Boolean reset;

        /** Reset/Overwrite all previous appends for this date and start over with this file as the first
       upload. [default: false]
         */
        public Boolean getReset() {
          return reset;
        }

        /**
       * Reset/Overwrite all previous appends for this date and start over with this file as the
       * first upload.
       */
        public Upload setReset(Boolean reset) {
          this.reset = reset;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Reset/Overwrite all previous appends for this date and start over with this file as the first
       upload.
         * </p>
         */
        public boolean isReset() {
          if (reset == null || reset == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return reset;
        }

      }

    }
    /**
     * An accessor for creating requests from the Experiments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Experiments.List request = analytics.experiments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Experiments experiments() {
      return new Experiments();
    }

    /**
     * The "experiments" collection of methods.
     */
    public class Experiments {

      /**
       * Delete an experiment.
       *
       * Create a request for the method "experiments.delete".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the experiment belongs
       * @param webPropertyId Web property ID to which the experiment belongs
       * @param profileId Profile ID to which the experiment belongs
       * @param experimentId ID of the experiment to delete
       * @return the request
       */
      public Delete delete(String accountId, String webPropertyId, String profileId, String experimentId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Delete an experiment.
         *
         * Create a request for the method "experiments.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the experiment belongs
         * @param webPropertyId Web property ID to which the experiment belongs
         * @param profileId Profile ID to which the experiment belongs
         * @param experimentId ID of the experiment to delete
         * @since 1.13
         */
        protected Delete(String accountId, String webPropertyId, String profileId, String experimentId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public Delete setAlt(String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to which the experiment belongs
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID to which the experiment belongs */
        public Delete setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to which the experiment belongs
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to which the experiment belongs */
        public Delete setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to which the experiment belongs
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID to which the experiment belongs */
        public Delete setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** ID of the experiment to delete */
        @com.google.api.client.util.Key
        private String experimentId;

        /** ID of the experiment to delete
         */
        public String getExperimentId() {
          return experimentId;
        }

        /** ID of the experiment to delete */
        public Delete setExperimentId(String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

      }
      /**
       * Returns an experiment to which the user has access.
       *
       * Create a request for the method "experiments.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the experiment for.
       * @param webPropertyId Web property ID to retrieve the experiment for.
       * @param profileId Profile ID to retrieve the experiment for.
       * @param experimentId Experiment ID to retrieve the experiment for.
       * @return the request
       */
      public Get get(String accountId, String webPropertyId, String profileId, String experimentId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Returns an experiment to which the user has access.
         *
         * Create a request for the method "experiments.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the experiment for.
         * @param webPropertyId Web property ID to retrieve the experiment for.
         * @param profileId Profile ID to retrieve the experiment for.
         * @param experimentId Experiment ID to retrieve the experiment for.
         * @since 1.13
         */
        protected Get(String accountId, String webPropertyId, String profileId, String experimentId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve the experiment for.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the experiment for. */
        public Get setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to retrieve the experiment for.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the experiment for. */
        public Get setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to retrieve the experiment for.
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID to retrieve the experiment for. */
        public Get setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private String experimentId;

        /** Experiment ID to retrieve the experiment for.
         */
        public String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID to retrieve the experiment for. */
        public Get setExperimentId(String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

      }
      /**
       * Create a new experiment.
       *
       * Create a request for the method "experiments.insert".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the experiment for.
       * @param webPropertyId Web property ID to create the experiment for.
       * @param profileId Profile ID to create the experiment for.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Insert insert(String accountId, String webPropertyId, String profileId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        /**
         * Create a new experiment.
         *
         * Create a request for the method "experiments.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the experiment for.
         * @param webPropertyId Web property ID to create the experiment for.
         * @param profileId Profile ID to create the experiment for.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Insert(String accountId, String webPropertyId, String profileId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Insert setAlt(String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the experiment for. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to create the experiment for.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID to create the experiment for. */
        public Insert setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the experiment for. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to create the experiment for.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the experiment for. */
        public Insert setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to create the experiment for. */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to create the experiment for.
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID to create the experiment for. */
        public Insert setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

      }
      /**
       * Lists experiments to which the user has access.
       *
       * Create a request for the method "experiments.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve experiments for.
       * @param webPropertyId Web property ID to retrieve experiments for.
       * @param profileId Profile ID to retrieve experiments for.
       * @return the request
       */
      public List list(String accountId, String webPropertyId, String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILEID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists experiments to which the user has access.
         *
         * Create a request for the method "experiments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve experiments for.
         * @param webPropertyId Web property ID to retrieve experiments for.
         * @param profileId Profile ID to retrieve experiments for.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId, String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(PROFILEID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve experiments for.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve experiments for. */
        public List setAccountId(String accountId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to retrieve experiments for.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve experiments for. */
        public List setWebPropertyId(String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to retrieve experiments for.
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID to retrieve experiments for. */
        public List setProfileId(String profileId) {
          if (!getSuppressPatternChecks()) {
            Preconditions.checkArgument(PROFILEID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of experiments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of experiments to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of experiments to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first experiment to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first experiment to retrieve. Use this parameter as a pagination mechanism along
       with the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first experiment to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }
      /**
       * Update an existing experiment. This method supports patch semantics.
       *
       * Create a request for the method "experiments.patch".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId Profile ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Patch patch(String accountId, String webPropertyId, String profileId, String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment. This method supports patch semantics.
         *
         * Create a request for the method "experiments.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link Patch#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId Profile ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Patch(String accountId, String webPropertyId, String profileId, String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public Patch setAlt(String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID of the experiment to update.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Patch setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Patch setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID of the experiment to update.
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID of the experiment to update. */
        public Patch setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Patch setExperimentId(String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

      }
      /**
       * Update an existing experiment.
       *
       * Create a request for the method "experiments.update".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId Profile ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Update update(String accountId, String webPropertyId, String profileId, String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment.
         *
         * Create a request for the method "experiments.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link Update#initialize(AbstractGoogleClientRequest)} must be called to initialize this
         * instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId Profile ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Update(String accountId, String webPropertyId, String profileId, String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public Update setAlt(String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID of the experiment to update.
         */
        public String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Update setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Update setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID of the experiment to update.
         */
        public String getProfileId() {
          return profileId;
        }

        /** Profile ID of the experiment to update. */
        public Update setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Update setExperimentId(String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Goals collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Goals.List request = analytics.goals().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Goals goals() {
      return new Goals();
    }

    /**
     * The "goals" collection of methods.
     */
    public class Goals {

      /**
       * Lists goals to which the user has access.
       *
       * Create a request for the method "goals.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
       * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
       * @param profileId Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to all
       *        the profiles that user has access to.
       * @return the request
       */
      public List list(String accountId, String webPropertyId, String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";

        /**
         * Lists goals to which the user has access.
         *
         * Create a request for the method "goals.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
         * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
         * @param profileId Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to all
       *        the profiles that user has access to.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId, String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
       * refers to all the accounts that user has access to.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to
       all the accounts that user has access to.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
       * refers to all the accounts that user has access to.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
       * Web property ID to retrieve goals for. Can either be a specific web property ID or '~all',
       * which refers to all the web properties that user has access to.
       */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       refers to all the web properties that user has access to.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /**
       * Web property ID to retrieve goals for. Can either be a specific web property ID or '~all',
       * which refers to all the web properties that user has access to.
       */
        public List setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
       * Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which
       * refers to all the profiles that user has access to.
       */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to
       all the profiles that user has access to.
         */
        public String getProfileId() {
          return profileId;
        }

        /**
       * Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which
       * refers to all the profiles that user has access to.
       */
        public List setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of goals to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of goals to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of goals to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first goal to retrieve. Use this parameter as a pagination mechanism along
       * with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the
       max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first goal to retrieve. Use this parameter as a pagination mechanism along
       * with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Profiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Profiles.List request = analytics.profiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Profiles profiles() {
      return new Profiles();
    }

    /**
     * The "profiles" collection of methods.
     */
    public class Profiles {

      /**
       * Lists profiles to which the user has access.
       *
       * Create a request for the method "profiles.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which refers
       *        to all the accounts to which the user has access.
       * @param webPropertyId Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties to which the user has access.
       * @return the request
       */
      public List list(String accountId, String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";

        /**
         * Lists profiles to which the user has access.
         *
         * Create a request for the method "profiles.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which refers
       *        to all the accounts to which the user has access.
         * @param webPropertyId Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties to which the user has access.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID for the profiles to retrieve. Can either be a specific account ID or '~all',
       * which refers to all the accounts to which the user has access.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which
       refers to all the accounts to which the user has access.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID for the profiles to retrieve. Can either be a specific account ID or '~all',
       * which refers to all the accounts to which the user has access.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
       * Web property ID for the profiles to retrieve. Can either be a specific web property ID or
       * '~all', which refers to all the web properties to which the user has access.
       */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       which refers to all the web properties to which the user has access.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /**
       * Web property ID for the profiles to retrieve. Can either be a specific web property ID or
       * '~all', which refers to all the web properties to which the user has access.
       */
        public List setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of profiles to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of profiles to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of profiles to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Segments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Segments.List request = analytics.segments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Segments segments() {
      return new Segments();
    }

    /**
     * The "segments" collection of methods.
     */
    public class Segments {

      /**
       * Lists advanced segments to which the user has access.
       *
       * Create a request for the method "segments.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {

        private static final String REST_PATH = "management/segments";

        /**
         * Lists advanced segments to which the user has access.
         *
         * Create a request for the method "segments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of advanced segments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of advanced segments to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of advanced segments to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first advanced segment to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first advanced segment to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first advanced segment to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Webproperties collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Webproperties.List request = analytics.webproperties().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Webproperties webproperties() {
      return new Webproperties();
    }

    /**
     * The "webproperties" collection of methods.
     */
    public class Webproperties {

      /**
       * Lists web properties to which the user has access.
       *
       * Create a request for the method "webproperties.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
       * @return the request
       */
      public List list(String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties";

        /**
         * Lists web properties to which the user has access.
         *
         * Create a request for the method "webproperties.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
         * @since 1.13
         */
        protected List(String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
       * which refers to all the accounts that user has access to.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       refers to all the accounts that user has access to.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
       * which refers to all the accounts that user has access to.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of web properties to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of web properties to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of web properties to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
  }

  /**
   * Builder for {@link Analytics}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Analytics}. */
    @Override
    public Analytics build() {
      return new Analytics(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link AnalyticsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsRequestInitializer(
        AnalyticsRequestInitializer analyticsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
