/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 18:51:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics remarketing audience.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemarketingAudience extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this remarketing audience belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * The simple audience definition that will cause a user to be added to an audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AudienceDefinition audienceDefinition;

  /**
   * The type of audience, either SIMPLE or STATE_BASED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String audienceType;

  /**
   * Time this remarketing audience was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * The description of this remarketing audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Remarketing Audience ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this remarketing audience belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Collection type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The linked ad accounts associated with this remarketing audience. A remarketing audience can
   * have only one linkedAdAccount currently.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LinkedForeignAccount> linkedAdAccounts;

  static {
    // hack to force ProGuard to consider LinkedForeignAccount used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LinkedForeignAccount.class);
  }

  /**
   * The views (profiles) that this remarketing audience is linked to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> linkedViews;

  /**
   * The name of this remarketing audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A state based audience definition that will cause a user to be added or removed from an
   * audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StateBasedAudienceDefinition stateBasedAudienceDefinition;

  /**
   * Time this remarketing audience was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this remarketing audience belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this remarketing audience belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this remarketing audience belongs.
   * @param accountId accountId or {@code null} for none
   */
  public RemarketingAudience setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The simple audience definition that will cause a user to be added to an audience.
   * @return value or {@code null} for none
   */
  public AudienceDefinition getAudienceDefinition() {
    return audienceDefinition;
  }

  /**
   * The simple audience definition that will cause a user to be added to an audience.
   * @param audienceDefinition audienceDefinition or {@code null} for none
   */
  public RemarketingAudience setAudienceDefinition(AudienceDefinition audienceDefinition) {
    this.audienceDefinition = audienceDefinition;
    return this;
  }

  /**
   * The type of audience, either SIMPLE or STATE_BASED.
   * @return value or {@code null} for none
   */
  public java.lang.String getAudienceType() {
    return audienceType;
  }

  /**
   * The type of audience, either SIMPLE or STATE_BASED.
   * @param audienceType audienceType or {@code null} for none
   */
  public RemarketingAudience setAudienceType(java.lang.String audienceType) {
    this.audienceType = audienceType;
    return this;
  }

  /**
   * Time this remarketing audience was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this remarketing audience was created.
   * @param created created or {@code null} for none
   */
  public RemarketingAudience setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * The description of this remarketing audience.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this remarketing audience.
   * @param description description or {@code null} for none
   */
  public RemarketingAudience setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Remarketing Audience ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Remarketing Audience ID.
   * @param id id or {@code null} for none
   */
  public RemarketingAudience setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this remarketing audience belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this remarketing audience belongs.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public RemarketingAudience setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Collection type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Collection type.
   * @param kind kind or {@code null} for none
   */
  public RemarketingAudience setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The linked ad accounts associated with this remarketing audience. A remarketing audience can
   * have only one linkedAdAccount currently.
   * @return value or {@code null} for none
   */
  public java.util.List<LinkedForeignAccount> getLinkedAdAccounts() {
    return linkedAdAccounts;
  }

  /**
   * The linked ad accounts associated with this remarketing audience. A remarketing audience can
   * have only one linkedAdAccount currently.
   * @param linkedAdAccounts linkedAdAccounts or {@code null} for none
   */
  public RemarketingAudience setLinkedAdAccounts(java.util.List<LinkedForeignAccount> linkedAdAccounts) {
    this.linkedAdAccounts = linkedAdAccounts;
    return this;
  }

  /**
   * The views (profiles) that this remarketing audience is linked to.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLinkedViews() {
    return linkedViews;
  }

  /**
   * The views (profiles) that this remarketing audience is linked to.
   * @param linkedViews linkedViews or {@code null} for none
   */
  public RemarketingAudience setLinkedViews(java.util.List<java.lang.String> linkedViews) {
    this.linkedViews = linkedViews;
    return this;
  }

  /**
   * The name of this remarketing audience.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this remarketing audience.
   * @param name name or {@code null} for none
   */
  public RemarketingAudience setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A state based audience definition that will cause a user to be added or removed from an
   * audience.
   * @return value or {@code null} for none
   */
  public StateBasedAudienceDefinition getStateBasedAudienceDefinition() {
    return stateBasedAudienceDefinition;
  }

  /**
   * A state based audience definition that will cause a user to be added or removed from an
   * audience.
   * @param stateBasedAudienceDefinition stateBasedAudienceDefinition or {@code null} for none
   */
  public RemarketingAudience setStateBasedAudienceDefinition(StateBasedAudienceDefinition stateBasedAudienceDefinition) {
    this.stateBasedAudienceDefinition = stateBasedAudienceDefinition;
    return this;
  }

  /**
   * Time this remarketing audience was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this remarketing audience was last modified.
   * @param updated updated or {@code null} for none
   */
  public RemarketingAudience setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this remarketing audience belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this remarketing audience belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public RemarketingAudience setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public RemarketingAudience set(String fieldName, Object value) {
    return (RemarketingAudience) super.set(fieldName, value);
  }

  @Override
  public RemarketingAudience clone() {
    return (RemarketingAudience) super.clone();
  }

  /**
   * The simple audience definition that will cause a user to be added to an audience.
   */
  public static final class AudienceDefinition extends com.google.api.client.json.GenericJson {

    /**
     * Defines the conditions to include users to the audience.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private IncludeConditions includeConditions;

    /**
     * Defines the conditions to include users to the audience.
     * @return value or {@code null} for none
     */
    public IncludeConditions getIncludeConditions() {
      return includeConditions;
    }

    /**
     * Defines the conditions to include users to the audience.
     * @param includeConditions includeConditions or {@code null} for none
     */
    public AudienceDefinition setIncludeConditions(IncludeConditions includeConditions) {
      this.includeConditions = includeConditions;
      return this;
    }

    @Override
    public AudienceDefinition set(String fieldName, Object value) {
      return (AudienceDefinition) super.set(fieldName, value);
    }

    @Override
    public AudienceDefinition clone() {
      return (AudienceDefinition) super.clone();
    }

  }

  /**
   * A state based audience definition that will cause a user to be added or removed from an audience.
   */
  public static final class StateBasedAudienceDefinition extends com.google.api.client.json.GenericJson {

    /**
     * Defines the conditions to exclude users from the audience.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ExcludeConditions excludeConditions;

    /**
     * Defines the conditions to include users to the audience.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private IncludeConditions includeConditions;

    /**
     * Defines the conditions to exclude users from the audience.
     * @return value or {@code null} for none
     */
    public ExcludeConditions getExcludeConditions() {
      return excludeConditions;
    }

    /**
     * Defines the conditions to exclude users from the audience.
     * @param excludeConditions excludeConditions or {@code null} for none
     */
    public StateBasedAudienceDefinition setExcludeConditions(ExcludeConditions excludeConditions) {
      this.excludeConditions = excludeConditions;
      return this;
    }

    /**
     * Defines the conditions to include users to the audience.
     * @return value or {@code null} for none
     */
    public IncludeConditions getIncludeConditions() {
      return includeConditions;
    }

    /**
     * Defines the conditions to include users to the audience.
     * @param includeConditions includeConditions or {@code null} for none
     */
    public StateBasedAudienceDefinition setIncludeConditions(IncludeConditions includeConditions) {
      this.includeConditions = includeConditions;
      return this;
    }

    @Override
    public StateBasedAudienceDefinition set(String fieldName, Object value) {
      return (StateBasedAudienceDefinition) super.set(fieldName, value);
    }

    @Override
    public StateBasedAudienceDefinition clone() {
      return (StateBasedAudienceDefinition) super.clone();
    }

    /**
     * Defines the conditions to exclude users from the audience.
     */
    public static final class ExcludeConditions extends com.google.api.client.json.GenericJson {

      /**
       * Whether to make the exclusion TEMPORARY or PERMANENT.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String exclusionDuration;

      /**
       * The segment condition that will cause a user to be removed from an audience.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String segment;

      /**
       * Whether to make the exclusion TEMPORARY or PERMANENT.
       * @return value or {@code null} for none
       */
      public java.lang.String getExclusionDuration() {
        return exclusionDuration;
      }

      /**
       * Whether to make the exclusion TEMPORARY or PERMANENT.
       * @param exclusionDuration exclusionDuration or {@code null} for none
       */
      public ExcludeConditions setExclusionDuration(java.lang.String exclusionDuration) {
        this.exclusionDuration = exclusionDuration;
        return this;
      }

      /**
       * The segment condition that will cause a user to be removed from an audience.
       * @return value or {@code null} for none
       */
      public java.lang.String getSegment() {
        return segment;
      }

      /**
       * The segment condition that will cause a user to be removed from an audience.
       * @param segment segment or {@code null} for none
       */
      public ExcludeConditions setSegment(java.lang.String segment) {
        this.segment = segment;
        return this;
      }

      @Override
      public ExcludeConditions set(String fieldName, Object value) {
        return (ExcludeConditions) super.set(fieldName, value);
      }

      @Override
      public ExcludeConditions clone() {
        return (ExcludeConditions) super.clone();
      }

    }
  }

}
