/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-10-17 16:43:55 UTC)
 * on 2016-11-16 at 06:11:13 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for Analytics unsampled report resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UnsampledReport extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this unsampled report belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Download details for a file stored in Google Cloud Storage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CloudStorageDownloadDetails cloudStorageDownloadDetails;

  /**
   * Time this unsampled report was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * The dimensions for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensions;

  /**
   * The type of download you need to use for the report data file. Possible values include
   * `GOOGLE_DRIVE` and `GOOGLE_CLOUD_STORAGE`. If the value is `GOOGLE_DRIVE`, see the
   * `driveDownloadDetails` field. If the value is `GOOGLE_CLOUD_STORAGE`, see the
   * `cloudStorageDownloadDetails` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadType;

  /**
   * Download details for a file stored in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DriveDownloadDetails driveDownloadDetails;

  /**
   * The end date for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("end-date")
  private java.lang.String endDate;

  /**
   * The filters for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filters;

  /**
   * Unsampled report ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type for an Analytics unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The metrics for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metrics;

  /**
   * View (Profile) ID to which this unsampled report belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileId;

  /**
   * The segment for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String segment;

  /**
   * Link for this unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The start date for the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("start-date")
  private java.lang.String startDate;

  /**
   * Status of this unsampled report. Possible values are PENDING, COMPLETED, or FAILED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Title of the unsampled report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Time this unsampled report was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Web property ID to which this unsampled report belongs. The web property ID is of the form UA-
   * XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this unsampled report belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this unsampled report belongs.
   * @param accountId accountId or {@code null} for none
   */
  public UnsampledReport setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Download details for a file stored in Google Cloud Storage.
   * @return value or {@code null} for none
   */
  public CloudStorageDownloadDetails getCloudStorageDownloadDetails() {
    return cloudStorageDownloadDetails;
  }

  /**
   * Download details for a file stored in Google Cloud Storage.
   * @param cloudStorageDownloadDetails cloudStorageDownloadDetails or {@code null} for none
   */
  public UnsampledReport setCloudStorageDownloadDetails(CloudStorageDownloadDetails cloudStorageDownloadDetails) {
    this.cloudStorageDownloadDetails = cloudStorageDownloadDetails;
    return this;
  }

  /**
   * Time this unsampled report was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this unsampled report was created.
   * @param created created or {@code null} for none
   */
  public UnsampledReport setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * The dimensions for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensions() {
    return dimensions;
  }

  /**
   * The dimensions for the unsampled report.
   * @param dimensions dimensions or {@code null} for none
   */
  public UnsampledReport setDimensions(java.lang.String dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * The type of download you need to use for the report data file. Possible values include
   * `GOOGLE_DRIVE` and `GOOGLE_CLOUD_STORAGE`. If the value is `GOOGLE_DRIVE`, see the
   * `driveDownloadDetails` field. If the value is `GOOGLE_CLOUD_STORAGE`, see the
   * `cloudStorageDownloadDetails` field.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadType() {
    return downloadType;
  }

  /**
   * The type of download you need to use for the report data file. Possible values include
   * `GOOGLE_DRIVE` and `GOOGLE_CLOUD_STORAGE`. If the value is `GOOGLE_DRIVE`, see the
   * `driveDownloadDetails` field. If the value is `GOOGLE_CLOUD_STORAGE`, see the
   * `cloudStorageDownloadDetails` field.
   * @param downloadType downloadType or {@code null} for none
   */
  public UnsampledReport setDownloadType(java.lang.String downloadType) {
    this.downloadType = downloadType;
    return this;
  }

  /**
   * Download details for a file stored in Google Drive.
   * @return value or {@code null} for none
   */
  public DriveDownloadDetails getDriveDownloadDetails() {
    return driveDownloadDetails;
  }

  /**
   * Download details for a file stored in Google Drive.
   * @param driveDownloadDetails driveDownloadDetails or {@code null} for none
   */
  public UnsampledReport setDriveDownloadDetails(DriveDownloadDetails driveDownloadDetails) {
    this.driveDownloadDetails = driveDownloadDetails;
    return this;
  }

  /**
   * The end date for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndDate() {
    return endDate;
  }

  /**
   * The end date for the unsampled report.
   * @param endDate endDate or {@code null} for none
   */
  public UnsampledReport setEndDate(java.lang.String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The filters for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilters() {
    return filters;
  }

  /**
   * The filters for the unsampled report.
   * @param filters filters or {@code null} for none
   */
  public UnsampledReport setFilters(java.lang.String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * Unsampled report ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unsampled report ID.
   * @param id id or {@code null} for none
   */
  public UnsampledReport setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for an Analytics unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for an Analytics unsampled report.
   * @param kind kind or {@code null} for none
   */
  public UnsampledReport setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The metrics for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetrics() {
    return metrics;
  }

  /**
   * The metrics for the unsampled report.
   * @param metrics metrics or {@code null} for none
   */
  public UnsampledReport setMetrics(java.lang.String metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * View (Profile) ID to which this unsampled report belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileId() {
    return profileId;
  }

  /**
   * View (Profile) ID to which this unsampled report belongs.
   * @param profileId profileId or {@code null} for none
   */
  public UnsampledReport setProfileId(java.lang.String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * The segment for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getSegment() {
    return segment;
  }

  /**
   * The segment for the unsampled report.
   * @param segment segment or {@code null} for none
   */
  public UnsampledReport setSegment(java.lang.String segment) {
    this.segment = segment;
    return this;
  }

  /**
   * Link for this unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this unsampled report.
   * @param selfLink selfLink or {@code null} for none
   */
  public UnsampledReport setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The start date for the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDate() {
    return startDate;
  }

  /**
   * The start date for the unsampled report.
   * @param startDate startDate or {@code null} for none
   */
  public UnsampledReport setStartDate(java.lang.String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Status of this unsampled report. Possible values are PENDING, COMPLETED, or FAILED.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of this unsampled report. Possible values are PENDING, COMPLETED, or FAILED.
   * @param status status or {@code null} for none
   */
  public UnsampledReport setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Title of the unsampled report.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the unsampled report.
   * @param title title or {@code null} for none
   */
  public UnsampledReport setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Time this unsampled report was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this unsampled report was last modified.
   * @param updated updated or {@code null} for none
   */
  public UnsampledReport setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Web property ID to which this unsampled report belongs. The web property ID is of the form UA-
   * XXXXX-YY.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID to which this unsampled report belongs. The web property ID is of the form UA-
   * XXXXX-YY.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public UnsampledReport setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public UnsampledReport set(String fieldName, Object value) {
    return (UnsampledReport) super.set(fieldName, value);
  }

  @Override
  public UnsampledReport clone() {
    return (UnsampledReport) super.clone();
  }

  /**
   * Download details for a file stored in Google Cloud Storage.
   */
  public static final class CloudStorageDownloadDetails extends com.google.api.client.json.GenericJson {

    /**
     * Id of the bucket the file object is stored in.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String bucketId;

    /**
     * Id of the file object containing the report data.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String objectId;

    /**
     * Id of the bucket the file object is stored in.
     * @return value or {@code null} for none
     */
    public java.lang.String getBucketId() {
      return bucketId;
    }

    /**
     * Id of the bucket the file object is stored in.
     * @param bucketId bucketId or {@code null} for none
     */
    public CloudStorageDownloadDetails setBucketId(java.lang.String bucketId) {
      this.bucketId = bucketId;
      return this;
    }

    /**
     * Id of the file object containing the report data.
     * @return value or {@code null} for none
     */
    public java.lang.String getObjectId() {
      return objectId;
    }

    /**
     * Id of the file object containing the report data.
     * @param objectId objectId or {@code null} for none
     */
    public CloudStorageDownloadDetails setObjectId(java.lang.String objectId) {
      this.objectId = objectId;
      return this;
    }

    @Override
    public CloudStorageDownloadDetails set(String fieldName, Object value) {
      return (CloudStorageDownloadDetails) super.set(fieldName, value);
    }

    @Override
    public CloudStorageDownloadDetails clone() {
      return (CloudStorageDownloadDetails) super.clone();
    }

  }

  /**
   * Download details for a file stored in Google Drive.
   */
  public static final class DriveDownloadDetails extends com.google.api.client.json.GenericJson {

    /**
     * Id of the document/file containing the report data.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String documentId;

    /**
     * Id of the document/file containing the report data.
     * @return value or {@code null} for none
     */
    public java.lang.String getDocumentId() {
      return documentId;
    }

    /**
     * Id of the document/file containing the report data.
     * @param documentId documentId or {@code null} for none
     */
    public DriveDownloadDetails setDocumentId(java.lang.String documentId) {
      this.documentId = documentId;
      return this;
    }

    @Override
    public DriveDownloadDetails set(String fieldName, Object value) {
      return (DriveDownloadDetails) super.set(fieldName, value);
    }

    @Override
    public DriveDownloadDetails clone() {
      return (DriveDownloadDetails) super.clone();
    }

  }

}
